-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

CREATE TABLE EPS_PROP_STANDALONE_BUDGET
(
    ID VARCHAR(25) NOT NULL,
    PROPOSAL_NUMBER VARCHAR(12) NOT NULL,
    BUDGET_ID VARCHAR(50) NOT NULL,
    DESCRIPTION VARCHAR(255) NOT NULL,
    STATUS VARCHAR(255) NOT NULL,
    UPDATE_TIMESTAMP DATETIME NOT NULL,
    UPDATE_USER VARCHAR(60) NOT NULL,
    OBJ_ID VARCHAR(36) NOT NULL,
    VER_NBR DECIMAL(8) default 1 NOT NULL
);

ALTER TABLE EPS_PROP_STANDALONE_BUDGET
    ADD CONSTRAINT EPS_PROP_STANDALONE_BUDGETP1
        PRIMARY KEY (ID);

ALTER TABLE EPS_PROP_STANDALONE_BUDGET
    ADD CONSTRAINT EPS_PROP_STANDALONE_BUDGETUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE EPS_PROP_STANDALONE_BUDGET
    ADD CONSTRAINT EPS_PROP_STANDALONE_BUDGETUQ2
        UNIQUE(BUDGET_ID);

ALTER TABLE EPS_PROP_STANDALONE_BUDGET
    ADD CONSTRAINT EPS_PROP_STANDALONE_BUDGETFK1
        FOREIGN KEY (PROPOSAL_NUMBER)
            REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

CREATE TABLE SEQ_EPS_PROP_STANDALONE_BUDGET_ID (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE SEQ_EPS_PROP_STANDALONE_BUDGET_ID AUTO_INCREMENT = 1;
