-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

CREATE TABLE SUBAWARD_MODIFICATION_TYPE (
  CODE varchar(30) PRIMARY KEY,
  DESCRIPTION varchar(2000) NOT NULL,
  ACTIVE CHAR(1) NOT NULL DEFAULT 'Y',
  UPDATE_USER VARCHAR(60) NOT NULL,
  UPDATE_TIMESTAMP DATETIME NOT NULL,
  VER_NBR DECIMAL (8,0) NOT NULL DEFAULT 1,
  OBJ_ID VARCHAR(36) NOT NULL) character set utf8 collate utf8_bin;
  
alter table SUBAWARD_AMOUNT_INFO add MODIFICATION_TYPE_CODE varchar(30);
alter table SUBAWARD_AMOUNT_INFO add constraint FK3_SUBAWARD_AMOUNT_INFO foreign key (MODIFICATION_TYPE_CODE)
    REFERENCES SUBAWARD_MODIFICATION_TYPE (CODE);
    
insert into subaward_modification_type (code, description, active, update_user, update_timestamp, ver_nbr, obj_id)
	values ('RESBOOT1000', 'No Cost Extension', 'Y', 'admin', now(), 1, uuid());
	
insert into subaward_modification_type (code, description, active, update_user, update_timestamp, ver_nbr, obj_id)
	values ('RESBOOT1001', 'Increment', 'Y', 'admin', now(), 1, uuid());

insert into subaward_modification_type (code, description, active, update_user, update_timestamp, ver_nbr, obj_id)
	values ('RESBOOT1002', 'Continuation of Other', 'Y', 'admin', now(), 1, uuid());


	