-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DROP TABLE IF EXISTS SUBAWARD_FFATA_REPORTING_ID_S;

CREATE TABLE SUBAWARD_FFATA_REPORTING_ID_S (
  id bigint(19) not null auto_increment, primary key (id)
) ENGINE MyISAM;

ALTER TABLE SUBAWARD_FFATA_REPORTING_ID_S auto_increment = 1;

DROP TABLE IF EXISTS SUBAWARD_FFATA_REPORTING;

CREATE TABLE SUBAWARD_FFATA_REPORTING (
  SUBAWARD_FFATA_REPORTING_ID decimal(12,0) PRIMARY KEY,
  SUBAWARD_ID decimal(12,0) NOT NULL,
  SUBAWARD_AMOUNT_INFO_ID decimal(12,0),
  OTHER_TRANS_DESC varchar(100),
  DATE_SUBMITTED DATETIME NOT NULL,
  SUBMITTER_ID VARCHAR(40) NOT NULL,
  COMMENTS LONGTEXT,
  FILE_DATA_ID varchar(36),
  FILE_NAME varchar(150),
  MIME_TYPE varchar(100),
  UPDATE_USER VARCHAR(60) NOT NULL,
  UPDATE_TIMESTAMP DATETIME NOT NULL,
  VER_NBR DECIMAL (8,0) NOT NULL DEFAULT 1,
  OBJ_ID VARCHAR(36) NOT NULL) character set utf8 collate utf8_bin;


alter table SUBAWARD_FFATA_REPORTING add constraint FK1_SUBAWARD_FFATA_REPORTING foreign key (SUBAWARD_ID)
REFERENCES SUBAWARD (SUBAWARD_ID);

alter table SUBAWARD_FFATA_REPORTING add constraint FK2_SUBAWARD_FFATA_REPORTING foreign key (SUBAWARD_AMOUNT_INFO_ID)
REFERENCES SUBAWARD_AMOUNT_INFO (SUBAWARD_AMOUNT_INFO_ID);

alter table SUBAWARD_FFATA_REPORTING add constraint FK3_SUBAWARD_FFATA_REPORTING foreign key (FILE_DATA_ID)
REFERENCES FILE_DATA (ID);