-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

CREATE TABLE eps_prop_spl_review_attachment (
	PROPOSAL_SPECIAL_REVIEW_ATT_ID decimal(12,0) NOT NULL,
	FILE_NAME varchar(150) DEFAULT NULL,
	CONTENT_TYPE varchar(255)DEFAULT NULL,
	STUDY_TITLE varchar(600),
	IS_ATTACHMENT_DELAYED_ONSET char(1),
	CLINICAL_TRIAL char(1),
	UPDATE_USER varchar(60) NOT NULL,
	UPDATE_TIMESTAMP datetime NOT NULL,
	VER_NBR decimal(8,0) NOT NULL DEFAULT '1',
	OBJ_ID varchar(36) NOT NULL,
	FILE_DATA_ID varchar(36) NOT NULL,
	UPLOAD_TIMESTAMP datetime NOT NULL,
	UPLOAD_USER varchar(100) NOT NULL,
	PRIMARY KEY (PROPOSAL_SPECIAL_REVIEW_ATT_ID),
	CONSTRAINT FK_SPL_RVW_FILE_ID FOREIGN KEY (FILE_DATA_ID) REFERENCES file_data (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE SEQ_EPS_PROP_SPL_RVW_ATT_ID
(
    id bigint(19) not null auto_increment, primary key (id)
) ENGINE MyISAM;

alter table EPS_PROP_SPECIAL_REVIEW add PROPOSAL_SPECIAL_REVIEW_ATT_ID decimal(12,0);

INSERT INTO SEQ_S2S_FORM_CONFIG_ID VALUES (NULL);
INSERT INTO S2S_FORM_CONFIG(S2S_FORM_CONFIG_ID,FORM_NAME,ACTIVE_FLAG,INACTIVE_MESSAGE,VER_NBR,OBJ_ID,UPDATE_TIMESTAMP,UPDATE_USER) VALUES
    ((SELECT MAX(id) FROM SEQ_S2S_FORM_CONFIG_ID),'PHS_HumanSubjectsAndClinicalTrialsInfo_V1.0','N','The form is still undergoing testing. Expect it to be available soon.','1',UUID(),NOW(),'admin');