-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

ALTER TABLE AWARD_TYPE
    ADD ACTV_IND VARCHAR(1) DEFAULT 'Y' NOT NULL;

ALTER TABLE AWARD_TYPE
    ADD SORT_ID DECIMAL(12, 0);

DELIMITER /

DROP PROCEDURE IF EXISTS p
/
CREATE PROCEDURE p()
BEGIN
    DECLARE COUNTER INT DEFAULT 1;
    DECLARE V_AWARD_TYPE_CODE DECIMAL(3, 0);
    DECLARE DONE INT DEFAULT FALSE;

    DECLARE ATC_CUR CURSOR FOR SELECT AWARD_TYPE_CODE FROM AWARD_TYPE ORDER BY DESCRIPTION;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET DONE = TRUE;

    OPEN ATC_CUR;

    main_loop:
        LOOP
            FETCH ATC_CUR INTO V_AWARD_TYPE_CODE;
            IF DONE THEN
                LEAVE main_loop;
            END IF;

            UPDATE AWARD_TYPE SET SORT_ID = COUNTER WHERE AWARD_TYPE_CODE = V_AWARD_TYPE_CODE;

            SET COUNTER = COUNTER + 1;
        END LOOP;
    COMMIT;

END
/
CALL p()
/
DROP PROCEDURE IF EXISTS p
/
