-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

SET @TECH_ADMIN_ROLE_ID = (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Technical Administrator' AND NMSPC_CD = 'KR-SYS');
SET @PERM_TMPL_ID = (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KUALI' AND NM = 'Default');
SET @NMSPC_CD = 'KC-IDM';

-- Create permission for "Push Address Book Users to the Core Auth Service"
SET @PERM_ID = 'RESBOOT-1039';
SET @ROLE_PERM_ID = 'RESBOOT-1058';

INSERT IGNORE INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (@PERM_ID,@PERM_TMPL_ID,@NMSPC_CD,'Push Address Book Users to the Core Auth Service','Push Address Book Users to the Core Auth Service','Y',UUID(),1);

INSERT IGNORE INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (@ROLE_PERM_ID, UUID(), 1, @TECH_ADMIN_ROLE_ID, @PERM_ID, 'Y');

-- Create permission for "Push Units to the Core Groups Service"
SET @PERM_ID = 'RESBOOT-1040';
SET @ROLE_PERM_ID = 'RESBOOT-1059';

INSERT IGNORE INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (@PERM_ID,@PERM_TMPL_ID,@NMSPC_CD,'Push Units to the Core Groups Service','Push Units to the Core Groups Service','Y',UUID(),1);

INSERT IGNORE INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (@ROLE_PERM_ID, UUID(), 1, @TECH_ADMIN_ROLE_ID, @PERM_ID, 'Y');

-- Create permission for "Push Users to the Core Auth Service"
SET @PERM_ID = 'RESBOOT-1041';
SET @ROLE_PERM_ID = 'RESBOOT-1060';

INSERT IGNORE INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (@PERM_ID,@PERM_TMPL_ID,@NMSPC_CD,'Push Users to the Core Auth Service','Push Users to the Core Auth Service','Y',UUID(),1);

INSERT IGNORE INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (@ROLE_PERM_ID, UUID(), 1, @TECH_ADMIN_ROLE_ID, @PERM_ID, 'Y');

