---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---

CREATE TABLE QUESTION_MULTI_CHOICE (
  ID NUMBER(12,0),
  QUESTION_REF_ID_FK NUMBER(12,0) NOT NULL,
  PROMPT VARCHAR2(200) NOT NULL,
  DESCRIPTION VARCHAR2(200) NOT NULL,
  UPDATE_TIMESTAMP DATE NOT NULL,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  VER_NBR NUMBER(8,0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL);

ALTER TABLE QUESTION_MULTI_CHOICE
ADD CONSTRAINT PK_QUESTION_MULTI_CHOICE
PRIMARY KEY (ID);

ALTER TABLE QUESTION_MULTI_CHOICE
ADD CONSTRAINT FK_QUESTION_MULTI_CHOICE
FOREIGN KEY (QUESTION_REF_ID_FK)
REFERENCES QUESTION (QUESTION_REF_ID);

CREATE SEQUENCE SEQ_QUESTION_MULTI_CHOICE_ID INCREMENT BY 1 START WITH 1 NOCACHE;

INSERT INTO QUESTION_TYPES (QUESTION_TYPE_ID,QUESTION_TYPE_NAME,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID) VALUES (100,'Multiple Choice',SYSDATE,'admin',1,SYS_GUID());
