---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---
CREATE SEQUENCE SEQ_AWARD_REPORT_NOTIF_SENT_ID INCREMENT BY 1 START WITH 1 NOCACHE;

ALTER TABLE AWARD_REPORT_NOTIFICATION_SENT
ADD AWARD_REPORT_NOTIF_SENT_ID NUMBER(22);


DECLARE

  O_ID VARCHAR(36);
  NEXT_ID NUMBER(19);

  CURSOR CUR IS SELECT OBJ_ID FROM AWARD_REPORT_NOTIFICATION_SENT WHERE AWARD_REPORT_NOTIF_SENT_ID IS NULL;

BEGIN

  OPEN CUR;

  LOOP
    FETCH CUR INTO O_ID;
    EXIT WHEN CUR%NOTFOUND;

    SELECT SEQ_AWARD_REPORT_NOTIF_SENT_ID.NEXTVAL INTO NEXT_ID FROM DUAL;

    UPDATE AWARD_REPORT_NOTIFICATION_SENT SET AWARD_REPORT_NOTIF_SENT_ID = NEXT_ID WHERE OBJ_ID = O_ID;
  END LOOP;

  CLOSE CUR;
END;
/

ALTER TABLE AWARD_REPORT_NOTIFICATION_SENT
ADD CONSTRAINT PK_AWARD_REPORT_NOTIF_SENT
PRIMARY KEY (AWARD_REPORT_NOTIF_SENT_ID);


CREATE SEQUENCE SEQ_AWARD_REPORT_TRACKING_ID INCREMENT BY 1 START WITH 1 NOCACHE;

ALTER TABLE AWARD_REPORT_TRACKING
ADD AWARD_REPORT_TRACKING_ID NUMBER(22);

DECLARE

  O_ID VARCHAR(36);
  NEXT_ID NUMBER(19);

  CURSOR CUR IS SELECT OBJ_ID FROM AWARD_REPORT_TRACKING WHERE AWARD_REPORT_TRACKING_ID IS NULL;

BEGIN

  OPEN CUR;

  LOOP
    FETCH CUR INTO O_ID;
    EXIT WHEN CUR%NOTFOUND;

    SELECT SEQ_AWARD_REPORT_TRACKING_ID.NEXTVAL INTO NEXT_ID FROM DUAL;

    UPDATE AWARD_REPORT_TRACKING SET AWARD_REPORT_TRACKING_ID = NEXT_ID WHERE OBJ_ID = O_ID;
  END LOOP;

  CLOSE CUR;
END;
/

ALTER TABLE AWARD_REPORT_TRACKING
ADD CONSTRAINT PK_AWARD_REPORT_TRACKING
PRIMARY KEY (AWARD_REPORT_TRACKING_ID);


ALTER TABLE VERSION_HISTORY
ADD CONSTRAINT PK_VERSION_HISTORY
PRIMARY KEY (VERSION_HISTORY_ID);
