---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


alter table training drop column module_code;

CREATE SEQUENCE SEQ_TRAINING_MODULE_ID INCREMENT BY 1 START WITH 1 NOCACHE;

create table training_modules (
ID VARCHAR2(40) NOT NULL,
TRAINING_CODE NUMBER(4) NOT NULL,
MODULE_CODE NUMBER(3) NOT NULL,
UPDATE_TIMESTAMP DATE NOT NULL,
UPDATE_USER VARCHAR2(60) NOT NULL,
VER_NBR NUMBER(8) default 1 NOT NULL,
OBJ_ID VARCHAR2(36)
);

ALTER TABLE training_modules ADD CONSTRAINT fk_tm_module_code
FOREIGN KEY (module_code)
REFERENCES coeus_module (module_code);

ALTER TABLE training_modules ADD CONSTRAINT fk_tm_training_code
FOREIGN KEY (training_code)
REFERENCES training (training_code);

ALTER TABLE training_modules ADD CONSTRAINT uq_training_modules UNIQUE (module_code, training_code);
