---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---



INSERT INTO NARRATIVE_TYPE (NARRATIVE_TYPE_CODE, DESCRIPTION, NARRATIVE_TYPE_GROUP, ALLOW_MULTIPLE, SYSTEM_GENERATED, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR)
VALUES ('-3', 'PHS_HumanSubjectsAndCT_InvolveHumanSpecimensExp', 'P', 'N', 'N', 'admin', SYSDATE, SYS_GUID(), 1);

INSERT INTO NARRATIVE_TYPE (NARRATIVE_TYPE_CODE, DESCRIPTION, NARRATIVE_TYPE_GROUP, ALLOW_MULTIPLE, SYSTEM_GENERATED, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR)
VALUES ('-4', 'PHS_HumanSubjectsAndCT_OtherRequestedInfo', 'P', 'N', 'N', 'admin', SYSDATE, SYS_GUID(), 1);

INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES (SEQ_VALID_NARR_FORMS_ID.NEXTVAL, 'PHS_HumanSubjectsAndClinicalTrialsInfo_V1.0', '-3', 'N', 'admin', SYSDATE,
        SYS_GUID());

INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES (SEQ_VALID_NARR_FORMS_ID.NEXTVAL, 'PHS_HumanSubjectsAndClinicalTrialsInfo_V1.0', '-4', 'N', 'admin', SYSDATE,
        SYS_GUID());

INSERT INTO exemption_type (EXEMPTION_TYPE_CODE, DESCRIPTION, DETAILED_DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES
  ('7', 'E7', 'Human subjects involved—multiple exemption categories designated.', SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO exemption_type (EXEMPTION_TYPE_CODE, DESCRIPTION, DETAILED_DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ('8', 'E8', 'Human subjects involved—applicability of human subjects regulations waived by the Secretary, HHS.',
        SYSDATE, 'admin', 1, SYS_GUID());

INSERT INTO QUESTION (QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE, QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS, MAX_ANSWERS, ANSWER_MAX_LENGTH, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, -10130, 1, 'C',
                                          'Does the proposed research involve human specimens and/or data?', 'A', 2, 1,
                                          NULL, NULL, NULL, 1, 1, SYSDATE, 'admin', 1, SYS_GUID(), NULL);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID
                                           FROM QUESTIONNAIRE
                                           WHERE
                                             NAME = 'GG S2S Forms' AND SEQUENCE_NUMBER = (SELECT max(SEQUENCE_NUMBER)
                                                                                          FROM QUESTIONNAIRE
                                                                                          WHERE
                                                                                            NAME = 'GG S2S Forms')),
                                          (SELECT max(QUESTION_REF_ID)
                                           FROM QUESTION
                                           WHERE QUESTION_ID = '-10130'), 295, 0, 1, 'N', NULL, NULL, 'admin', SYSDATE,
        SYS_GUID(), 1, 'KC153');
