---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


CREATE TABLE subaward_attachment_type_tmp (
                                           ATTACHMENT_TYPE_CODE varchar2(30) NOT NULL,
                                           DESCRIPTION varchar2(200) NOT NULL,
                                           UPDATE_TIMESTAMP date NOT NULL,
                                           UPDATE_USER varchar2(60) NOT NULL,
                                           VER_NBR number(8) DEFAULT 1 NOT NULL,
                                           OBJ_ID varchar2(36) NOT NULL
);

insert into subaward_attachment_type_tmp (ATTACHMENT_TYPE_CODE, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
  select ATTACHMENT_TYPE_CODE, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID from subaward_attachment_type;

drop table subaward_attachment_type;

rename subaward_attachment_type_tmp to subaward_attachment_type;

ALTER TABLE subaward_attachment_type
    ADD CONSTRAINT PK_subaward_attachment_type
        PRIMARY KEY (ATTACHMENT_TYPE_CODE);

ALTER TABLE subaward_attachment_type
    ADD CONSTRAINT UQ_subaward_attachment_type
        UNIQUE (OBJ_ID);

alter table subaward_attachments MODIFY FILE_NAME varchar2(150) NOT NULL;
alter table subaward_attachments MODIFY DESCRIPTION varchar2(200) NOT NULL;
-- not needed on the oracle side
--alter table subaward_attachments MODIFY UPDATE_TIMESTAMP DATE NOT NULL;

update subaward_attachments set LAST_UPDATE_USER = UPDATE_USER where LAST_UPDATE_USER is null;
update subaward_attachments set LAST_UPDATE_TIMESTAMP = UPDATE_TIMESTAMP where LAST_UPDATE_TIMESTAMP is null;

alter table subaward_attachments MODIFY LAST_UPDATE_USER varchar2(60) NOT NULL;
alter table subaward_attachments MODIFY LAST_UPDATE_TIMESTAMP DATE NOT NULL;

alter table subaward_attachments MODIFY FILE_DATA_ID varchar2(36) NOT NULL;
alter table subaward_attachments MODIFY MIME_TYPE varchar2(255) NOT NULL;

ALTER TABLE subaward_attachments
    ADD CONSTRAINT FK_subaward_attachments
        FOREIGN KEY (SUBAWARD_ID) REFERENCES SUBAWARD (SUBAWARD_ID);

ALTER TABLE subaward_attachments
    ADD CONSTRAINT FK3_subaward_attachments
        FOREIGN KEY (ATTACHMENT_TYPE_CODE) REFERENCES subaward_attachment_type (ATTACHMENT_TYPE_CODE);

ALTER TABLE subaward_attachments
    ADD CONSTRAINT UQ_subaward_attachments
        UNIQUE (OBJ_ID);


CREATE SEQUENCE SEQ_SUBAWARD_COMMENT_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

CREATE TABLE SUBAWARD_COMMENT (
                                 SUBAWARD_COMMENT_ID NUMBER(8) NOT NULL,
                                 SUBAWARD_ID NUMBER(12) NOT NULL,
                                 SUBAWARD_CODE varchar2(20) NOT NULL,
                                 SEQUENCE_NUMBER number(4) NOT NULL,
                                 COMMENT_TYPE_CODE varchar2(3) NOT NULL,
                                 CHECKLIST_PRINT_FLAG varchar2(1) NOT NULL,
                                 COMMENTS clob,
                                 UPDATE_TIMESTAMP date NOT NULL,
                                 UPDATE_USER varchar2(60) NOT NULL,
                                 VER_NBR number(8) DEFAULT 1 NOT NULL,
                                 OBJ_ID varchar2(36) NOT NULL
);

ALTER TABLE SUBAWARD_COMMENT
    ADD CONSTRAINT PK_SUBAWARD_COMMENT
        PRIMARY KEY (SUBAWARD_COMMENT_ID);

ALTER TABLE SUBAWARD_COMMENT
    ADD CONSTRAINT FK_SUBAWARD_COMMENT
        FOREIGN KEY (SUBAWARD_ID) REFERENCES SUBAWARD (SUBAWARD_ID);

ALTER TABLE SUBAWARD_COMMENT
    ADD CONSTRAINT FK2_SUBAWARD_COMMENT
        FOREIGN KEY (COMMENT_TYPE_CODE) REFERENCES comment_type (COMMENT_TYPE_CODE);

ALTER TABLE SUBAWARD_COMMENT
    ADD CONSTRAINT UQ_SUBAWARD_COMMENT
        UNIQUE (OBJ_ID);

ALTER TABLE COMMENT_TYPE ADD SUBAWARD_COMMENT_SCREEN_FLAG VARCHAR2(1) DEFAULT 'N' NOT NULL;

CREATE SEQUENCE SEQ_SUBAWARD_NOTEPAD_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

CREATE TABLE SUBAWARD_NOTEPAD (
                                 SUBAWARD_NOTEPAD_ID number(12) NOT NULL,
                                 SUBAWARD_ID number(12) NOT NULL,
                                 SUBAWARD_CODE varchar2(20) NOT NULL,
                                 ENTRY_NUMBER number(4) NOT NULL,
                                 COMMENTS clob NOT NULL,
                                 RESTRICTED_VIEW char(1) NOT NULL,
                                 UPDATE_TIMESTAMP date NOT NULL,
                                 UPDATE_USER varchar2(60) NOT NULL,
                                 VER_NBR number(8) DEFAULT 1 NOT NULL,
                                 CREATE_TIMESTAMP date NOT NULL,
                                 NOTE_TOPIC varchar2(60) NOT NULL,
                                 OBJ_ID varchar2(36) NOT NULL,
                                 CREATE_USER varchar2(60) NOT NULL
);

ALTER TABLE SUBAWARD_NOTEPAD
    ADD CONSTRAINT PK_SUBAWARD_NOTEPAD
        PRIMARY KEY (SUBAWARD_NOTEPAD_ID);

ALTER TABLE SUBAWARD_NOTEPAD
    ADD CONSTRAINT FK_SUBAWARD_NOTEPAD
        FOREIGN KEY (SUBAWARD_ID) REFERENCES SUBAWARD (SUBAWARD_ID);

ALTER TABLE SUBAWARD_NOTEPAD
    ADD CONSTRAINT UQ_SUBAWARD_NOTEPAD
        UNIQUE (OBJ_ID);

ALTER TABLE SUBAWARD_NOTEPAD
    ADD CONSTRAINT UQ2_SUBAWARD_NOTEPAD
        UNIQUE (SUBAWARD_CODE,ENTRY_NUMBER);

CREATE TABLE subaward_tmpl_attach_type (
                                    ATTACHMENT_TYPE_CODE varchar2(30) NOT NULL,
                                    DESCRIPTION varchar2(200) NOT NULL,
                                    UPDATE_TIMESTAMP date NOT NULL,
                                    UPDATE_USER varchar2(60) NOT NULL,
                                    VER_NBR number(8) DEFAULT 1 NOT NULL,
                                    OBJ_ID varchar2(36) NOT NULL
);

ALTER TABLE subaward_tmpl_attach_type
    ADD CONSTRAINT PK_subaward_tmpl_attach_type
        PRIMARY KEY (ATTACHMENT_TYPE_CODE);

ALTER TABLE subaward_tmpl_attach_type
    ADD CONSTRAINT UQ_subaward_tmpl_attach_type
        UNIQUE (OBJ_ID);

CREATE SEQUENCE SEQ_SUBAWARD_TMPL_ATT_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

CREATE TABLE SUBAWARD_TEMPLATE_ATTACHMENTS (
                                        ATTACHMENT_ID number(12) NOT NULL,
                                        SUBAWARD_ID number(12) NOT NULL,
                                        SUBAWARD_CODE varchar2(20) NOT NULL,
                                        SEQUENCE_NUMBER number(4) NOT NULL,
                                        ATTACHMENT_TYPE_CODE varchar2(30) NOT NULL,
                                        DOCUMENT_ID number(4) NOT NULL,
                                        DOCUMENT_STATUS_CODE char(1),
                                        FILE_NAME varchar2(150) NOT NULL,
                                        MIME_TYPE varchar2(255) NOT NULL,
                                        FILE_DATA_ID varchar2(36) NOT NULL,
                                        DESCRIPTION varchar2(200) NOT NULL,
                                        UPDATE_TIMESTAMP date NOT NULL,
                                        UPDATE_USER varchar2(60) NOT NULL,
                                        VER_NBR number(8) DEFAULT 1 NOT NULL,
                                        OBJ_ID varchar2(36) NOT NULL,
                                        LAST_UPDATE_USER varchar2(60) NOT NULL,
                                        LAST_UPDATE_TIMESTAMP date NOT NULL
);

ALTER TABLE SUBAWARD_TEMPLATE_ATTACHMENTS
    ADD CONSTRAINT PK_SUBAWARD_TEMPLATE_ATTS
        PRIMARY KEY (ATTACHMENT_ID);

ALTER TABLE SUBAWARD_TEMPLATE_ATTACHMENTS
    ADD CONSTRAINT FK_SUBAWARD_TEMPLATE_ATTS
        FOREIGN KEY (SUBAWARD_ID) REFERENCES SUBAWARD (SUBAWARD_ID);

ALTER TABLE SUBAWARD_TEMPLATE_ATTACHMENTS
    ADD CONSTRAINT FK2_SUBAWARD_TEMPLATE_ATTS
        FOREIGN KEY (FILE_DATA_ID) REFERENCES file_data (ID);

ALTER TABLE SUBAWARD_TEMPLATE_ATTACHMENTS
    ADD CONSTRAINT FK3_SUBAWARD_TEMPLATE_ATTS
        FOREIGN KEY (ATTACHMENT_TYPE_CODE) REFERENCES subaward_tmpl_attach_type (ATTACHMENT_TYPE_CODE);

ALTER TABLE SUBAWARD_TEMPLATE_ATTACHMENTS
    ADD CONSTRAINT UQ_SUBAWARD_TEMPLATE_ATTS
        UNIQUE (OBJ_ID);
