---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


INSERT INTO COEUS_MODULE (MODULE_CODE, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID)
VALUES (12, 'Export Control', SYSDATE, 'admin', SYS_GUID());

INSERT INTO NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID, MODULE_CODE, ACTION_CODE, DESCRIPTION, SUBJECT, MESSAGE, PROMPT_USER, SEND_NOTIFICATION, UPDATE_USER,
                               UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES (SEQ_NOTIFICATION_TYPE_ID.NEXTVAL, 12, '-3', 'Notification to others when Export Control status updated',
        'Export Control {EC_NUMBER} {EC_TITLE} is now in {EC_STATUS_NAME} status.',
        '<p>The export control {EC_NUMBER}: {PROJECT_TYPE_NAME} {EC_TITLE} is now in the status {EC_STATUS_NAME}.</p><p>Lead Unit: {LEAD_UNIT_NAME} ({LEAD_UNIT_NUMBER})</p><p>{SPONSOR_NAME} ({SPONSOR_CODE})</p><p>Related Project Personnel:</p><p>{PROJECT_PERSONNEL_NAMES}</p><p>Associated research activities:</p><p>{EC_ASSOCIATIONS_LIST}</p><p>If you have questions about this email, please contact the export control officer.</p>',
        'N', 'Y', 'admin', SYSDATE, 1, SYS_GUID());

INSERT INTO NOTIFICATION_MODULE_ROLE (NOTIFICATION_MODULE_ROLE_ID, MODULE_CODE, ROLE_NAME, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
VALUES (SEQ_NTFCTN_MODULE_ROLE_ID.NEXTVAL, 12, 'KC-EXCON:PI', SYS_GUID(), 1, SYSDATE, 'admin');

INSERT INTO NOTIFICATION_TYPE_RECIPIENT (NOTIFICATION_TYPE_RECIPIENT_ID, NOTIFICATION_TYPE_ID, ROLE_NAME, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES (SEQ_NOTIFICATION_TYPE_ID.NEXTVAL, (SELECT NOTIFICATION_TYPE_ID FROM NOTIFICATION_TYPE WHERE MODULE_CODE = 12 AND ACTION_CODE = '-3'),
        'KC-EXCON:PI', 'admin', SYSDATE, 1, SYS_GUID());

INSERT INTO NOTIFICATION_MDL_ROLE_QLFR (NOTIFICATION_MDL_ROLE_QLFR_ID, NOTIFICATION_MODULE_ROLE_ID, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, QUALIFIER)
VALUES (SEQ_NTFCTN_MDL_ROLE_QLFR_ID.NEXTVAL, (SELECT NOTIFICATION_MODULE_ROLE_ID FROM NOTIFICATION_MODULE_ROLE WHERE ROLE_NAME = 'KC-EXCON:PI'),
        SYS_GUID(), 1, SYSDATE, 'admin', 'exportControl');

CREATE TABLE EXCON_NOTIFICATION
(
    NOTIFICATION_ID       number(20, 0) PRIMARY KEY,
    NOTIFICATION_TYPE_ID  number(6, 0)  NOT NULL,
    DOCUMENT_NUMBER       varchar(40)   NOT NULL,
    OWNING_DOCUMENT_ID_FK number(22, 0) NOT NULL,
    RECIPIENTS            varchar(1000) DEFAULT NULL,
    SUBJECT               varchar(1000) DEFAULT NULL,
    MESSAGE               varchar(4000) DEFAULT NULL,
    UPDATE_USER           varchar(60)   NOT NULL,
    UPDATE_TIMESTAMP      date          NOT NULL,
    CREATE_TIMESTAMP      date          NOT NULL,
    VER_NBR               number(8, 0)  DEFAULT 1,
    OBJ_ID                varchar(36)   NOT NULL,
    CONSTRAINT FK1_EXCON_NOTIFICATION FOREIGN KEY (OWNING_DOCUMENT_ID_FK) REFERENCES excon_project (PROJECT_ID),
    CONSTRAINT FK2_EXCON_NOTIFICATION FOREIGN KEY (NOTIFICATION_TYPE_ID) REFERENCES notification_type (NOTIFICATION_TYPE_ID)
);
