---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


INSERT INTO NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID, MODULE_CODE, ACTION_CODE, DESCRIPTION, SUBJECT, MESSAGE, PROMPT_USER, SEND_NOTIFICATION, UPDATE_USER,
                               UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES (SEQ_NOTIFICATION_TYPE_ID.NEXTVAL, 12, '-4', 'Export Control identified related to associated document',
        'Export Control {EC_NUMBER} has been identified related to {EC_TITLE}, {PROJECT_PERSONNEL_NAMES}.',
        '<p>Activity related to Export Control has been identified related to:</p><p>{EC_ASSOCIATION_DOC_TYPE_NAME} {EC_ASSOCIATION_DOC_NUMBER}</p><p>Title: {EC_ASSOCIATION_DOC_TITLE}</p><p>Principal Investigator: {EC_ASSOCIATION_DOC_PI}</p><p>Lead Unit: {LEAD_UNIT_NAME} ({LEAD_UNIT_NUMBER})</p><p>{SPONSOR_NAME} ({SPONSOR_CODE})</p><p>A review process has been initiated. This email serves as a notification only, no action needs to be taken currently. A reviewer may contact you if additional information is needed.</p><p>If you have questions about this email, please contact the export control officer.</p>',
        'N', 'Y', 'admin', SYSDATE, 1, SYS_GUID());

INSERT INTO NOTIFICATION_TYPE_RECIPIENT (NOTIFICATION_TYPE_RECIPIENT_ID, NOTIFICATION_TYPE_ID, ROLE_NAME, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES (SEQ_NOTIFICATION_TYPE_ID.NEXTVAL, (SELECT NOTIFICATION_TYPE_ID FROM NOTIFICATION_TYPE WHERE MODULE_CODE = 12 AND ACTION_CODE = '-4'),
        'KC-EXCON:PI', 'admin', SYSDATE, 1, SYS_GUID());
