---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---









ALTER TABLE AWARD
    ADD CONSTRAINT FK_AWARD_UNIT FOREIGN KEY (LEAD_UNIT_NUMBER)
    REFERENCES UNIT (UNIT_NUMBER);

ALTER TABLE AWARD
    ADD CONSTRAINT FK_AWARD FOREIGN KEY (DOCUMENT_NUMBER)
    REFERENCES AWARD_DOCUMENT (DOCUMENT_NUMBER);


ALTER TABLE AWARD_AMOUNT_INFO
    ADD CONSTRAINT FK_AWARD_AMOUNT_INFO FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);


ALTER TABLE AWARD_AMOUNT_TRANSACTION
    ADD CONSTRAINT FK_AWARD_AMOUNT_TRANSACTION1 FOREIGN KEY (TRANSACTION_TYPE_CODE)
    REFERENCES AWARD_TRANSACTION_TYPE (AWARD_TRANSACTION_TYPE_CODE);

ALTER TABLE AWARD_AMOUNT_TRANSACTION
    ADD CONSTRAINT FK_AWARD_AMOUNT_TRANSACTION3 FOREIGN KEY (TRANSACTION_ID)
    REFERENCES TIME_AND_MONEY_DOCUMENT (DOCUMENT_NUMBER);


ALTER TABLE AWARD_AMT_FNA_DISTRIBUTION
    ADD CONSTRAINT FK_AWARD_AMT_FNA_DISTRIBUTION FOREIGN KEY (AWARD_AMOUNT_INFO_ID)
    REFERENCES AWARD_AMOUNT_INFO (AWARD_AMOUNT_INFO_ID);


ALTER TABLE AWARD_APPROVED_EQUIPMENT
    ADD CONSTRAINT FK_AWARD_AWARD_APPROVED_EQUIP FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);



ALTER TABLE AWARD_APPROVED_SUBAWARDS
    ADD CONSTRAINT FK_ORGANIZATION_ID FOREIGN KEY (ORGANIZATION_ID)
    REFERENCES ORGANIZATION (ORGANIZATION_ID);


ALTER TABLE AWARD_ATTACHMENT
    ADD CONSTRAINT FK_ATTACHMENT_FILE FOREIGN KEY (FILE_ID)
    REFERENCES ATTACHMENT_FILE (FILE_ID)
ON DELETE CASCADE;

ALTER TABLE AWARD_ATTACHMENT
    ADD CONSTRAINT FK_AWARD_ATTACHMENT_TYPE FOREIGN KEY (TYPE_CODE)
    REFERENCES AWARD_ATTACHMENT_TYPE (TYPE_CODE);

ALTER TABLE AWARD_ATTACHMENT
    ADD CONSTRAINT FK_AW_ATT_AWARD FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);




ALTER TABLE AWARD_BUDGET_DETAILS_EXT
    ADD CONSTRAINT FK_AWARD_BUDGET_DETAILS_EXT FOREIGN KEY (BUDGET_DETAILS_ID)
    REFERENCES BUDGET_DETAILS (BUDGET_DETAILS_ID);


ALTER TABLE AWARD_BUDGET_EXT
    ADD CONSTRAINT FK2_AWARD_BUDGET_EXT FOREIGN KEY (AWARD_BUDGET_TYPE_CODE)
    REFERENCES AWARD_BUDGET_TYPE (AWARD_BUDGET_TYPE_CODE);

ALTER TABLE AWARD_BUDGET_EXT
    ADD CONSTRAINT FK1_AWARD_BUDGET_EXT FOREIGN KEY (AWARD_BUDGET_STATUS_CODE)
    REFERENCES AWARD_BUDGET_STATUS (AWARD_BUDGET_STATUS_CODE);

ALTER TABLE AWARD_BUDGET_EXT
    ADD CONSTRAINT FK_AWARD_BUDGET_EXT FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);


ALTER TABLE AWARD_BUDGET_PERIOD_EXT
    ADD CONSTRAINT AWARD_BUDGET_PERIOD_EXT FOREIGN KEY (BUDGET_PERIOD_NUMBER)
    REFERENCES BUDGET_PERIODS (BUDGET_PERIOD_NUMBER);




ALTER TABLE AWARD_CLOSEOUT
    ADD CONSTRAINT FK_CLOSEOUT_REPORT_TYPE FOREIGN KEY (CLOSEOUT_REPORT_CODE)
    REFERENCES CLOSEOUT_REPORT_TYPE (CLOSEOUT_REPORT_CODE);

ALTER TABLE AWARD_CLOSEOUT
    ADD CONSTRAINT FK_AWARD_CLOSEOUT FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);


ALTER TABLE AWARD_COMMENT
    ADD CONSTRAINT FK_AWARD_COMMENT_AWARD_ID FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);

ALTER TABLE AWARD_COMMENT
    ADD CONSTRAINT FK_AWARD_COMMENT_COMMENT_TYPE FOREIGN KEY (COMMENT_TYPE_CODE)
    REFERENCES COMMENT_TYPE (COMMENT_TYPE_CODE);


ALTER TABLE AWARD_COST_SHARE
    ADD CONSTRAINT FK_AWARD_COST_SHARE_AWARD_ID FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);

ALTER TABLE AWARD_COST_SHARE
    ADD CONSTRAINT FK_AWARD_COST_SHARE_TYPE FOREIGN KEY (COST_SHARE_TYPE_CODE)
    REFERENCES COST_SHARE_TYPE (COST_SHARE_TYPE_CODE);


ALTER TABLE AWARD_CUSTOM_DATA
    ADD CONSTRAINT FK_AWARD_CUSTOM_DATA FOREIGN KEY (CUSTOM_ATTRIBUTE_ID)
    REFERENCES CUSTOM_ATTRIBUTE (ID);



ALTER TABLE AWARD_EXEMPT_NUMBER
    ADD CONSTRAINT FK_EXEMPTION_TYPE_CODE FOREIGN KEY (EXEMPTION_TYPE_CODE)
    REFERENCES EXEMPTION_TYPE (EXEMPTION_TYPE_CODE);

ALTER TABLE AWARD_EXEMPT_NUMBER
    ADD CONSTRAINT FK_AWARD_SPECIAL_REVIEW_ID FOREIGN KEY (AWARD_SPECIAL_REVIEW_ID)
    REFERENCES AWARD_SPECIAL_REVIEW (AWARD_SPECIAL_REVIEW_ID);


ALTER TABLE AWARD_FUNDING_PROPOSALS
    ADD CONSTRAINT FK_AWD_FUND_PROP_PROPOSAL FOREIGN KEY (PROPOSAL_ID)
    REFERENCES PROPOSAL (PROPOSAL_ID);

ALTER TABLE AWARD_FUNDING_PROPOSALS
    ADD CONSTRAINT FK_AWD_FUND_PROP_AWARD FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);



ALTER TABLE AWARD_IDC_RATE
    ADD CONSTRAINT FK_AWARD_IDC_RATE FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);




ALTER TABLE AWARD_PAYMENT_SCHEDULE
    ADD CONSTRAINT FK_AWARD_PAYMENT_SCHEDULE FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);


ALTER TABLE AWARD_PERSONS
    ADD CONSTRAINT FK_PROP_PERS_ROLE_AWD_PERSONS FOREIGN KEY (CONTACT_ROLE_CODE)
    REFERENCES EPS_PROP_PERSON_ROLE (PROP_PERSON_ROLE_ID);

ALTER TABLE AWARD_PERSONS
    ADD CONSTRAINT FK_AWARD_AWARD_PERSONS FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);


ALTER TABLE AWARD_PERSON_CREDIT_SPLITS
    ADD CONSTRAINT FK_AP_CREDIT_SPLIT_ICT FOREIGN KEY (INV_CREDIT_TYPE_CODE)
    REFERENCES INV_CREDIT_TYPE (INV_CREDIT_TYPE_CODE);

ALTER TABLE AWARD_PERSON_CREDIT_SPLITS
    ADD CONSTRAINT FK_AP_CREDIT_SPLIT_AP FOREIGN KEY (AWARD_PERSON_ID)
    REFERENCES AWARD_PERSONS (AWARD_PERSON_ID);


ALTER TABLE AWARD_PERSON_UNITS
    ADD CONSTRAINT FK_APU_AW_PERSON FOREIGN KEY (AWARD_PERSON_ID)
    REFERENCES AWARD_PERSONS (AWARD_PERSON_ID);

ALTER TABLE AWARD_PERSON_UNITS
    ADD CONSTRAINT FK_APU_UNIT FOREIGN KEY (UNIT_NUMBER)
    REFERENCES UNIT (UNIT_NUMBER);


ALTER TABLE AWARD_PERS_UNIT_CRED_SPLITS
    ADD CONSTRAINT FK_APU_CREDIT_SPLIT_AP FOREIGN KEY (AWARD_PERSON_UNIT_ID)
    REFERENCES AWARD_PERSON_UNITS (AWARD_PERSON_UNIT_ID);

ALTER TABLE AWARD_PERS_UNIT_CRED_SPLITS
    ADD CONSTRAINT FK_APU_CREDIT_SPLIT_ICT FOREIGN KEY (INV_CREDIT_TYPE_CODE)
    REFERENCES INV_CREDIT_TYPE (INV_CREDIT_TYPE_CODE);


ALTER TABLE AWARD_REPORT_TERMS
    ADD CONSTRAINT FK10_AWARD_REPORT_TERMS FOREIGN KEY (FREQUENCY_CODE)
    REFERENCES FREQUENCY (FREQUENCY_CODE);

ALTER TABLE AWARD_REPORT_TERMS
    ADD CONSTRAINT FK_AWARD_REPORT_TERMS FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);

ALTER TABLE AWARD_REPORT_TERMS
    ADD CONSTRAINT FK9_AWARD_REPORT_TERMS FOREIGN KEY (REPORT_CODE)
    REFERENCES REPORT (REPORT_CODE);

ALTER TABLE AWARD_REPORT_TERMS
    ADD CONSTRAINT FK8_AWARD_REPORT_TERMS FOREIGN KEY (REPORT_CLASS_CODE)
    REFERENCES REPORT_CLASS (REPORT_CLASS_CODE);

ALTER TABLE AWARD_REPORT_TERMS
    ADD CONSTRAINT FK11_AWARD_REPORT_TERMS FOREIGN KEY (FREQUENCY_BASE_CODE)
    REFERENCES FREQUENCY_BASE (FREQUENCY_BASE_CODE);

ALTER TABLE AWARD_REPORT_TERMS
    ADD CONSTRAINT FK3_AWARD_REPORT_TERMS FOREIGN KEY (OSP_DISTRIBUTION_CODE)
    REFERENCES DISTRIBUTION (OSP_DISTRIBUTION_CODE);


ALTER TABLE AWARD_REP_TERMS_RECNT
    ADD CONSTRAINT FK3_AWARD_REP_TERMS_RECNT FOREIGN KEY (ROLODEX_ID)
    REFERENCES ROLODEX (ROLODEX_ID);

ALTER TABLE AWARD_REP_TERMS_RECNT
    ADD CONSTRAINT FK2_AWARD_REP_TERMS_RECNT FOREIGN KEY (CONTACT_TYPE_CODE)
    REFERENCES CONTACT_TYPE (CONTACT_TYPE_CODE);

ALTER TABLE AWARD_REP_TERMS_RECNT
    ADD CONSTRAINT FK1_AWARD_REP_TERMS_RECNT FOREIGN KEY (AWARD_REPORT_TERMS_ID)
    REFERENCES AWARD_REPORT_TERMS (AWARD_REPORT_TERMS_ID);


ALTER TABLE AWARD_SCIENCE_KEYWORD
    ADD CONSTRAINT FK_AWARD_SCIENCE_KEYWORD2 FOREIGN KEY (SCIENCE_KEYWORD_CODE)
    REFERENCES SCIENCE_KEYWORD (SCIENCE_KEYWORD_CODE);

ALTER TABLE AWARD_SCIENCE_KEYWORD
    ADD CONSTRAINT FK_AWARD_SCIENCE_KEYWORD FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);


ALTER TABLE AWARD_SPECIAL_REVIEW
    ADD CONSTRAINT FK_AWARD_SPECIAL_REVIEW FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);



ALTER TABLE AWARD_SPONSOR_TERM
    ADD CONSTRAINT FK_AWARD_SPONSOR_TERM FOREIGN KEY (SPONSOR_TERM_ID)
    REFERENCES SPONSOR_TERM (SPONSOR_TERM_ID);



ALTER TABLE AWARD_TEMPLATE
    ADD CONSTRAINT FK_AWARD_TEMPLATE_STATUS_CODE FOREIGN KEY (STATUS_CODE)
    REFERENCES AWARD_STATUS (STATUS_CODE);

ALTER TABLE AWARD_TEMPLATE
    ADD CONSTRAINT FK_AWARD_TEMPLATE_SPONSOR FOREIGN KEY (PRIME_SPONSOR_CODE)
    REFERENCES SPONSOR (SPONSOR_CODE);


ALTER TABLE AWARD_TEMPLATE_COMMENTS
    ADD CONSTRAINT FK_AWARD_TEMPLATE_COMMENT_CODE FOREIGN KEY (COMMENT_TYPE_CODE)
    REFERENCES COMMENT_TYPE (COMMENT_TYPE_CODE);

ALTER TABLE AWARD_TEMPLATE_COMMENTS
    ADD CONSTRAINT FK_AWARD_TEMPLATE_CODE FOREIGN KEY (AWARD_TEMPLATE_CODE)
    REFERENCES AWARD_TEMPLATE (AWARD_TEMPLATE_CODE);


ALTER TABLE AWARD_TEMPLATE_CONTACT
    ADD CONSTRAINT FK_AWARD_TEMPLATE_CONTACT FOREIGN KEY (AWARD_TEMPLATE_CODE)
    REFERENCES AWARD_TEMPLATE (AWARD_TEMPLATE_CODE);

ALTER TABLE AWARD_TEMPLATE_CONTACT
    ADD CONSTRAINT FK_AWD_TEMPL_CONT_ROLODEX_ID FOREIGN KEY (ROLODEX_ID)
    REFERENCES ROLODEX (ROLODEX_ID);

ALTER TABLE AWARD_TEMPLATE_CONTACT
    ADD CONSTRAINT FK_AWD_TEMPL_CONTACT_TYPE_CODE FOREIGN KEY (CONTACT_TYPE_CODE)
    REFERENCES CONTACT_TYPE (CONTACT_TYPE_CODE);


ALTER TABLE AWARD_TEMPLATE_REPORT_TERMS
    ADD CONSTRAINT FK11_AWD_TEMPLATE_REPORT_TERMS FOREIGN KEY (FREQUENCY_BASE_CODE)
    REFERENCES FREQUENCY_BASE (FREQUENCY_BASE_CODE);

ALTER TABLE AWARD_TEMPLATE_REPORT_TERMS
    ADD CONSTRAINT FK9_AWD_TEMPLATE_REPORT_TERMS FOREIGN KEY (REPORT_CODE)
    REFERENCES REPORT (REPORT_CODE);

ALTER TABLE AWARD_TEMPLATE_REPORT_TERMS
    ADD CONSTRAINT FK10_AWD_TEMPLATE_REPORT_TERMS FOREIGN KEY (FREQUENCY_CODE)
    REFERENCES FREQUENCY (FREQUENCY_CODE);

ALTER TABLE AWARD_TEMPLATE_REPORT_TERMS
    ADD CONSTRAINT FK7_AWD_TEMPLATE_REPORT_TERMS FOREIGN KEY (AWARD_TEMPLATE_CODE)
    REFERENCES AWARD_TEMPLATE (AWARD_TEMPLATE_CODE);

ALTER TABLE AWARD_TEMPLATE_REPORT_TERMS
    ADD CONSTRAINT FK8_AWD_TEMPLATE_REPORT_TERMS FOREIGN KEY (REPORT_CLASS_CODE)
    REFERENCES REPORT_CLASS (REPORT_CLASS_CODE);

ALTER TABLE AWARD_TEMPLATE_REPORT_TERMS
    ADD CONSTRAINT FK2_AWD_TEMPLATE_REPORT_TERMS FOREIGN KEY (OSP_DISTRIBUTION_CODE)
    REFERENCES DISTRIBUTION (OSP_DISTRIBUTION_CODE);


ALTER TABLE AWARD_TEMPLATE_TERMS
    ADD CONSTRAINT FK1_AWARD_TEMPLATE_TERMS FOREIGN KEY (AWARD_TEMPLATE_CODE)
    REFERENCES AWARD_TEMPLATE (AWARD_TEMPLATE_CODE);

ALTER TABLE AWARD_TEMPLATE_TERMS
    ADD CONSTRAINT FK2_AWARD_TEMPLATE_TERMS FOREIGN KEY (SPONSOR_TERM_ID)
    REFERENCES SPONSOR_TERM (SPONSOR_TERM_ID);


ALTER TABLE AWARD_TEMPL_REP_TERMS_RECNT
    ADD CONSTRAINT FK2_AWD_TEMPL_REP_TERMS_RECNT FOREIGN KEY (CONTACT_TYPE_CODE)
    REFERENCES CONTACT_TYPE (CONTACT_TYPE_CODE);

ALTER TABLE AWARD_TEMPL_REP_TERMS_RECNT
    ADD CONSTRAINT FK1_AWD_TEMPL_REP_TERMS_RECNT FOREIGN KEY (ROLODEX_ID)
    REFERENCES ROLODEX (ROLODEX_ID);



ALTER TABLE AWARD_TRANSFERRING_SPONSOR
    ADD CONSTRAINT FK2_AWARD_TRANSFERRING_SPONSOR FOREIGN KEY (SPONSOR_CODE)
    REFERENCES SPONSOR (SPONSOR_CODE);

ALTER TABLE AWARD_TRANSFERRING_SPONSOR
    ADD CONSTRAINT FK_AWARD_TRANSFERRING_SPONSOR FOREIGN KEY (AWARD_ID)
    REFERENCES AWARD (AWARD_ID);




ALTER TABLE AWD_BGT_DET_CAL_AMTS_EXT
    ADD CONSTRAINT FK_AWD_BGT_DET_CAL_AMTS_EXT FOREIGN KEY (BUDGET_DETAILS_CAL_AMTS_ID)
    REFERENCES BUDGET_DETAILS_CAL_AMTS (BUDGET_DETAILS_CAL_AMTS_ID);


ALTER TABLE AWD_BUDGET_PER_CAL_AMTS_EXT
    ADD CONSTRAINT FK_AWD_BGT_PER_CAL_AMTS_EXT FOREIGN KEY (BUDGET_PERSONNEL_CAL_AMTS_ID)
    REFERENCES BUDGET_PERSONNEL_CAL_AMTS (BUDGET_PERSONNEL_CAL_AMTS_ID);


ALTER TABLE AWD_BUDGET_PER_DET_EXT
    ADD CONSTRAINT FK_AWD_BUDGET_PER_DET_EXT FOREIGN KEY (BUDGET_PERSONNEL_DETAILS_ID)
    REFERENCES BUDGET_PERSONNEL_DETAILS (BUDGET_PERSONNEL_DETAILS_ID);


ALTER TABLE BATCH_CORRESPONDENCE
    ADD CONSTRAINT FK_BATCH_CORRESPONDENCE FOREIGN KEY (FINAL_ACTION_TYPE_CODE)
    REFERENCES PROTOCOL_ACTION_TYPE (PROTOCOL_ACTION_TYPE_CODE);

ALTER TABLE BATCH_CORRESPONDENCE
    ADD CONSTRAINT FK_BATCH_CORRESPONDENCE_2 FOREIGN KEY (FINAL_ACTION_CORRESP_TYPE)
    REFERENCES PROTO_CORRESP_TYPE (PROTO_CORRESP_TYPE_CODE);


ALTER TABLE BATCH_CORRESPONDENCE_DETAIL
    ADD CONSTRAINT FK_BATCH_CORRESPONDENCE_DETAIL FOREIGN KEY (PROTO_CORRESP_TYPE_CODE)
    REFERENCES PROTO_CORRESP_TYPE (PROTO_CORRESP_TYPE_CODE);


ALTER TABLE BUDGET
    ADD CONSTRAINT FK_BUDGET_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE BUDGET_CATEGORY
    ADD CONSTRAINT FK_BUDGET_CATEGORY_KRA FOREIGN KEY (CATEGORY_TYPE)
    REFERENCES BUDGET_CATEGORY_TYPE (BUDGET_CATEGORY_TYPE_CODE);





ALTER TABLE BUDGET_DETAILS
    ADD CONSTRAINT FK1_BUDGET_DETAILS FOREIGN KEY (BUDGET_PERIOD_NUMBER)
    REFERENCES BUDGET_PERIODS (BUDGET_PERIOD_NUMBER);

ALTER TABLE BUDGET_DETAILS
    ADD CONSTRAINT FK_BUDGET_DETAILS FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);

ALTER TABLE BUDGET_DETAILS
    ADD CONSTRAINT FK_BUDGET_DETAILS_HIER FOREIGN KEY (HIERARCHY_PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE BUDGET_DETAILS_CAL_AMTS
    ADD CONSTRAINT FK_BUDGET_DETAILS_CAL_AMTS FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);

ALTER TABLE BUDGET_DETAILS_CAL_AMTS
    ADD CONSTRAINT FK1_BUDGET_DETAILS_CAL_AMTS FOREIGN KEY (BUDGET_DETAILS_ID)
    REFERENCES BUDGET_DETAILS (BUDGET_DETAILS_ID);



ALTER TABLE BUDGET_MODULAR
    ADD CONSTRAINT FK1_BUDGET_MODULAR FOREIGN KEY (BUDGET_PERIOD_NUMBER)
    REFERENCES BUDGET_PERIODS (BUDGET_PERIOD_NUMBER);

ALTER TABLE BUDGET_MODULAR
    ADD CONSTRAINT FK_BUDGET_MODULAR FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);


ALTER TABLE BUDGET_MODULAR_IDC
    ADD CONSTRAINT FK_BUDGET_MODULAR_IDC FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);

ALTER TABLE BUDGET_MODULAR_IDC
    ADD CONSTRAINT FK1_BUDGET_MODULAR_IDC FOREIGN KEY (BUDGET_PERIOD_NUMBER)
    REFERENCES BUDGET_MODULAR (BUDGET_PERIOD_NUMBER);


ALTER TABLE BUDGET_PERIODS
    ADD CONSTRAINT FK_BUDGET_PERIODS FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);



ALTER TABLE BUDGET_PERSONNEL_CAL_AMTS
    ADD CONSTRAINT FK_BUDGET_PERSONNEL_CAL_AMTS FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);

ALTER TABLE BUDGET_PERSONNEL_CAL_AMTS
    ADD CONSTRAINT FK1_BUDGET_PERSONNEL_CAL_AMTS FOREIGN KEY (BUDGET_PERSONNEL_DETAILS_ID)
    REFERENCES BUDGET_PERSONNEL_DETAILS (BUDGET_PERSONNEL_DETAILS_ID);


ALTER TABLE BUDGET_PERSONNEL_DETAILS
    ADD CONSTRAINT FK1_BUDGET_PERSONNEL_DETAILS FOREIGN KEY (BUDGET_DETAILS_ID)
    REFERENCES BUDGET_DETAILS (BUDGET_DETAILS_ID);

ALTER TABLE BUDGET_PERSONNEL_DETAILS
    ADD CONSTRAINT FK_BUDGET_PERSONNEL_DETAILS FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);


ALTER TABLE BUDGET_PERSONS
    ADD CONSTRAINT FK_BUDGET_PERSONS FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);

ALTER TABLE BUDGET_PERSONS
    ADD CONSTRAINT FK_BUDGET_PERSONS_HIER FOREIGN KEY (HIERARCHY_PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE BUDGET_PERSONS
    ADD CONSTRAINT FK_APPOINTMENT_TYPE_CODE_KRA FOREIGN KEY (APPOINTMENT_TYPE_CODE)
    REFERENCES APPOINTMENT_TYPE (APPOINTMENT_TYPE_CODE);


ALTER TABLE BUDGET_PER_DET_RATE_AND_BASE
    ADD CONSTRAINT FK1_BGT_PER_DET_RATE_AND_BASE FOREIGN KEY (BUDGET_PERSONNEL_DETAILS_ID)
    REFERENCES BUDGET_PERSONNEL_DETAILS (BUDGET_PERSONNEL_DETAILS_ID);

ALTER TABLE BUDGET_PER_DET_RATE_AND_BASE
    ADD CONSTRAINT FK_PER_DET_RATE_AND_BASE FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);

ALTER TABLE BUDGET_PER_DET_RATE_AND_BASE
    ADD CONSTRAINT FK_BGT_PER_DET_RATE_AND_BASE FOREIGN KEY (BUDGET_PERSONNEL_CAL_AMTS_ID)
    REFERENCES BUDGET_PERSONNEL_CAL_AMTS (BUDGET_PERSONNEL_CAL_AMTS_ID);


ALTER TABLE BUDGET_PROJECT_INCOME
    ADD CONSTRAINT FK_BUDGET_PROJ_INC_BP_KRA FOREIGN KEY (BUDGET_PERIOD_NUMBER)
    REFERENCES BUDGET_PERIODS (BUDGET_PERIOD_NUMBER);

ALTER TABLE BUDGET_PROJECT_INCOME
    ADD CONSTRAINT FK_PROJECT_INCOME FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);


ALTER TABLE BUDGET_RATE_AND_BASE
    ADD CONSTRAINT FK2_BUDGET_RATE_AND_BASE FOREIGN KEY (BUDGET_DETAILS_CAL_AMTS_ID)
    REFERENCES BUDGET_DETAILS_CAL_AMTS (BUDGET_DETAILS_CAL_AMTS_ID);

ALTER TABLE BUDGET_RATE_AND_BASE
    ADD CONSTRAINT FK1_BUDGET_RATE_AND_BASE FOREIGN KEY (BUDGET_DETAILS_ID)
    REFERENCES BUDGET_DETAILS (BUDGET_DETAILS_ID);

ALTER TABLE BUDGET_RATE_AND_BASE
    ADD CONSTRAINT FK_BUDGET_RATE_AND_BASE FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);



ALTER TABLE BUDGET_SUB_AWARDS
    ADD CONSTRAINT FK_BUDGET_SUB_AWARDS FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);


ALTER TABLE BUDGET_SUB_AWARD_ATT
    ADD CONSTRAINT FK1_BUDGET_SUB_AWARD_ATT FOREIGN KEY (BUDGET_ID, SUB_AWARD_NUMBER)
    REFERENCES BUDGET_SUB_AWARD_FILES (BUDGET_ID, SUB_AWARD_NUMBER);

ALTER TABLE BUDGET_SUB_AWARD_ATT
    ADD CONSTRAINT FK_BUDGET_SUB_AWARD_ATT FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);


ALTER TABLE BUDGET_SUB_AWARD_FILES
    ADD CONSTRAINT FK1_BUDGET_SUB_AWARD_FILES FOREIGN KEY (SUB_AWARD_NUMBER, BUDGET_ID)
    REFERENCES BUDGET_SUB_AWARDS (SUB_AWARD_NUMBER, BUDGET_ID);

ALTER TABLE BUDGET_SUB_AWARD_FILES
    ADD CONSTRAINT FK_BUDGET_SUB_AWARD_FILES FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);





ALTER TABLE COEUS_SUB_MODULE
    ADD CONSTRAINT FK_COEUS_SUB_MODULE FOREIGN KEY (MODULE_CODE)
    REFERENCES COEUS_MODULE (MODULE_CODE);



ALTER TABLE COMMITTEE
    ADD CONSTRAINT FK_COMMITTEE_3 FOREIGN KEY (DEFAULT_REVIEW_TYPE_CODE)
    REFERENCES PROTOCOL_REVIEW_TYPE (PROTOCOL_REVIEW_TYPE_CODE);

ALTER TABLE COMMITTEE
    ADD CONSTRAINT FK_COMMITTEE_2 FOREIGN KEY (HOME_UNIT_NUMBER)
    REFERENCES UNIT (UNIT_NUMBER);

ALTER TABLE COMMITTEE
    ADD CONSTRAINT FK_COMMITTEE_1 FOREIGN KEY (COMMITTEE_TYPE_CODE)
    REFERENCES COMMITTEE_TYPE (COMMITTEE_TYPE_CODE);

ALTER TABLE COMMITTEE
    ADD CONSTRAINT FK_COMMITTEE_DOCUMENT FOREIGN KEY (DOCUMENT_NUMBER)
    REFERENCES COMMITTEE_DOCUMENT (DOCUMENT_NUMBER);

ALTER TABLE COMMITTEE
    ADD CONSTRAINT FK_COMMITTEE_4 FOREIGN KEY (APPLICABLE_REVIEW_TYPE_CODE)
    REFERENCES PROTOCOL_REVIEW_TYPE (PROTOCOL_REVIEW_TYPE_CODE);




ALTER TABLE COMM_BATCH_CORRESP
    ADD CONSTRAINT FK_COMM_BATCH_CORRESP2 FOREIGN KEY (BATCH_CORRESPONDENCE_TYPE_CODE)
    REFERENCES BATCH_CORRESPONDENCE (BATCH_CORRESPONDENCE_TYPE_CODE);


ALTER TABLE COMM_BATCH_CORRESP_DETAIL
    ADD CONSTRAINT FK_COMM_CORRESP_BATCH_DETAIL2 FOREIGN KEY (PROTOCOL_ACTION_ID)
    REFERENCES PROTOCOL_ACTIONS (PROTOCOL_ACTION_ID);

ALTER TABLE COMM_BATCH_CORRESP_DETAIL
    ADD CONSTRAINT FK_COMM_CORRESP_BATCH_DETAIL FOREIGN KEY (COMM_BATCH_CORRESP_ID)
    REFERENCES COMM_BATCH_CORRESP (COMM_BATCH_CORRESP_ID);

ALTER TABLE COMM_BATCH_CORRESP_DETAIL
    ADD CONSTRAINT FK_COMM_CORRESP_BATCH_DETAIL3 FOREIGN KEY (PROTOCOL_CORRESPONDENCE_ID)
    REFERENCES PROTOCOL_CORRESPONDENCE (ID);



ALTER TABLE COMM_MEMBERSHIPS
    ADD CONSTRAINT FK_COMM_MEMBERSHIPS_2 FOREIGN KEY (MEMBERSHIP_TYPE_CODE)
    REFERENCES COMM_MEMBERSHIP_TYPE (MEMBERSHIP_TYPE_CODE);

ALTER TABLE COMM_MEMBERSHIPS
    ADD CONSTRAINT FK_COMM_MEMBERSHIPS FOREIGN KEY (COMMITTEE_ID_FK)
    REFERENCES COMMITTEE (ID);



ALTER TABLE COMM_MEMBER_EXPERTISE
    ADD CONSTRAINT FK_COMM_MEMBER_EXPERTISE_2 FOREIGN KEY (RESEARCH_AREA_CODE)
    REFERENCES RESEARCH_AREAS (RESEARCH_AREA_CODE);

ALTER TABLE COMM_MEMBER_EXPERTISE
    ADD CONSTRAINT FK_COMM_MEMBER_EXPERTISE FOREIGN KEY (COMM_MEMBERSHIP_ID_FK)
    REFERENCES COMM_MEMBERSHIPS (COMM_MEMBERSHIP_ID);


ALTER TABLE COMM_MEMBER_ROLES
    ADD CONSTRAINT FK_COMM_MEMBER_ROLES FOREIGN KEY (COMM_MEMBERSHIP_ID_FK)
    REFERENCES COMM_MEMBERSHIPS (COMM_MEMBERSHIP_ID);

ALTER TABLE COMM_MEMBER_ROLES
    ADD CONSTRAINT FK_COMM_MEMBER_ROLES_2 FOREIGN KEY (MEMBERSHIP_ROLE_CODE)
    REFERENCES MEMBERSHIP_ROLE (MEMBERSHIP_ROLE_CODE);


ALTER TABLE COMM_RESEARCH_AREAS
    ADD CONSTRAINT FK_COMM_RESEARCH_AREAS2 FOREIGN KEY (RESEARCH_AREA_CODE)
    REFERENCES RESEARCH_AREAS (RESEARCH_AREA_CODE);

ALTER TABLE COMM_RESEARCH_AREAS
    ADD CONSTRAINT FK_COMM_RESEARCH_AREAS1 FOREIGN KEY (COMMITTEE_ID_FK)
    REFERENCES COMMITTEE (ID);


ALTER TABLE COMM_SCHEDULE
    ADD CONSTRAINT FK_COMM_SCHEDULE_2 FOREIGN KEY (COMMITTEE_ID_FK)
    REFERENCES COMMITTEE (ID);

ALTER TABLE COMM_SCHEDULE
    ADD CONSTRAINT FK_COMM_SCHEDULE FOREIGN KEY (SCHEDULE_STATUS_CODE)
    REFERENCES SCHEDULE_STATUS (SCHEDULE_STATUS_CODE);


ALTER TABLE COMM_SCHEDULE_ACT_ITEMS
    ADD CONSTRAINT FK_COMM_SCHEDULE_ACT_ITEMS FOREIGN KEY (SCHEDULE_ID_FK)
    REFERENCES COMM_SCHEDULE (ID);

ALTER TABLE COMM_SCHEDULE_ACT_ITEMS
    ADD CONSTRAINT FK_COMM_SCHEDULE_ACT_ITEMS_2 FOREIGN KEY (SCHEDULE_ACT_ITEM_TYPE_CODE)
    REFERENCES SCHEDULE_ACT_ITEM_TYPE (SCHEDULE_ACT_ITEM_TYPE_CODE);


ALTER TABLE COMM_SCHEDULE_ATTENDANCE
    ADD CONSTRAINT FK_COMM_SCHEDULE_ATTENDANCE FOREIGN KEY (SCHEDULE_ID_FK)
    REFERENCES COMM_SCHEDULE (ID);



ALTER TABLE COMM_SCHEDULE_MINUTES
    ADD CONSTRAINT FK_COMM_SCHEDULE_MINUTES_FK4 FOREIGN KEY (PROTOCOL_ONLN_RVW_FK)
    REFERENCES PROTOCOL_ONLN_RVWS (PROTOCOL_ONLN_RVW_ID);

ALTER TABLE COMM_SCHEDULE_MINUTES
    ADD CONSTRAINT COMM_SCHEDULE_MINUTES_PRO_FK1 FOREIGN KEY (REVIEWER_ID_FK)
    REFERENCES PROTOCOL_REVIEWERS (PROTOCOL_REVIEWER_ID);

ALTER TABLE COMM_SCHEDULE_MINUTES
    ADD CONSTRAINT FK_COMM_SCHEDULE_MINUTES_2 FOREIGN KEY (MINUTE_ENTRY_TYPE_CODE)
    REFERENCES MINUTE_ENTRY_TYPE (MINUTE_ENTRY_TYPE_CODE);

ALTER TABLE COMM_SCHEDULE_MINUTES
    ADD CONSTRAINT FK_COMM_SCHEDULE_MINUTES_3 FOREIGN KEY (PROTOCOL_CONTINGENCY_CODE)
    REFERENCES PROTOCOL_CONTINGENCY (PROTOCOL_CONTINGENCY_CODE);


ALTER TABLE COMM_SCHEDULE_MINUTE_DOC
    ADD CONSTRAINT FK_COMM_SCHEDULE_MINUTE_DOC FOREIGN KEY (SCHEDULE_ID_FK)
    REFERENCES COMM_SCHEDULE (ID);




ALTER TABLE COST_ELEMENT
    ADD CONSTRAINT FK_COST_ELEMENT_CATEGORY_KRA FOREIGN KEY (BUDGET_CATEGORY_CODE)
    REFERENCES BUDGET_CATEGORY (BUDGET_CATEGORY_CODE);



ALTER TABLE CUSTOM_ATTRIBUTE
    ADD CONSTRAINT FK_CUST_ATTR_DATA_TYPE FOREIGN KEY (DATA_TYPE_CODE)
    REFERENCES CUSTOM_ATTRIBUTE_DATA_TYPE (DATA_TYPE_CODE);



ALTER TABLE CUSTOM_ATTRIBUTE_DOCUMENT
    ADD CONSTRAINT FK_CUST_ATTR_DOC_DOC_TYPE FOREIGN KEY (DOCUMENT_TYPE_CODE)
    REFERENCES FP_DOC_TYPE_T (FDOC_TYP_CD);

ALTER TABLE CUSTOM_ATTRIBUTE_DOCUMENT
    ADD CONSTRAINT FK_CUST_ATTR_DOC_CUST_ATTR FOREIGN KEY (CUSTOM_ATTRIBUTE_ID)
    REFERENCES CUSTOM_ATTRIBUTE (ID);


ALTER TABLE CUSTOM_ATTRIBUTE_DOC_VALUE
    ADD CONSTRAINT FK_CUST_ATTR_DOC_VAL_CUST_ATTR FOREIGN KEY (CUSTOM_ATTRIBUTE_ID)
    REFERENCES CUSTOM_ATTRIBUTE (ID);






ALTER TABLE EPS_PROPOSAL
    ADD CONSTRAINT FK_EPS_PROPOSAL_DOCUMENT FOREIGN KEY (DOCUMENT_NUMBER)
    REFERENCES EPS_PROPOSAL_DOCUMENT (DOCUMENT_NUMBER);

ALTER TABLE EPS_PROPOSAL
    ADD CONSTRAINT EPS_PROPOSAL_FK1 FOREIGN KEY (HIERARCHY_PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE EPS_PROPOSAL_BUDGET_EXT
    ADD CONSTRAINT FK_EPS_PROPOSAL_BUDGET_EXT FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);


ALTER TABLE EPS_PROPOSAL_BUDGET_STATUS
    ADD CONSTRAINT FK_EPS_PROP_BUDGET_STATUS_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);




ALTER TABLE EPS_PROP_ABSTRACT
    ADD CONSTRAINT FK_EPS_PROP_ABSTRACT_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE EPS_PROP_ABSTRACT
    ADD CONSTRAINT FK_EPS_PROP_ABSTRACT_TYPE_KRA FOREIGN KEY (ABSTRACT_TYPE_CODE)
    REFERENCES ABSTRACT_TYPE (ABSTRACT_TYPE_CODE);





ALTER TABLE EPS_PROP_COST_SHARING
    ADD CONSTRAINT FK_EPS_PROP_COST_SHARING FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);


ALTER TABLE EPS_PROP_EXEMPT_NUMBER
    ADD CONSTRAINT FK_EPS_PROP_EXEMPT_NUMBER_KRA FOREIGN KEY (PROPOSAL_NUMBER, SPECIAL_REVIEW_NUMBER)
    REFERENCES EPS_PROP_SPECIAL_REVIEW (PROPOSAL_NUMBER, SPECIAL_REVIEW_NUMBER);

ALTER TABLE EPS_PROP_EXEMPT_NUMBER
    ADD CONSTRAINT FK_EPS_PROP_EXEMPTION_TYPE_KRA FOREIGN KEY (EXEMPTION_TYPE_CODE)
    REFERENCES EXEMPTION_TYPE (EXEMPTION_TYPE_CODE);


ALTER TABLE EPS_PROP_IDC_RATE
    ADD CONSTRAINT FK_EPS_PROP_IDC_RATE FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);


ALTER TABLE EPS_PROP_LA_RATES
    ADD CONSTRAINT FK_EPS_PROP_LA_RATES FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);


ALTER TABLE EPS_PROP_LOCATION
    ADD CONSTRAINT FK_EPS_PROP_LOCATION_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE EPS_PROP_LOCATION
    ADD CONSTRAINT FK_EPS_PROP_LOCATION_RLDEX_KRA FOREIGN KEY (ROLODEX_ID)
    REFERENCES ROLODEX (ROLODEX_ID);


ALTER TABLE EPS_PROP_PERSON
    ADD CONSTRAINT FK_EPS_PROP_PERSON_HIER FOREIGN KEY (HIERARCHY_PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE EPS_PROP_PERSON_BIO
    ADD CONSTRAINT FK1_EPS_PROP_PERSON_BIO_KRA FOREIGN KEY (DOCUMENT_TYPE_CODE)
    REFERENCES EPS_PROP_PER_DOC_TYPE (DOCUMENT_TYPE_CODE);


ALTER TABLE EPS_PROP_PERSON_BIO_ATTACHMENT
    ADD CONSTRAINT FK1_EPS_PROP_PSN_BIO_ATT_KRA FOREIGN KEY (PROPOSAL_NUMBER, PROP_PERSON_NUMBER, BIO_NUMBER)
    REFERENCES EPS_PROP_PERSON_BIO (PROPOSAL_NUMBER, PROP_PERSON_NUMBER, BIO_NUMBER)
ON DELETE CASCADE;





ALTER TABLE EPS_PROP_PERS_YNQ
    ADD CONSTRAINT FK_EPS_PROP_PERS_YNQ_ID_KRA FOREIGN KEY (QUESTION_ID)
    REFERENCES YNQ (QUESTION_ID);


ALTER TABLE EPS_PROP_PER_CREDIT_SPLIT
    ADD CONSTRAINT FK2_EPS_PROP_PER_CREDIT_SPLIT FOREIGN KEY (INV_CREDIT_TYPE_CODE)
    REFERENCES INV_CREDIT_TYPE (INV_CREDIT_TYPE_CODE);

ALTER TABLE EPS_PROP_PER_CREDIT_SPLIT
    ADD CONSTRAINT FK1_EPS_PROP_PER_CREDIT_SPLIT FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);



ALTER TABLE EPS_PROP_RATES
    ADD CONSTRAINT FK_EPS_PROP_RATES FOREIGN KEY (BUDGET_ID)
    REFERENCES BUDGET (BUDGET_ID);

ALTER TABLE EPS_PROP_RATES
    ADD CONSTRAINT FK_EPS_PROP_RATES_ACTIVITY_KRA FOREIGN KEY (ACTIVITY_TYPE_CODE)
    REFERENCES ACTIVITY_TYPE (ACTIVITY_TYPE_CODE);


ALTER TABLE EPS_PROP_SCIENCE_KEYWORD
    ADD CONSTRAINT FK_EPS_PROP_SCI_KWD_HIER FOREIGN KEY (HIERARCHY_PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE EPS_PROP_SCIENCE_KEYWORD
    ADD CONSTRAINT FK_EPS_PROP_SCIE_KEY_KEYW_KRA FOREIGN KEY (SCIENCE_KEYWORD_CODE)
    REFERENCES SCIENCE_KEYWORD (SCIENCE_KEYWORD_CODE);

ALTER TABLE EPS_PROP_SCIENCE_KEYWORD
    ADD CONSTRAINT FK_EPS_PROP_SCIE_KEY_PROP_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE EPS_PROP_SITES
    ADD CONSTRAINT FK_EPS_PROP_SITES2 FOREIGN KEY (LOCATION_TYPE_CODE)
    REFERENCES LOCATION_TYPE (LOCATION_TYPE_CODE);

ALTER TABLE EPS_PROP_SITES
    ADD CONSTRAINT FK_EPS_PROP_SITES1 FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE EPS_PROP_SPECIAL_REVIEW
    ADD CONSTRAINT FK_EPS_PROP_SPECIAL_REVIEW_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE EPS_PROP_SPECIAL_REVIEW
    ADD CONSTRAINT FK_EPS_PROP_SP_CODE_KRA FOREIGN KEY (SPECIAL_REVIEW_CODE)
    REFERENCES SPECIAL_REVIEW (SPECIAL_REVIEW_CODE);

ALTER TABLE EPS_PROP_SPECIAL_REVIEW
    ADD CONSTRAINT FK_EPS_PROP_SP_APPROV_TYPE_KRA FOREIGN KEY (APPROVAL_TYPE_CODE)
    REFERENCES SP_REV_APPROVAL_TYPE (APPROVAL_TYPE_CODE);

ALTER TABLE EPS_PROP_SPECIAL_REVIEW
    ADD CONSTRAINT FK_EPS_PROP_SPEC_RVW_HIER FOREIGN KEY (HIERARCHY_PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE EPS_PROP_UNIT_CREDIT_SPLIT
    ADD CONSTRAINT FK1_EPS_PROP_UNIT_CREDIT_SPLIT FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE EPS_PROP_UNIT_CREDIT_SPLIT
    ADD CONSTRAINT FK2_EPS_PROP_UNIT_CREDIT_SPLIT FOREIGN KEY (INV_CREDIT_TYPE_CODE)
    REFERENCES INV_CREDIT_TYPE (INV_CREDIT_TYPE_CODE);


ALTER TABLE EPS_PROP_USER_ROLES
    ADD CONSTRAINT FK_EPS_PROP_USER_ROLES_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE EPS_PROP_YNQ
    ADD CONSTRAINT FK_EPS_PROP_YNQ_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE EPS_PROP_YNQ
    ADD CONSTRAINT FK_EPS_PROP_YNQ_ID_KRA FOREIGN KEY (QUESTION_ID)
    REFERENCES YNQ (QUESTION_ID);











ALTER TABLE INSTITUTE_LA_RATES
    ADD CONSTRAINT FK_INSTITUTE_LA_RATES_UNIT_KRA FOREIGN KEY (UNIT_NUMBER)
    REFERENCES UNIT (UNIT_NUMBER);



ALTER TABLE INSTITUTE_RATES
    ADD CONSTRAINT FK_INST_RATES_ACTIVITY_KRA FOREIGN KEY (ACTIVITY_TYPE_CODE)
    REFERENCES ACTIVITY_TYPE (ACTIVITY_TYPE_CODE);

ALTER TABLE INSTITUTE_RATES
    ADD CONSTRAINT FK_INST_RATES_UNIT_NUMBER_KRA FOREIGN KEY (UNIT_NUMBER)
    REFERENCES UNIT (UNIT_NUMBER);

ALTER TABLE INSTITUTE_RATES
    ADD CONSTRAINT FK_INSTITUTE_RATES_KRA FOREIGN KEY (RATE_CLASS_CODE, RATE_TYPE_CODE)
    REFERENCES RATE_TYPE (RATE_CLASS_CODE, RATE_TYPE_CODE);








ALTER TABLE KRA_USER
    ADD CONSTRAINT FK_USER_UNIT_NUMBER_KRA FOREIGN KEY (UNIT_NUMBER)
    REFERENCES UNIT (UNIT_NUMBER);



ALTER TABLE KRNS_ATT_T
    ADD CONSTRAINT KRNS_ATT_TR1 FOREIGN KEY (NTE_ID)
    REFERENCES KRNS_NTE_T (NTE_ID);






ALTER TABLE KRNS_MAINT_DOC_T
    ADD CONSTRAINT KRNS_MAINT_DOC_TR1 FOREIGN KEY (DOC_HDR_ID)
    REFERENCES KRNS_DOC_HDR_T (DOC_HDR_ID);



ALTER TABLE KRNS_NTE_T
    ADD CONSTRAINT KRNS_NTE_TR1 FOREIGN KEY (NTE_TYP_CD)
    REFERENCES KRNS_NTE_TYP_T (NTE_TYP_CD);









ALTER TABLE KRSB_QRTZ_BLOB_TRIGGERS
    ADD CONSTRAINT KRSB_QRTZ_BLOB_TRIGGERS_TR1 FOREIGN KEY (TRIGGER_NAME, TRIGGER_GROUP)
    REFERENCES KRSB_QRTZ_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP);



ALTER TABLE KRSB_QRTZ_CRON_TRIGGERS
    ADD CONSTRAINT KRSB_QRTZ_CRON_TRIGGERS_TR1 FOREIGN KEY (TRIGGER_NAME, TRIGGER_GROUP)
    REFERENCES KRSB_QRTZ_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP);




ALTER TABLE KRSB_QRTZ_JOB_LISTENERS
    ADD CONSTRAINT KRSB_QUARTZ_JOB_LISTENERS_TR1 FOREIGN KEY (JOB_NAME, JOB_GROUP)
    REFERENCES KRSB_QRTZ_JOB_DETAILS (JOB_NAME, JOB_GROUP);





ALTER TABLE KRSB_QRTZ_SIMPLE_TRIGGERS
    ADD CONSTRAINT KRSB_QRTZ_SIMPLE_TRIGGERS_TR1 FOREIGN KEY (TRIGGER_NAME, TRIGGER_GROUP)
    REFERENCES KRSB_QRTZ_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP);



ALTER TABLE KRSB_QRTZ_TRIGGER_LISTENERS
    ADD CONSTRAINT KRSB_QRTZ_TRIGGER_LISTENE_TR1 FOREIGN KEY (TRIGGER_NAME, TRIGGER_GROUP)
    REFERENCES KRSB_QRTZ_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP);








ALTER TABLE NARRATIVE
    ADD CONSTRAINT FK_NARRATIVE_STATUS_CODE_KRA FOREIGN KEY (MODULE_STATUS_CODE)
    REFERENCES NARRATIVE_STATUS (NARRATIVE_STATUS_CODE);

ALTER TABLE NARRATIVE
    ADD CONSTRAINT FK_NARRATIVE_TYPE_CODE_KRA FOREIGN KEY (NARRATIVE_TYPE_CODE)
    REFERENCES NARRATIVE_TYPE (NARRATIVE_TYPE_CODE);

ALTER TABLE NARRATIVE
    ADD CONSTRAINT FK_NARRATIVE_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE NARRATIVE
    ADD CONSTRAINT FK_NARRATIVE_HIER FOREIGN KEY (HIERARCHY_PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE NARRATIVE_ATTACHMENT
    ADD CONSTRAINT FK_NARRATIVE_ATTACHMENT_KRA FOREIGN KEY (PROPOSAL_NUMBER, MODULE_NUMBER)
    REFERENCES NARRATIVE (PROPOSAL_NUMBER, MODULE_NUMBER)
ON DELETE CASCADE;




ALTER TABLE NARRATIVE_USER_RIGHTS
    ADD CONSTRAINT FK_NARRATIVE_USER_RIGHTS_KRA FOREIGN KEY (PROPOSAL_NUMBER, MODULE_NUMBER)
    REFERENCES NARRATIVE (PROPOSAL_NUMBER, MODULE_NUMBER);





ALTER TABLE ORGANIZATION_AUDIT
    ADD CONSTRAINT FK_ORGANIZATION_AUDIT_KRA FOREIGN KEY (ORGANIZATION_ID)
    REFERENCES ORGANIZATION (ORGANIZATION_ID)
ON DELETE CASCADE;


ALTER TABLE ORGANIZATION_IDC
    ADD CONSTRAINT FK_ORGANIZATION_IDC_KRA FOREIGN KEY (ORGANIZATION_ID)
    REFERENCES ORGANIZATION (ORGANIZATION_ID)
ON DELETE CASCADE;


ALTER TABLE ORGANIZATION_TYPE
    ADD CONSTRAINT FK_ORGANIZATION_TYPE_LIST_KRA FOREIGN KEY (ORGANIZATION_TYPE_CODE)
    REFERENCES ORGANIZATION_TYPE_LIST (ORGANIZATION_TYPE_CODE);

ALTER TABLE ORGANIZATION_TYPE
    ADD CONSTRAINT FK_ORGANIZATION_TYPE_KRA FOREIGN KEY (ORGANIZATION_ID)
    REFERENCES ORGANIZATION (ORGANIZATION_ID);



ALTER TABLE ORGANIZATION_YNQ
    ADD CONSTRAINT FK_ORGANIZATION_YNQ_KRA FOREIGN KEY (ORGANIZATION_ID)
    REFERENCES ORGANIZATION (ORGANIZATION_ID);

ALTER TABLE ORGANIZATION_YNQ
    ADD CONSTRAINT FK_ORGANIZATION_YNQ_ID_KRA FOREIGN KEY (QUESTION_ID)
    REFERENCES YNQ (QUESTION_ID);


ALTER TABLE PENDING_TRANSACTIONS
    ADD CONSTRAINT PENDING_TRANSACTIONS_FK FOREIGN KEY (DOCUMENT_NUMBER)
    REFERENCES TIME_AND_MONEY_DOCUMENT (DOCUMENT_NUMBER);







ALTER TABLE PROPOSAL
    ADD CONSTRAINT FK_PROP_AWD_TYPE FOREIGN KEY (AWARD_TYPE_CODE)
    REFERENCES AWARD_TYPE (AWARD_TYPE_CODE);

ALTER TABLE PROPOSAL
    ADD CONSTRAINT FK_PROPOSAL_SPONSOR_CODE FOREIGN KEY (SPONSOR_CODE)
    REFERENCES SPONSOR (SPONSOR_CODE);

ALTER TABLE PROPOSAL
    ADD CONSTRAINT FK_PROPOSAL_OPPORTUNITY_CODE FOREIGN KEY (NOTICE_OF_OPPORTUNITY_CODE)
    REFERENCES NOTICE_OF_OPPORTUNITY (NOTICE_OF_OPPORTUNITY_CODE);

ALTER TABLE PROPOSAL
    ADD CONSTRAINT FK_PROPOSAL_ACTIVITY_TYPE_CODE FOREIGN KEY (ACTIVITY_TYPE_CODE)
    REFERENCES ACTIVITY_TYPE (ACTIVITY_TYPE_CODE);

ALTER TABLE PROPOSAL
    ADD CONSTRAINT FK_PROPOSAL_ROLODEX_ID FOREIGN KEY (ROLODEX_ID)
    REFERENCES ROLODEX (ROLODEX_ID);

ALTER TABLE PROPOSAL
    ADD CONSTRAINT FK_PROPOSAL_TYPE_CODE FOREIGN KEY (PROPOSAL_TYPE_CODE)
    REFERENCES PROPOSAL_TYPE (PROPOSAL_TYPE_CODE);


ALTER TABLE PROPOSAL_ADMIN_DETAILS
    ADD CONSTRAINT FK_PROPOSAL_ADMIN_DETAILS_2 FOREIGN KEY (INST_PROPOSAL_ID)
    REFERENCES PROPOSAL (PROPOSAL_ID);

ALTER TABLE PROPOSAL_ADMIN_DETAILS
    ADD CONSTRAINT FK_PROPOSAL_ADMIN_DETAILS_1 FOREIGN KEY (DEV_PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE PROPOSAL_COMMENTS
    ADD CONSTRAINT FK_PROPOSAL_COMMENTS_CODE FOREIGN KEY (COMMENT_TYPE_CODE)
    REFERENCES COMMENT_TYPE (COMMENT_TYPE_CODE);

ALTER TABLE PROPOSAL_COMMENTS
    ADD CONSTRAINT FK_PROPOSAL_COMMENTS FOREIGN KEY (PROPOSAL_ID)
    REFERENCES PROPOSAL (PROPOSAL_ID);


ALTER TABLE PROPOSAL_COST_SHARING
    ADD CONSTRAINT FK_PROPOSAL_COST_SHARING FOREIGN KEY (PROPOSAL_ID)
    REFERENCES PROPOSAL (PROPOSAL_ID);


ALTER TABLE PROPOSAL_CUSTOM_DATA
    ADD CONSTRAINT FK_PROPOSAL_CUSTOM_DATA1 FOREIGN KEY (PROPOSAL_ID)
    REFERENCES PROPOSAL (PROPOSAL_ID);

ALTER TABLE PROPOSAL_CUSTOM_DATA
    ADD CONSTRAINT FK_PROPOSAL_CUSTOM_DATA FOREIGN KEY (CUSTOM_ATTRIBUTE_ID)
    REFERENCES CUSTOM_ATTRIBUTE (ID);


ALTER TABLE PROPOSAL_EXEMPT_NUMBER
    ADD CONSTRAINT FK_PROPOSAL_SPECIAL_REVIEW_ID FOREIGN KEY (PROPOSAL_SPECIAL_REVIEW_ID)
    REFERENCES PROPOSAL_SPECIAL_REVIEW (PROPOSAL_SPECIAL_REVIEW_ID);

ALTER TABLE PROPOSAL_EXEMPT_NUMBER
    ADD CONSTRAINT FK_PROP_EXEMPTION_TYPE_CODE FOREIGN KEY (EXEMPTION_TYPE_CODE)
    REFERENCES EXEMPTION_TYPE (EXEMPTION_TYPE_CODE);


ALTER TABLE PROPOSAL_IDC_RATE
    ADD CONSTRAINT FK_PROPOSAL_IDC_RATE FOREIGN KEY (IDC_RATE_TYPE_CODE)
    REFERENCES IDC_RATE_TYPE (IDC_RATE_TYPE_CODE);



ALTER TABLE PROPOSAL_IP_REVIEW_JOIN
    ADD CONSTRAINT FK_PROPOSAL_ID FOREIGN KEY (PROPOSAL_ID)
    REFERENCES PROPOSAL (PROPOSAL_ID);

ALTER TABLE PROPOSAL_IP_REVIEW_JOIN
    ADD CONSTRAINT FK2_IP_REVIEW_ID FOREIGN KEY (IP_REVIEW_ID)
    REFERENCES IP_REVIEW (IP_REVIEW_ID);


ALTER TABLE PROPOSAL_IP_REV_ACTIVITY
    ADD CONSTRAINT FK_IP_REVIEW_ID FOREIGN KEY (IP_REVIEW_ID)
    REFERENCES IP_REVIEW (IP_REVIEW_ID);


ALTER TABLE PROPOSAL_LOG
    ADD CONSTRAINT FK2_PROPOSAL_TYPE_CODE FOREIGN KEY (PROPOSAL_TYPE_CODE)
    REFERENCES PROPOSAL_TYPE (PROPOSAL_TYPE_CODE);

ALTER TABLE PROPOSAL_LOG
    ADD CONSTRAINT FK_LOG_STATUS FOREIGN KEY (LOG_STATUS)
    REFERENCES PROPOSAL_LOG_STATUS (PROPOSAL_LOG_STATUS_CODE);

ALTER TABLE PROPOSAL_LOG
    ADD CONSTRAINT FK_LEAD_UNIT FOREIGN KEY (LEAD_UNIT)
    REFERENCES UNIT (UNIT_NUMBER);

ALTER TABLE PROPOSAL_LOG
    ADD CONSTRAINT FK_PROPOSAL_LOG_TYPE_CODE FOREIGN KEY (PROPOSAL_LOG_TYPE_CODE)
    REFERENCES PROPOSAL_LOG_TYPE (PROPOSAL_LOG_TYPE_CODE);




ALTER TABLE PROPOSAL_NOTEPAD
    ADD CONSTRAINT FK_PROPOSAL_NOTEPAD FOREIGN KEY (PROPOSAL_ID)
    REFERENCES PROPOSAL (PROPOSAL_ID);







ALTER TABLE PROPOSAL_SCIENCE_KEYWORD
    ADD CONSTRAINT FK_PROPOSAL_SCIENCE_KEYWORD2 FOREIGN KEY (SCIENCE_KEYWORD_CODE)
    REFERENCES SCIENCE_KEYWORD (SCIENCE_KEYWORD_CODE);

ALTER TABLE PROPOSAL_SCIENCE_KEYWORD
    ADD CONSTRAINT FK_PROPOSAL_SCIENCE_KEYWORD FOREIGN KEY (PROPOSAL_ID)
    REFERENCES PROPOSAL (PROPOSAL_ID);


ALTER TABLE PROPOSAL_SPECIAL_REVIEW
    ADD CONSTRAINT FK_PROPOSAL_REVIEW_CODE FOREIGN KEY (SPECIAL_REVIEW_CODE)
    REFERENCES SPECIAL_REVIEW (SPECIAL_REVIEW_CODE);

ALTER TABLE PROPOSAL_SPECIAL_REVIEW
    ADD CONSTRAINT FK_PROPOSAL_SPECIAL_REVIEW FOREIGN KEY (PROPOSAL_ID)
    REFERENCES PROPOSAL (PROPOSAL_ID);

ALTER TABLE PROPOSAL_SPECIAL_REVIEW
    ADD CONSTRAINT FK_PROPOSAL_SP_APROVAL_TYPE FOREIGN KEY (APPROVAL_TYPE_CODE)
    REFERENCES SP_REV_APPROVAL_TYPE (APPROVAL_TYPE_CODE);





ALTER TABLE PROPOSAL_UNITS
    ADD CONSTRAINT FK_PROPOSAL_UNITS_UNIT_NUMBER FOREIGN KEY (UNIT_NUMBER)
    REFERENCES UNIT (UNIT_NUMBER);



ALTER TABLE PROPOSAL_UNIT_CREDIT_SPLIT
    ADD CONSTRAINT FK1_PROPOSAL_UNIT_CREDIT_SPLIT FOREIGN KEY (PROPOSAL_ID)
    REFERENCES PROPOSAL (PROPOSAL_ID);

ALTER TABLE PROPOSAL_UNIT_CREDIT_SPLIT
    ADD CONSTRAINT FK2_PROPOSAL_UNIT_CREDIT_SPLIT FOREIGN KEY (INV_CREDIT_TYPE_CODE)
    REFERENCES INV_CREDIT_TYPE (INV_CREDIT_TYPE_CODE);



ALTER TABLE PROTOCOL
    ADD CONSTRAINT FK_PROTOCOL FOREIGN KEY (PROTOCOL_TYPE_CODE)
    REFERENCES PROTOCOL_TYPE (PROTOCOL_TYPE_CODE);

ALTER TABLE PROTOCOL
    ADD CONSTRAINT FK_PROTOCOL_DOCUMENT FOREIGN KEY (DOCUMENT_NUMBER)
    REFERENCES PROTOCOL_DOCUMENT (DOCUMENT_NUMBER);

ALTER TABLE PROTOCOL
    ADD CONSTRAINT FK_PROTOCOL_2 FOREIGN KEY (PROTOCOL_STATUS_CODE)
    REFERENCES PROTOCOL_STATUS (PROTOCOL_STATUS_CODE);


ALTER TABLE PROTOCOL_ACTIONS
    ADD CONSTRAINT FK_PROTOCOL_ACTIONS1 FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_ACTIONS
    ADD CONSTRAINT FK_PROTOCOL_ACTIONS2 FOREIGN KEY (SUBMISSION_ID_FK)
    REFERENCES PROTOCOL_SUBMISSION (SUBMISSION_ID);

ALTER TABLE PROTOCOL_ACTIONS
    ADD CONSTRAINT FK_PROTOCOL_ACTIONS3 FOREIGN KEY (PROTOCOL_ACTION_TYPE_CODE)
    REFERENCES PROTOCOL_ACTION_TYPE (PROTOCOL_ACTION_TYPE_CODE);




ALTER TABLE PROTOCOL_ATTACHMENT_PERSONNEL
    ADD CONSTRAINT FK_PA_PERSONNEL_FILE FOREIGN KEY (FILE_ID)
    REFERENCES ATTACHMENT_FILE (FILE_ID)
ON DELETE CASCADE;

ALTER TABLE PROTOCOL_ATTACHMENT_PERSONNEL
    ADD CONSTRAINT FK_PA_PERSONNEL_TYPE FOREIGN KEY (TYPE_CD)
    REFERENCES PROTOCOL_ATTACHMENT_TYPE (TYPE_CD);

ALTER TABLE PROTOCOL_ATTACHMENT_PERSONNEL
    ADD CONSTRAINT FK_PERSON FOREIGN KEY (PERSON_ID)
    REFERENCES PROTOCOL_PERSONS (PROTOCOL_PERSON_ID);

ALTER TABLE PROTOCOL_ATTACHMENT_PERSONNEL
    ADD CONSTRAINT FK_PA_PERSONNEL_PROTOCOL FOREIGN KEY (PROTOCOL_ID_FK)
    REFERENCES PROTOCOL (PROTOCOL_ID);


ALTER TABLE PROTOCOL_ATTACHMENT_PROTOCOL
    ADD CONSTRAINT FK_PROTOCOL_ATTACHMENT_TYPE FOREIGN KEY (TYPE_CD)
    REFERENCES PROTOCOL_ATTACHMENT_TYPE (TYPE_CD);

ALTER TABLE PROTOCOL_ATTACHMENT_PROTOCOL
    ADD CONSTRAINT FK_PA_PROTOCOL_PROTOCOL FOREIGN KEY (PROTOCOL_ID_FK)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_ATTACHMENT_PROTOCOL
    ADD CONSTRAINT FK_PA_PROTOCOL_FILE FOREIGN KEY (FILE_ID)
    REFERENCES ATTACHMENT_FILE (FILE_ID)
ON DELETE CASCADE;

ALTER TABLE PROTOCOL_ATTACHMENT_PROTOCOL
    ADD CONSTRAINT FK_PROTOCOL_ATTACH_STATUS FOREIGN KEY (STATUS_CD)
    REFERENCES PROTOCOL_ATTACHMENT_STATUS (STATUS_CD);




ALTER TABLE PROTOCOL_ATTACHMENT_TYPE_GROUP
    ADD CONSTRAINT FK_PROTOCOL_ATTACH_TG_GROUP FOREIGN KEY (GROUP_CD)
    REFERENCES PROTOCOL_ATTACHMENT_GROUP (GROUP_CD);

ALTER TABLE PROTOCOL_ATTACHMENT_TYPE_GROUP
    ADD CONSTRAINT FK_PROTOCOL_ATTACH_TG_TYPE FOREIGN KEY (TYPE_CD)
    REFERENCES PROTOCOL_ATTACHMENT_TYPE (TYPE_CD);



ALTER TABLE PROTOCOL_CORRESPONDENCE
    ADD CONSTRAINT FK_PROTOCOL_CORRESPONDENCE1 FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_CORRESPONDENCE
    ADD CONSTRAINT FK_PROTOCOL_CORRESPONDENCE2 FOREIGN KEY (ACTION_ID_FK)
    REFERENCES PROTOCOL_ACTIONS (PROTOCOL_ACTION_ID);

ALTER TABLE PROTOCOL_CORRESPONDENCE
    ADD CONSTRAINT FK_PROTOCOL_CORRESPONDENCE3 FOREIGN KEY (PROTO_CORRESP_TYPE_CODE)
    REFERENCES PROTO_CORRESP_TYPE (PROTO_CORRESP_TYPE_CODE);



ALTER TABLE PROTOCOL_EXEMPT_CHKLST
    ADD CONSTRAINT FK_PROTOCOL_EXEMPT_CHKLST2 FOREIGN KEY (SUBMISSION_ID_FK)
    REFERENCES PROTOCOL_SUBMISSION (SUBMISSION_ID);

ALTER TABLE PROTOCOL_EXEMPT_CHKLST
    ADD CONSTRAINT FK_PROTOCOL_EXEMPT_CHKLST3 FOREIGN KEY (EXEMPT_STUDIES_CHECKLIST_CODE)
    REFERENCES EXEMPT_STUDIES_CHECKLIST (EXEMPT_STUDIES_CHECKLIST_CODE);

ALTER TABLE PROTOCOL_EXEMPT_CHKLST
    ADD CONSTRAINT FK_PROTOCOL_EXEMPT_CHKLST1 FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);


ALTER TABLE PROTOCOL_EXEMPT_NUMBER
    ADD CONSTRAINT FK_PROTOCOL_SPECIAL_REVIEW_ID FOREIGN KEY (PROTOCOL_SPECIAL_REVIEW_ID)
    REFERENCES PROTOCOL_SPECIAL_REVIEW (PROTOCOL_SPECIAL_REVIEW_ID);

ALTER TABLE PROTOCOL_EXEMPT_NUMBER
    ADD CONSTRAINT FK_PROT_EXEMPTION_TYPE_CODE FOREIGN KEY (EXEMPTION_TYPE_CODE)
    REFERENCES EXEMPTION_TYPE (EXEMPTION_TYPE_CODE);


ALTER TABLE PROTOCOL_EXPIDITED_CHKLST
    ADD CONSTRAINT FK_PROTOCOL_EXPIDITED_CHKLST1 FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_EXPIDITED_CHKLST
    ADD CONSTRAINT FK_PROTOCOL_EXPIDITED_CHKLST2 FOREIGN KEY (SUBMISSION_ID_FK)
    REFERENCES PROTOCOL_SUBMISSION (SUBMISSION_ID);

ALTER TABLE PROTOCOL_EXPIDITED_CHKLST
    ADD CONSTRAINT FK_PROTOCOL_EXPIDITED_CHKLST3 FOREIGN KEY (EXPEDITED_REV_CHKLST_CODE)
    REFERENCES EXPEDITED_REVIEW_CHECKLIST (EXPEDITED_REV_CHKLST_CODE);


ALTER TABLE PROTOCOL_FUNDING_SOURCE
    ADD CONSTRAINT FK_PROTOCOL_FUNDING_SOURCE2 FOREIGN KEY (FUNDING_SOURCE_TYPE_CODE)
    REFERENCES FUNDING_SOURCE_TYPE (FUNDING_SOURCE_TYPE_CODE);

ALTER TABLE PROTOCOL_FUNDING_SOURCE
    ADD CONSTRAINT FK_PROTOCOL_FUNDING_SOURCE FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);


ALTER TABLE PROTOCOL_LOCATION
    ADD CONSTRAINT FK_PROTOCOL_LOCATION FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_LOCATION
    ADD CONSTRAINT FK_PROTOCOL_LOCATION_3 FOREIGN KEY (PROTOCOL_ORG_TYPE_CODE)
    REFERENCES PROTOCOL_ORG_TYPE (PROTOCOL_ORG_TYPE_CODE);

ALTER TABLE PROTOCOL_LOCATION
    ADD CONSTRAINT FK_PROTOCOL_LOCATION_2 FOREIGN KEY (ORGANIZATION_ID)
    REFERENCES ORGANIZATION (ORGANIZATION_ID);



ALTER TABLE PROTOCOL_NOTEPAD
    ADD CONSTRAINT FK_P_NOTEPAD_PROTOCOL FOREIGN KEY (PROTOCOL_ID_FK)
    REFERENCES PROTOCOL (PROTOCOL_ID);


ALTER TABLE PROTOCOL_ONLN_RVWS
    ADD CONSTRAINT FK2_PROTOCOL_ONLN_RVWS FOREIGN KEY (PROTOCOL_REVIEWER_FK)
    REFERENCES PROTOCOL_REVIEWERS (PROTOCOL_REVIEWER_ID);

ALTER TABLE PROTOCOL_ONLN_RVWS
    ADD CONSTRAINT FK6_PROTOCOL_ONLN_RVW_DOCUMENT FOREIGN KEY (DOCUMENT_NUMBER)
    REFERENCES PROTOCOL_ONLN_RVW_DOCUMENT (DOCUMENT_NUMBER);

ALTER TABLE PROTOCOL_ONLN_RVWS
    ADD CONSTRAINT FK5_PROTOCOL_ONLN_RVWS FOREIGN KEY (REVIEW_DETERM_RECOM_CD)
    REFERENCES PROTOCOL_ONLN_RVW_DETERM_RECOM (REVIEW_DETERM_RECOM_CD);

ALTER TABLE PROTOCOL_ONLN_RVWS
    ADD CONSTRAINT FK1_PROTOCOL_ONLN_RVWS FOREIGN KEY (PROTOCOL_ONLN_RVW_STATUS_CODE)
    REFERENCES PROTOCOL_ONLN_RVW_STATUS (STATUS_CODE);

ALTER TABLE PROTOCOL_ONLN_RVWS
    ADD CONSTRAINT FK3_PROTOCOL_ONLN_RVWS FOREIGN KEY (SUBMISSION_ID_FK)
    REFERENCES PROTOCOL_SUBMISSION (SUBMISSION_ID);

ALTER TABLE PROTOCOL_ONLN_RVWS
    ADD CONSTRAINT FK4_PROTOCOL_ONLN_RVWS FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);






ALTER TABLE PROTOCOL_PERSONS
    ADD CONSTRAINT FK_PROTOCOL_PERSONS_ROLE FOREIGN KEY (PROTOCOL_PERSON_ROLE_ID)
    REFERENCES PROTOCOL_PERSON_ROLES (PROTOCOL_PERSON_ROLE_ID);

ALTER TABLE PROTOCOL_PERSONS
    ADD CONSTRAINT FK_PROTOCOL_PERSONS_PROTOCOL FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_PERSONS
    ADD CONSTRAINT FK_PROTOCOL_PERS_AFFILIATION FOREIGN KEY (AFFILIATION_TYPE_CODE)
    REFERENCES AFFILIATION_TYPE (AFFILIATION_TYPE_CODE);



ALTER TABLE PROTOCOL_PERSON_ROLE_MAPPING
    ADD CONSTRAINT FK_PERSON_TARGET_ROLE FOREIGN KEY (TARGET_ROLE_ID)
    REFERENCES PROTOCOL_PERSON_ROLES (PROTOCOL_PERSON_ROLE_ID);

ALTER TABLE PROTOCOL_PERSON_ROLE_MAPPING
    ADD CONSTRAINT FK_PERSON_SOURCE_ROLE FOREIGN KEY (SOURCE_ROLE_ID)
    REFERENCES PROTOCOL_PERSON_ROLES (PROTOCOL_PERSON_ROLE_ID);


ALTER TABLE PROTOCOL_REFERENCES
    ADD CONSTRAINT FK_PROTOCOL_REF_TYPE_CODE FOREIGN KEY (PROTOCOL_REFERENCE_TYPE_CODE)
    REFERENCES PROTOCOL_REFERENCE_TYPE (PROTOCOL_REFERENCE_TYPE_CODE);

ALTER TABLE PROTOCOL_REFERENCES
    ADD CONSTRAINT FK_PROTOCOL_ID FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);



ALTER TABLE PROTOCOL_RESEARCH_AREAS
    ADD CONSTRAINT FK_PROTOCOL_RESEARCH_AREAS FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_RESEARCH_AREAS
    ADD CONSTRAINT FK_PROTOCOL_RESEARCH_AREAS2 FOREIGN KEY (RESEARCH_AREA_CODE)
    REFERENCES RESEARCH_AREAS (RESEARCH_AREA_CODE);


ALTER TABLE PROTOCOL_REVIEWERS
    ADD CONSTRAINT FK_PROTOCOL_REVIEWERS2 FOREIGN KEY (SUBMISSION_ID_FK)
    REFERENCES PROTOCOL_SUBMISSION (SUBMISSION_ID);

ALTER TABLE PROTOCOL_REVIEWERS
    ADD CONSTRAINT FK_PROTOCOL_REVIEWERS1 FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_REVIEWERS
    ADD CONSTRAINT FK_PROTOCOL_REVIEWERS4 FOREIGN KEY (REVIEWER_TYPE_CODE)
    REFERENCES PROTOCOL_REVIEWER_TYPE (REVIEWER_TYPE_CODE);

ALTER TABLE PROTOCOL_REVIEWERS
    ADD CONSTRAINT FK_PROTOCOL_REVIEWERS5 FOREIGN KEY (ROLODEX_ID)
    REFERENCES ROLODEX (ROLODEX_ID);




ALTER TABLE PROTOCOL_RISK_LEVELS
    ADD CONSTRAINT FK_PROTOCOL_RISK_LEVELS FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_RISK_LEVELS
    ADD CONSTRAINT FK_PROTOCOL_RISK_LEVELS2 FOREIGN KEY (RISK_LEVEL_CODE)
    REFERENCES RISK_LEVEL (RISK_LEVEL_CODE);


ALTER TABLE PROTOCOL_SPECIAL_REVIEW
    ADD CONSTRAINT FK_PROTOCOL_SPECIAL_REVIEW FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);



ALTER TABLE PROTOCOL_SUBMISSION
    ADD CONSTRAINT FK_PROTOCOL_SUBMISSION5 FOREIGN KEY (SUBMISSION_STATUS_CODE)
    REFERENCES SUBMISSION_STATUS (SUBMISSION_STATUS_CODE);

ALTER TABLE PROTOCOL_SUBMISSION
    ADD CONSTRAINT FK_PROTOCOL_SUBMISSION6 FOREIGN KEY (SUBMISSION_TYPE_CODE)
    REFERENCES SUBMISSION_TYPE (SUBMISSION_TYPE_CODE);

ALTER TABLE PROTOCOL_SUBMISSION
    ADD CONSTRAINT FK_PROTOCOL_SUBMISSION7 FOREIGN KEY (SUBMISSION_TYPE_QUAL_CODE)
    REFERENCES SUBMISSION_TYPE_QUALIFIER (SUBMISSION_TYPE_QUAL_CODE);

ALTER TABLE PROTOCOL_SUBMISSION
    ADD CONSTRAINT FK_PROTOCOL_SUBMISSION1 FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_SUBMISSION
    ADD CONSTRAINT FK_PROTOCOL_SUBMISSION2 FOREIGN KEY (SCHEDULE_ID_FK)
    REFERENCES COMM_SCHEDULE (ID);

ALTER TABLE PROTOCOL_SUBMISSION
    ADD CONSTRAINT FK_PROTOCOL_SUBMISSION3 FOREIGN KEY (COMMITTEE_ID_FK)
    REFERENCES COMMITTEE (ID);

ALTER TABLE PROTOCOL_SUBMISSION
    ADD CONSTRAINT FK_PROTOCOL_SUBMISSION4 FOREIGN KEY (PROTOCOL_REVIEW_TYPE_CODE)
    REFERENCES PROTOCOL_REVIEW_TYPE (PROTOCOL_REVIEW_TYPE_CODE);


ALTER TABLE PROTOCOL_SUBMISSION_DOC
    ADD CONSTRAINT FK_PROTOCOL_SUBMISSION_DOC2 FOREIGN KEY (SUBMISSION_ID_FK)
    REFERENCES PROTOCOL_SUBMISSION (SUBMISSION_ID);

ALTER TABLE PROTOCOL_SUBMISSION_DOC
    ADD CONSTRAINT FK_PROTOCOL_SUBMISSION_DOC1 FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);



ALTER TABLE PROTOCOL_UNITS
    ADD CONSTRAINT FK_PROTOCOL_UNITS_2 FOREIGN KEY (UNIT_NUMBER)
    REFERENCES UNIT (UNIT_NUMBER);


ALTER TABLE PROTOCOL_VOTE_ABSTAINEES
    ADD CONSTRAINT FK_PROTOCOL_VOTE_ABSTAINEE FOREIGN KEY (PROTOCOL_ID_FK)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_VOTE_ABSTAINEES
    ADD CONSTRAINT FK_PROTOCOL_VOTE_ABST_FK3 FOREIGN KEY (ROLODEX_ID)
    REFERENCES ROLODEX (ROLODEX_ID);

ALTER TABLE PROTOCOL_VOTE_ABSTAINEES
    ADD CONSTRAINT PROTOCOL_VOTE_ABSTAINEES_FK1 FOREIGN KEY (SUBMISSION_ID_FK)
    REFERENCES PROTOCOL_SUBMISSION (SUBMISSION_ID);


ALTER TABLE PROTOCOL_VOTE_RECUSED
    ADD CONSTRAINT FK_PROTOCOL_VOTE_RECUSED_FK3 FOREIGN KEY (ROLODEX_ID)
    REFERENCES ROLODEX (ROLODEX_ID);

ALTER TABLE PROTOCOL_VOTE_RECUSED
    ADD CONSTRAINT PROTOCOL_VOTE_RECUSED_PRO_FK1 FOREIGN KEY (PROTOCOL_ID_FK)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_VOTE_RECUSED
    ADD CONSTRAINT PROTOCOL_VOTE_RECUSED_PRO_FK2 FOREIGN KEY (SUBMISSION_ID_FK)
    REFERENCES PROTOCOL_SUBMISSION (SUBMISSION_ID);


ALTER TABLE PROTOCOL_VULNERABLE_SUB
    ADD CONSTRAINT FK_PROTOCOL_VULNERABLE_SUB FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);

ALTER TABLE PROTOCOL_VULNERABLE_SUB
    ADD CONSTRAINT FK_PROTOCOL_VULNERABLE_SUB2 FOREIGN KEY (VULNERABLE_SUBJECT_TYPE_CODE)
    REFERENCES VULNERABLE_SUBJECT_TYPE (VULNERABLE_SUBJECT_TYPE_CODE);


ALTER TABLE PROTO_AMEND_RENEWAL
    ADD CONSTRAINT FK_PROTO_AMEND_RENEWAL1 FOREIGN KEY (PROTOCOL_ID)
    REFERENCES PROTOCOL (PROTOCOL_ID);


ALTER TABLE PROTO_AMEND_RENEW_MODULES
    ADD CONSTRAINT FK_PROTO_AMEND_RENEW_MODULES1 FOREIGN KEY (PROTO_AMEND_RENEWAL_ID)
    REFERENCES PROTO_AMEND_RENEWAL (PROTO_AMEND_RENEWAL_ID);

ALTER TABLE PROTO_AMEND_RENEW_MODULES
    ADD CONSTRAINT FK_PROTO_AMEND_RENEW_MODULES2 FOREIGN KEY (PROTOCOL_MODULE_CODE)
    REFERENCES PROTOCOL_MODULES (PROTOCOL_MODULE_CODE);


ALTER TABLE PROTO_CORRESP_TEMPL
    ADD CONSTRAINT FK_PROTO_CORRESP_TEMPL FOREIGN KEY (PROTO_CORRESP_TYPE_CODE)
    REFERENCES PROTO_CORRESP_TYPE (PROTO_CORRESP_TYPE_CODE);



ALTER TABLE PROTO_NOTIFICATION_TEMPL
    ADD CONSTRAINT FK_PROTO_NOTIFICATION_TEMPL FOREIGN KEY (ACTION_TYPE_CODE)
    REFERENCES PROTOCOL_ACTION_TYPE (PROTOCOL_ACTION_TYPE_CODE);




ALTER TABLE QUESTIONNAIRE_ANSWER
    ADD CONSTRAINT FK_QUESTIONNAIRE_ANS_COMP_ID FOREIGN KEY (QUESTIONNAIRE_AH_ID_FK)
    REFERENCES QUESTIONNAIRE_ANSWER_HEADER (QUESTIONNAIRE_ANSWER_HEADER_ID);

ALTER TABLE QUESTIONNAIRE_ANSWER
    ADD CONSTRAINT FK_QUESTIONNAIRE_ANS_QID FOREIGN KEY (QUESTION_REF_ID_FK)
    REFERENCES QUESTION (QUESTION_REF_ID);


ALTER TABLE QUESTIONNAIRE_ANSWER_HEADER
    ADD CONSTRAINT FK_QUESTIONNAIRE_QID FOREIGN KEY (QUESTIONNAIRE_REF_ID_FK)
    REFERENCES QUESTIONNAIRE (QUESTIONNAIRE_REF_ID);


ALTER TABLE QUESTIONNAIRE_QUESTIONS
    ADD CONSTRAINT FK_QUESTIONNAIRE_QUESTIONNAIRE FOREIGN KEY (QUESTIONNAIRE_REF_ID_FK)
    REFERENCES QUESTIONNAIRE (QUESTIONNAIRE_REF_ID);

ALTER TABLE QUESTIONNAIRE_QUESTIONS
    ADD CONSTRAINT FK_QUESTIONNAIRE_QUESTIONS FOREIGN KEY (QUESTION_REF_ID_FK)
    REFERENCES QUESTION (QUESTION_REF_ID);


ALTER TABLE QUESTIONNAIRE_USAGE
    ADD CONSTRAINT FK_QUESTIONNAIRE_USAGE FOREIGN KEY (QUESTIONNAIRE_REF_ID_FK)
    REFERENCES QUESTIONNAIRE (QUESTIONNAIRE_REF_ID);

ALTER TABLE QUESTIONNAIRE_USAGE
    ADD CONSTRAINT FK_QNR_USAGE_MODULE_ITEM FOREIGN KEY (MODULE_ITEM_CODE)
    REFERENCES COEUS_MODULE (MODULE_CODE);


ALTER TABLE QUESTION_EXPLANATION
    ADD CONSTRAINT FK_QUESTION_EXPLANATION FOREIGN KEY (QUESTION_REF_ID_FK)
    REFERENCES QUESTION (QUESTION_REF_ID);



ALTER TABLE RATE_CLASS
    ADD CONSTRAINT FK_RATE_CLASS_TYPE FOREIGN KEY (RATE_CLASS_TYPE)
    REFERENCES RATE_CLASS_TYPE (RATE_CLASS_TYPE);










ALTER TABLE ROLE_RIGHTS
    ADD CONSTRAINT FK_ROLE_RIGHTS_ROLE FOREIGN KEY (ROLE_ID)
    REFERENCES ROLE (ROLE_ID);

ALTER TABLE ROLE_RIGHTS
    ADD CONSTRAINT FK_ROLE_RIGHTS_RIGHT FOREIGN KEY (RIGHT_ID)
    REFERENCES RIGHTS (RIGHT_ID);



ALTER TABLE S2S_APPLICATION
    ADD CONSTRAINT FK_S2S_APPLICATION_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE S2S_APP_ATTACHMENTS
    ADD CONSTRAINT FK_S2S_APP_ATTACHMENTS_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE S2S_APP_SUBMISSION
    ADD CONSTRAINT FK_S2S_APP_SUBMISSION_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);


ALTER TABLE S2S_OPPORTUNITY
    ADD CONSTRAINT FK_S2S_OPPORTUNITY_KRA FOREIGN KEY (S2S_SUBMISSION_TYPE_CODE)
    REFERENCES S2S_SUBMISSION_TYPE (S2S_SUBMISSION_TYPE_CODE);

ALTER TABLE S2S_OPPORTUNITY
    ADD CONSTRAINT FK_S2S_OPPORTUNITY_KRA2 FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE S2S_OPPORTUNITY
    ADD CONSTRAINT FK_S2S_OPPORTUNITY_KRA1 FOREIGN KEY (REVISION_CODE)
    REFERENCES S2S_REVISION_TYPE (S2S_REVISION_TYPE_CODE);


ALTER TABLE S2S_OPP_FORMS
    ADD CONSTRAINT FK_S2S_OPP_FORMS_KRA FOREIGN KEY (PROPOSAL_NUMBER)
    REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);





ALTER TABLE SCHEDULE_AGENDA
    ADD CONSTRAINT FK_COMM_SCHEDULE_AGENDA FOREIGN KEY (SCHEDULE_ID_FK)
    REFERENCES COMM_SCHEDULE (ID);






ALTER TABLE SPONSOR
    ADD CONSTRAINT FK_SPONSOR_ROLODEX_KRA FOREIGN KEY (ROLODEX_ID)
    REFERENCES ROLODEX (ROLODEX_ID);

ALTER TABLE SPONSOR
    ADD CONSTRAINT FK_SPONSOR_TYPE_CODE_KRA FOREIGN KEY (SPONSOR_TYPE_CODE)
    REFERENCES SPONSOR_TYPE (SPONSOR_TYPE_CODE);


ALTER TABLE SPONSOR_FORMS
    ADD CONSTRAINT FK_SPONSOR_FORMS FOREIGN KEY (SPONSOR_CODE)
    REFERENCES SPONSOR (SPONSOR_CODE);


ALTER TABLE SPONSOR_FORM_TEMPLATES
    ADD CONSTRAINT FK_SPONSOR_FORM_TEMPLATES FOREIGN KEY (SPONSOR_CODE, PACKAGE_NUMBER)
    REFERENCES SPONSOR_FORMS (SPONSOR_CODE, PACKAGE_NUMBER);


ALTER TABLE SPONSOR_HIERARCHY
    ADD CONSTRAINT FK_SPONSOR_HIERARCHY_KRA FOREIGN KEY (SPONSOR_CODE)
    REFERENCES SPONSOR (SPONSOR_CODE)
ON DELETE CASCADE;



ALTER TABLE SPONSOR_TERM
    ADD CONSTRAINT FK1_SPONSOR_TERM FOREIGN KEY (SPONSOR_TERM_TYPE_CODE)
    REFERENCES SPONSOR_TERM_TYPE (SPONSOR_TERM_TYPE_CODE);












ALTER TABLE TRANSACTION_DETAILS
    ADD CONSTRAINT FK_TRANSACTION_DETAILS3 FOREIGN KEY (TNM_DOCUMENT_NUMBER)
    REFERENCES TIME_AND_MONEY_DOCUMENT (DOCUMENT_NUMBER);




ALTER TABLE UNIT_ADMINISTRATOR
    ADD CONSTRAINT FK1_UNIT_ADMINISTRATOR_KRA FOREIGN KEY (UNIT_NUMBER)
    REFERENCES UNIT (UNIT_NUMBER);

ALTER TABLE UNIT_ADMINISTRATOR
    ADD CONSTRAINT FK2_UNIT_ADMINISTRATOR_KRA FOREIGN KEY (UNIT_ADMINISTRATOR_TYPE_CODE)
    REFERENCES UNIT_ADMINISTRATOR_TYPE (UNIT_ADMINISTRATOR_TYPE_CODE);



ALTER TABLE USER_ROLES
    ADD CONSTRAINT FK_USER_ROLES_ROLE FOREIGN KEY (ROLE_ID)
    REFERENCES ROLE (ROLE_ID);

ALTER TABLE USER_ROLES
    ADD CONSTRAINT FK_USER_ROLES_UNIT FOREIGN KEY (UNIT_NUMBER)
    REFERENCES UNIT (UNIT_NUMBER);



ALTER TABLE VALID_AWARD_BASIS_PAYMENT
    ADD CONSTRAINT FK_VALID_AWARD_BASIS_PAYMENT FOREIGN KEY (BASIS_OF_PAYMENT_CODE)
    REFERENCES AWARD_BASIS_OF_PAYMENT (BASIS_OF_PAYMENT_CODE);

ALTER TABLE VALID_AWARD_BASIS_PAYMENT
    ADD CONSTRAINT FK2_VALID_AWARD_BASIS_PAYMENT FOREIGN KEY (AWARD_TYPE_CODE)
    REFERENCES AWARD_TYPE (AWARD_TYPE_CODE);


ALTER TABLE VALID_BASIS_METHOD_PMT
    ADD CONSTRAINT FK2_VALID_BASIS_METHOD_PMT FOREIGN KEY (METHOD_OF_PAYMENT_CODE)
    REFERENCES AWARD_METHOD_OF_PAYMENT (METHOD_OF_PAYMENT_CODE);

ALTER TABLE VALID_BASIS_METHOD_PMT
    ADD CONSTRAINT FK_VALID_BASIS_METHOD_PMT FOREIGN KEY (BASIS_OF_PAYMENT_CODE)
    REFERENCES AWARD_BASIS_OF_PAYMENT (BASIS_OF_PAYMENT_CODE);



ALTER TABLE VALID_CE_JOB_CODES
    ADD CONSTRAINT VALID_CE_JOB_CODES_COST_E_FK1 FOREIGN KEY (COST_ELEMENT)
    REFERENCES COST_ELEMENT (COST_ELEMENT);

ALTER TABLE VALID_CE_JOB_CODES
    ADD CONSTRAINT VALID_CE_JOB_CODES_JOB_CO_FK1 FOREIGN KEY (JOB_CODE)
    REFERENCES JOB_CODE (JOB_CODE);


ALTER TABLE VALID_CE_RATE_TYPES
    ADD CONSTRAINT FK_VALID_CE_RATE_TYPES_KRA FOREIGN KEY (RATE_CLASS_CODE, RATE_TYPE_CODE)
    REFERENCES RATE_TYPE (RATE_CLASS_CODE, RATE_TYPE_CODE);

ALTER TABLE VALID_CE_RATE_TYPES
    ADD CONSTRAINT FK_VALID_CE_RATE_TYPES_CE_KRA FOREIGN KEY (COST_ELEMENT)
    REFERENCES COST_ELEMENT (COST_ELEMENT);


ALTER TABLE VALID_CLASS_REPORT_FREQ
    ADD CONSTRAINT FK_VALID_CLASS_REPORT_FREQ FOREIGN KEY (FREQUENCY_CODE)
    REFERENCES FREQUENCY (FREQUENCY_CODE);

ALTER TABLE VALID_CLASS_REPORT_FREQ
    ADD CONSTRAINT FK3_VALID_CLASS_REPORT_FREQ FOREIGN KEY (REPORT_CLASS_CODE)
    REFERENCES REPORT_CLASS (REPORT_CLASS_CODE);

ALTER TABLE VALID_CLASS_REPORT_FREQ
    ADD CONSTRAINT FK2_VALID_CLASS_REPORT_FREQ FOREIGN KEY (REPORT_CODE)
    REFERENCES REPORT (REPORT_CODE);


ALTER TABLE VALID_FREQUENCY_BASE
    ADD CONSTRAINT FK_VALID_FREQUENCY_BASE FOREIGN KEY (FREQUENCY_BASE_CODE)
    REFERENCES FREQUENCY_BASE (FREQUENCY_BASE_CODE);

ALTER TABLE VALID_FREQUENCY_BASE
    ADD CONSTRAINT FK2_VALID_FREQUENCY_BASE FOREIGN KEY (FREQUENCY_CODE)
    REFERENCES FREQUENCY (FREQUENCY_CODE);


ALTER TABLE VALID_NARR_FORMS
    ADD CONSTRAINT FK_VALID_NARR_FORMS FOREIGN KEY (NARRATIVE_TYPE_CODE)
    REFERENCES NARRATIVE_TYPE (NARRATIVE_TYPE_CODE);


ALTER TABLE VALID_PROTO_ACTION_CORESP
    ADD CONSTRAINT FK_VALID_PROTO_ACTION_CORESP FOREIGN KEY (PROTOCOL_ACTION_TYPE_CODE)
    REFERENCES PROTOCOL_ACTION_TYPE (PROTOCOL_ACTION_TYPE_CODE);

ALTER TABLE VALID_PROTO_ACTION_CORESP
    ADD CONSTRAINT FK_VALID_PROTO_ACTION_CORES_2 FOREIGN KEY (PROTO_CORRESP_TYPE_CODE)
    REFERENCES PROTO_CORRESP_TYPE (PROTO_CORRESP_TYPE_CODE);


ALTER TABLE VALID_PROTO_SUB_REV_TYPE
    ADD CONSTRAINT FK_VALID_PROTO_SUB_REV_TYPE FOREIGN KEY (SUBMISSION_TYPE_CODE)
    REFERENCES SUBMISSION_TYPE (SUBMISSION_TYPE_CODE);

ALTER TABLE VALID_PROTO_SUB_REV_TYPE
    ADD CONSTRAINT FK2_VALID_PROTO_SUB_REV_TYPE FOREIGN KEY (PROTOCOL_REVIEW_TYPE_CODE)
    REFERENCES PROTOCOL_REVIEW_TYPE (PROTOCOL_REVIEW_TYPE_CODE);


ALTER TABLE VALID_PROTO_SUB_TYPE_QUAL
    ADD CONSTRAINT FK_VALID_PROTO_SUB_TYPE_QUAL FOREIGN KEY (SUBMISSION_TYPE_CODE)
    REFERENCES SUBMISSION_TYPE (SUBMISSION_TYPE_CODE);

ALTER TABLE VALID_PROTO_SUB_TYPE_QUAL
    ADD CONSTRAINT FK2_VALID_PROTO_SUB_TYPE_QUAL FOREIGN KEY (SUBMISSION_TYPE_QUAL_CODE)
    REFERENCES SUBMISSION_TYPE_QUALIFIER (SUBMISSION_TYPE_QUAL_CODE);



ALTER TABLE VALID_SP_REV_APPROVAL
    ADD CONSTRAINT FK_VALID_SP_REV_APPROVAL_KRA FOREIGN KEY (SPECIAL_REVIEW_CODE)
    REFERENCES SPECIAL_REVIEW (SPECIAL_REVIEW_CODE);

ALTER TABLE VALID_SP_REV_APPROVAL
    ADD CONSTRAINT FK_VALID_SP_REV_APPROV_TP_KRA FOREIGN KEY (APPROVAL_TYPE_CODE)
    REFERENCES SP_REV_APPROVAL_TYPE (APPROVAL_TYPE_CODE);





ALTER TABLE YNQ_EXPLANATION
    ADD CONSTRAINT FK_YNQ_EXPLANATION_KRA FOREIGN KEY (QUESTION_ID)
    REFERENCES YNQ (QUESTION_ID);

ALTER TABLE YNQ_EXPLANATION
    ADD CONSTRAINT FK_YNQ_EXPLANATION_TYPE_KRA FOREIGN KEY (EXPLANATION_TYPE)
    REFERENCES YNQ_EXPLANATION_TYPE (EXPLANATION_TYPE);



