---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


CREATE TABLE PERSON_BIOSKETCH (
    PERSON_BIOSKETCH_ID   NUMBER(8) NOT NULL,
    PERSON_ID             NUMBER(22) NOT NULL,
    DESCRIPTION           VARCHAR2(4000),
    FILE_NAME             VARCHAR2(300),
    CONTENT_TYPE          VARCHAR2(255),
    ATTACHMENT_FILE       BLOB,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    UPDATE_TIMESTAMP      DATE NOT NULL,
    OBJ_ID                VARCHAR2(36) NOT NULL,
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE PERSON_BIOSKETCH ADD CONSTRAINT PK_PERSON_BIOSKETCH
  PRIMARY KEY (PERSON_BIOSKETCH_ID);

DECLARE personId VARCHAR2(40);
        attachmentDescription VARCHAR2(4000);
        attachmentFileName VARCHAR2(300);
        attachmentContentType VARCHAR2(255);
        attachmentFile BLOB;
        updateUser VARCHAR2(60);
        updateTimestamp DATE;
        descriptionCount NUMBER;
        attachmentFileCount NUMBER;
        CURSOR cur IS SELECT * FROM PERSON_EXT_T;
BEGIN
    FOR rec IN cur 
    LOOP
        EXECUTE IMMEDIATE 'SELECT PERSON_ID FROM PERSON_EXT_T WHERE PERSON_ID = ' || rec.PERSON_ID INTO personId;
        EXECUTE IMMEDIATE 'SELECT BIOSKETCH_DESCRIPTION FROM PERSON_EXT_T WHERE PERSON_ID = ' || rec.PERSON_ID INTO attachmentDescription;
        EXECUTE IMMEDIATE 'SELECT BIOSKETCH_FILENAME FROM PERSON_EXT_T WHERE PERSON_ID = ' || rec.PERSON_ID INTO attachmentFileName;
        EXECUTE IMMEDIATE 'SELECT BIOSKETCH_FILE_CONTENT_TYPE FROM PERSON_EXT_T WHERE PERSON_ID = ' || rec.PERSON_ID INTO attachmentContentType;
        EXECUTE IMMEDIATE 'SELECT BIOSKETCH_FILE FROM PERSON_EXT_T WHERE PERSON_ID = ' || rec.PERSON_ID INTO attachmentFile;
        EXECUTE IMMEDIATE 'SELECT UPDATE_USER FROM PERSON_EXT_T WHERE PERSON_ID = ' || rec.PERSON_ID INTO updateUser;
        EXECUTE IMMEDIATE 'SELECT UPDATE_TIMESTAMP FROM PERSON_EXT_T WHERE PERSON_ID = ' || rec.PERSON_ID INTO updateTimestamp;
        
        EXECUTE IMMEDIATE 'SELECT COUNT(*) FROM PERSON_EXT_T WHERE BIOSKETCH_DESCRIPTION IS NOT NULL AND PERSON_ID = ' || rec.PERSON_ID INTO descriptionCount;
        EXECUTE IMMEDIATE 'SELECT COUNT(*) FROM PERSON_EXT_T WHERE BIOSKETCH_FILENAME IS NOT NULL AND PERSON_ID = ' || rec.PERSON_ID INTO attachmentFileCount;
        
        IF descriptionCount > 0 OR attachmentFileCount > 0  THEN
            INSERT INTO PERSON_BIOSKETCH (PERSON_BIOSKETCH_ID,PERSON_ID,DESCRIPTION,FILE_NAME,CONTENT_TYPE,ATTACHMENT_FILE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) VALUES (SEQ_PERSON_BIOSKETCH_ID.NEXTVAL,personId,attachmentDescription,attachmentFileName,attachmentContentType,attachmentFile,updateUser,updateTimestamp,SYS_GUID(),1);
        END IF;
    END LOOP;
end;
/

ALTER TABLE PERSON_EXT_T DROP (BIOSKETCH_DESCRIPTION, BIOSKETCH_FILENAME, BIOSKETCH_FILE_CONTENT_TYPE, BIOSKETCH_FILE);
