---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


-- create the coi maintainer role with a default kim type
INSERT INTO KRIM_ROLE_T (ROLE_ID, OBJ_ID, VER_NBR, ROLE_NM, NMSPC_CD, DESC_TXT, KIM_TYP_ID, ACTV_IND, LAST_UPDT_DT) 
	VALUES (KRIM_ROLE_ID_S.NEXTVAL, SYS_GUID(), 1, 'COI Maintainer', 'KC-COIDISCLOSURE', 'Grants the ability to maintain all sorts of COI-related artifacts', 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NM = 'Default'), 'Y', SYSDATE);



-- add the 'initiate document' template-based permission for COI attachment type maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add COI Attachment Type', 'Permission to create new COI attachment types', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'CoiAttachmentTypeMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');



-- add the 'initiate document' template-based permission for COI disclosure status maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add COI Disclosure Status', 'Permission to create new COI disclosure statuses', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'CoiDisclosureStatusMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');



-- add the 'initiate document' template-based permission for COI disposition status maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add COI Disposition Status', 'Permission to create new COI disposition statuses', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'CoiDispositionStatusMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');



-- add the 'initiate document' template-based permission for COI committee role type maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add COI Committee Role Type', 'Permission to create new COI committee role types', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'CoiCommitteeRoleTypeMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');



-- add the 'initiate document' template-based permission for COI disclosure event type maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add COI Disclosure Event Type', 'Permission to create new COI disclosure event types', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'CoiDisclosureEventTypeMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');



-- add the 'initiate document' template-based permission for COI review type maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add COI Review Type', 'Permission to create new COI review types', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'CoiReviewTypeMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');



-- add the 'initiate document' template-based permission for COI reviewer maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add COI Reviewer', 'Permission to create new COI reviewers', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'CoiReviewerMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');


-- add the 'initiate document' template-based permission for COI status maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add COI Status', 'Permission to create new COI statuses', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'CoiStatusMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');


-- add the 'initiate document' template-based permission for financial interest entity relationship type maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add Financial Interest Entity Relationship Type', 'Permission to create new financial interest entity relationship types', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'FinIntEntityRelTypeMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');


-- add the 'initiate document' template-based permission for financial interest entity status maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add Financial Interest Entity Status', 'Permission to create new financial interest entity statuses', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'FinIntEntityStatusMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');


-- add the 'initiate document' template-based permission for financial entity data group maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add Financial Entity Data Group', 'Permission to create new financial entity data groups', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'FinEntitiesDataGroupMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');


-- add the 'initiate document' template-based permission for financial entity data matrix maintenance documents
-- and confer this permission on the coi maintainer role

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID) 
	VALUES (KRIM_PERM_ID_S.NEXTVAL, (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD ='KR-SYS' AND NM ='Initiate Document'), 
			'KC-COIDISCLOSURE', 'Add Financial Entity Data Matrix', 'Permission to create new financial entity data matrices', 'Y', SYS_GUID());

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID) 
	VALUES (KRIM_ATTR_DATA_ID_S.NEXTVAL, KRIM_PERM_ID_S.CURRVAL, 
			(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),
			(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
			'FinEntitiesDataMatrixMaintenanceDocument', SYS_GUID());

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
	VALUES (KRIM_ROLE_PERM_ID_S.NEXTVAL, SYS_GUID(), 1, KRIM_ROLE_ID_S.CURRVAL, KRIM_PERM_ID_S.CURRVAL, 'Y');

