/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.org;

import com.codiform.moo.curry.Translate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.impl.org.OrganizationResults;
import org.kuali.coeus.sys.framework.controller.rest.SimpleCrudMapBasedRestController;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.SearchResults;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public class OrganizationController
extends SimpleCrudMapBasedRestController<Organization> {
    @RequestMapping(params={"summary"}, method={RequestMethod.GET})
    @ResponseBody
    public OrganizationResults getOrganizationSummary() {
        this.assertMethodSupported(RequestMethod.GET);
        this.assertUserHasReadAccess();
        SearchResults<Organization> organizationSearchResults = new SearchResults<Organization>();
        organizationSearchResults.setResults(this.getAllFromDataStore());
        if (CollectionUtils.isEmpty(organizationSearchResults.getResults())) {
            throw new ResourceNotFoundException("not found");
        }
        organizationSearchResults.setTotalResults(organizationSearchResults.getResults().size());
        return (OrganizationResults)Translate.to(OrganizationResults.class).from(organizationSearchResults);
    }

    Collection<Organization> getAllFromDataStore() {
        return this.getLegacyDataAdapter().findAll(this.getDataObjectClazz());
    }

    private boolean autoIncrement() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "AUTO_GENERATE_ORGANIZATION_ID");
    }

    @Override
    protected void doAddSequenceHandling(Map<String, Object> dto) {
        boolean autoIncrement = this.autoIncrement();
        Set<String> sequencedPks = this.getSequencedPrimaryKeys();
        if (autoIncrement) {
            if (!sequencedPks.isEmpty()) {
                sequencedPks.forEach(pk -> this.setPropertyValueOnDto((String)pk, (Object)null, dto));
            }
        } else {
            if (this.getPrimaryKeyIncomingObject(dto, false) == null) {
                throw new UnprocessableEntityException("primary key is required.");
            }
            this.checkForDuplicate(dto);
        }
    }
}

