/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit.admin;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministratorType;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class UnitAdministratorMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.validateMultipleUnitAdministratorTypes(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.validateMultipleUnitAdministratorTypes(document);
    }

    private boolean validateMultipleUnitAdministratorTypes(MaintenanceDocument document) {
        boolean isValid = true;
        UnitAdministrator newUnitAdministrator = (UnitAdministrator)document.getNewMaintainableObject().getDataObject();
        Unit newUnit = newUnitAdministrator.getUnit();
        UnitAdministratorType newUnitAdministratorType = newUnitAdministrator.getUnitAdministratorType();
        if (document.getNewMaintainableObject().getMaintenanceAction().equals("Delete") || document.getOldMaintainableObject().getMaintenanceAction().equals("Delete")) {
            return true;
        }
        if (!newUnitAdministratorType.getMultiplesFlag().booleanValue()) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("unitNumber", newUnit.getUnitNumber());
            List unitAdministrators = this.getBusinessObjectService().findMatching(UnitAdministrator.class, fieldValues);
            for (UnitAdministrator unitAdministrator : unitAdministrators) {
                if (!StringUtils.equals((CharSequence)newUnitAdministratorType.getCode(), (CharSequence)unitAdministrator.getUnitAdministratorTypeCode())) continue;
                isValid = false;
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.unitAdministratorTypeCode", "error.unitAdministrator.multiple.types.not.allowed", new String[]{newUnitAdministratorType.getDescription()});
                break;
            }
        }
        return isValid;
    }

    private BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }
}

