/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.attachment;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostRemove;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.impl.attachment.NarrativeAttachment;
import org.kuali.coeus.propdev.impl.attachment.NarrativeStatus;
import org.kuali.coeus.propdev.impl.attachment.NarrativeType;
import org.kuali.coeus.propdev.impl.attachment.NarrativeUserRights;
import org.kuali.coeus.propdev.impl.attachment.ProposalDevelopmentAttachment;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyMaintainable;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.file.FileMeta;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="NARRATIVE")
@IdClass(value=NarrativeId.class)
public class Narrative
extends KcPersistableBusinessObjectBase
implements HierarchyMaintainable,
KcFile,
NarrativeContract,
FileMeta,
ProposalDevelopmentAttachment {
    @Id
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER")
    private DevelopmentProposal developmentProposal;
    @Id
    @Column(name="MODULE_NUMBER")
    private Integer moduleNumber;
    @Column(name="COMMENTS")
    private String comments;
    @Column(name="CONTACT_NAME")
    private String contactName;
    @Column(name="EMAIL_ADDRESS")
    private String emailAddress;
    @Column(name="MODULE_SEQUENCE_NUMBER")
    private Integer moduleSequenceNumber;
    @Column(name="MODULE_STATUS_CODE")
    private String moduleStatusCode;
    @Column(name="MODULE_TITLE")
    private String moduleTitle;
    @Column(name="NARRATIVE_TYPE_CODE")
    private String narrativeTypeCode;
    @Column(name="PHONE_NUMBER")
    private String phoneNumber;
    @Column(name="FILE_NAME")
    private String name;
    @Column(name="CONTENT_TYPE")
    private String type;
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyProposalNumber;
    @Column(name="HIDE_IN_HIERARCHY")
    @Convert(converter=BooleanYNConverter.class)
    private boolean hiddenInHierarchy;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="NARRATIVE_TYPE_CODE", referencedColumnName="NARRATIVE_TYPE_CODE", insertable=false, updatable=false)
    private NarrativeType narrativeType;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="MODULE_STATUS_CODE", referencedColumnName="NARRATIVE_STATUS_CODE", insertable=false, updatable=false)
    private NarrativeStatus narrativeStatus;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER"), @JoinColumn(name="MODULE_NUMBER", referencedColumnName="MODULE_NUMBER")})
    private List<NarrativeUserRights> narrativeUserRights = new ArrayList<NarrativeUserRights>();
    @OneToOne(mappedBy="narrative", cascade={CascadeType.ALL})
    private NarrativeAttachment narrativeAttachment;
    @Transient
    private String uploadUserFullName;
    @Transient
    private String id;
    @Transient
    private Long size;
    @Transient
    private Date dateUploaded;
    @Transient
    private String url;
    @Transient
    private transient MultipartFile multipartFile;
    @Transient
    private transient DateTimeService dateTimeService;
    @Transient
    private transient KcAttachmentService kcAttachmentService;
    @Transient
    private transient boolean moveUpAllowed;
    @Transient
    private transient boolean moveDownAllowed;

    public void init(MultipartFile multipartFile) throws Exception {
        this.name = multipartFile.getOriginalFilename();
        this.size = multipartFile.getSize();
        NarrativeAttachment attachment = new NarrativeAttachment();
        attachment.setType(multipartFile.getContentType());
        attachment.setData(multipartFile.getBytes());
        attachment.setName(multipartFile.getOriginalFilename());
        this.setNarrativeAttachment(attachment);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContentType() {
        if (this.narrativeAttachment != null) {
            return this.getNarrativeAttachment().getType();
        }
        return null;
    }

    public void setContentType(String contentType) {
        if (this.narrativeAttachment != null) {
            this.getNarrativeAttachment().setType(contentType);
        }
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Date getDateUploaded() {
        return this.dateUploaded;
    }

    public void setDateUploaded(Date dateUploaded) {
        this.dateUploaded = dateUploaded;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSizeFormatted() {
        return this.getKcAttachmentService().formatFileSizeString(this.size);
    }

    public String getDateUploadedFormatted() {
        if (this.getUpdateTimestamp() != null) {
            return this.getDateTimeService().toString(new Date(this.getUpdateTimestamp().getTime()), "MM/dd/yyyy hh:mm a");
        }
        return "";
    }

    @Override
    public MultipartFile getMultipartFile() {
        return this.multipartFile;
    }

    @Override
    public void setMultipartFile(MultipartFile multipartFile) {
        this.multipartFile = multipartFile;
    }

    public Integer getModuleNumber() {
        return this.moduleNumber;
    }

    public void setModuleNumber(Integer moduleNumber) {
        this.moduleNumber = moduleNumber;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Integer getModuleSequenceNumber() {
        return this.moduleSequenceNumber;
    }

    public void setModuleSequenceNumber(Integer moduleSequenceNumber) {
        this.moduleSequenceNumber = moduleSequenceNumber;
    }

    public String getModuleStatusCode() {
        return this.moduleStatusCode;
    }

    public void setModuleStatusCode(String moduleStatusCode) {
        this.moduleStatusCode = moduleStatusCode;
    }

    public String getModuleTitle() {
        return this.moduleTitle;
    }

    public void setModuleTitle(String moduleTitle) {
        this.moduleTitle = moduleTitle;
    }

    public String getNarrativeTypeCode() {
        return this.narrativeTypeCode;
    }

    public void setNarrativeTypeCode(String narrativeTypeCode) {
        this.narrativeTypeCode = narrativeTypeCode;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public NarrativeType getNarrativeType() {
        return this.narrativeType;
    }

    public void setNarrativeType(NarrativeType narrativeType) {
        this.narrativeType = narrativeType;
    }

    public List<NarrativeUserRights> getNarrativeUserRights() {
        if (this.narrativeUserRights != null) {
            Collections.sort(this.narrativeUserRights, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    NarrativeUserRights r1 = (NarrativeUserRights)o1;
                    NarrativeUserRights r2 = (NarrativeUserRights)o2;
                    if (r1 == null || r2 == null) {
                        return 0;
                    }
                    String name1 = r1.getPersonName();
                    String name2 = r2.getPersonName();
                    if (name1 == null || name2 == null) {
                        return 0;
                    }
                    return name1.compareTo(name2);
                }
            });
        }
        return this.narrativeUserRights;
    }

    public void setNarrativeUserRights(List<NarrativeUserRights> narrativeUserRights) {
        this.narrativeUserRights = narrativeUserRights;
    }

    public NarrativeStatus getNarrativeStatus() {
        return this.narrativeStatus;
    }

    public void setNarrativeStatus(NarrativeStatus narrativeStatus) {
        this.narrativeStatus = narrativeStatus;
    }

    public NarrativeAttachment getNarrativeAttachment() {
        return this.narrativeAttachment;
    }

    public void setNarrativeAttachment(NarrativeAttachment narrativeAttachment) {
        this.narrativeAttachment = narrativeAttachment;
        if (narrativeAttachment != null) {
            this.narrativeAttachment.setNarrative(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInstitutionalAttachmentTypeCode() {
        return this.narrativeTypeCode;
    }

    public void setInstitutionalAttachmentTypeCode(String institutionalAttachmentTypeCode) {
        this.narrativeTypeCode = institutionalAttachmentTypeCode;
    }

    public NarrativeUserRights getNarrativeUserRight(int index) {
        while (this.getNarrativeUserRights().size() <= index) {
            this.getNarrativeUserRights().add(new NarrativeUserRights());
        }
        return this.getNarrativeUserRights().get(index);
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getNarrativeUserRights());
        return managedLists;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + (this.contactName == null ? 0 : this.contactName.hashCode());
        result = 31 * result + (this.emailAddress == null ? 0 : this.emailAddress.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.moduleNumber == null ? 0 : this.moduleNumber.hashCode());
        result = 31 * result + (this.moduleSequenceNumber == null ? 0 : this.moduleSequenceNumber.hashCode());
        result = 31 * result + (this.moduleStatusCode == null ? 0 : this.moduleStatusCode.hashCode());
        result = 31 * result + (this.moduleTitle == null ? 0 : this.moduleTitle.hashCode());
        result = 31 * result + (this.narrativeStatus == null ? 0 : this.narrativeStatus.hashCode());
        result = 31 * result + (this.narrativeType == null ? 0 : this.narrativeType.hashCode());
        result = 31 * result + (this.narrativeTypeCode == null ? 0 : this.narrativeTypeCode.hashCode());
        result = 31 * result + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        result = 31 * result + (this.developmentProposal == null ? 0 : this.developmentProposal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Narrative other = (Narrative)obj;
        if (this.comments == null ? other.comments != null : !this.comments.equals(other.comments)) {
            return false;
        }
        if (this.contactName == null ? other.contactName != null : !this.contactName.equals(other.contactName)) {
            return false;
        }
        if (this.emailAddress == null ? other.emailAddress != null : !this.emailAddress.equals(other.emailAddress)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.moduleNumber == null ? other.moduleNumber != null : !this.moduleNumber.equals(other.moduleNumber)) {
            return false;
        }
        if (this.moduleSequenceNumber == null ? other.moduleSequenceNumber != null : !this.moduleSequenceNumber.equals(other.moduleSequenceNumber)) {
            return false;
        }
        if (this.moduleStatusCode == null ? other.moduleStatusCode != null : !this.moduleStatusCode.equals(other.moduleStatusCode)) {
            return false;
        }
        if (this.moduleTitle == null ? other.moduleTitle != null : !this.moduleTitle.equals(other.moduleTitle)) {
            return false;
        }
        if (this.narrativeStatus == null ? other.narrativeStatus != null : !this.narrativeStatus.equals(other.narrativeStatus)) {
            return false;
        }
        if (this.narrativeType == null ? other.narrativeType != null : !this.narrativeType.equals(other.narrativeType)) {
            return false;
        }
        if (this.narrativeTypeCode == null ? other.narrativeTypeCode != null : !this.narrativeTypeCode.equals(other.narrativeTypeCode)) {
            return false;
        }
        if (this.phoneNumber == null ? other.phoneNumber != null : !this.phoneNumber.equals(other.phoneNumber)) {
            return false;
        }
        return !(this.developmentProposal == null ? other.developmentProposal != null : !this.developmentProposal.equals(other.developmentProposal));
    }

    public int hierarchyHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + (this.contactName == null ? 0 : this.contactName.hashCode());
        result = 31 * result + (this.emailAddress == null ? 0 : this.emailAddress.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.moduleNumber == null ? 0 : this.moduleNumber.hashCode());
        result = 31 * result + (this.moduleSequenceNumber == null ? 0 : this.moduleSequenceNumber.hashCode());
        result = 31 * result + (this.moduleStatusCode == null ? 0 : this.moduleStatusCode.hashCode());
        result = 31 * result + (this.moduleTitle == null ? 0 : this.moduleTitle.hashCode());
        result = 31 * result + (this.narrativeStatus == null ? 0 : this.narrativeStatus.hashCode());
        result = 31 * result + (this.narrativeType == null ? 0 : this.narrativeType.hashCode());
        result = 31 * result + (this.narrativeTypeCode == null ? 0 : this.narrativeTypeCode.hashCode());
        result = 31 * result + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        return result;
    }

    public Timestamp getTimestampDisplay() {
        if (this.getNarrativeAttachment() == null || this.getNarrativeAttachment().getUploadTimestamp() == null) {
            return this.getDateTimeService().getCurrentTimestamp();
        }
        return this.getNarrativeAttachment().getUploadTimestamp();
    }

    @Override
    public String getUploadUserDisplay() {
        if (this.getNarrativeAttachment() == null || StringUtils.isBlank((CharSequence)this.getNarrativeAttachment().getUploadUser())) {
            return this.getUpdateUser();
        }
        return this.getNarrativeAttachment().getUploadUser();
    }

    public String getUploadUserFullName() {
        return this.uploadUserFullName;
    }

    public void setUploadUserFullName(String uploadUserFullName) {
        this.uploadUserFullName = uploadUserFullName;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public String getType() {
        return this.getContentType();
    }

    public void setType(String contentType) {
        this.type = contentType;
    }

    public byte[] getData() {
        return this.getNarrativeAttachment() != null ? this.getNarrativeAttachment().getData() : null;
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    public String getProposalNumber() {
        return this.getDevelopmentProposal().getProposalNumber();
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public KcAttachmentService getKcAttachmentService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = KcServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }

    public void setKcAttachmentService(KcAttachmentService kcAttachmentService) {
        this.kcAttachmentService = kcAttachmentService;
    }

    public boolean isMoveDownAllowed() {
        return this.moveDownAllowed;
    }

    public boolean isMoveUpAllowed() {
        return this.moveUpAllowed;
    }

    public void setMoveDownAllowed(boolean moveDownAllowed) {
        this.moveDownAllowed = moveDownAllowed;
    }

    public void setMoveUpAllowed(boolean moveUpAllowed) {
        this.moveUpAllowed = moveUpAllowed;
    }

    @PostRemove
    public void removeData() {
        if (this.getNarrativeAttachment() != null && this.getNarrativeAttachment().getFileDataId() != null) {
            this.getKcAttachmentDao().removeData(this.getNarrativeAttachment().getFileDataId());
        }
    }

    private KcAttachmentDataDao getKcAttachmentDao() {
        return KcServiceLocator.getService(KcAttachmentDataDao.class);
    }

    public String getUploadUser() {
        return this.getNarrativeAttachment() != null ? this.getNarrativeAttachment().getUploadUser() : null;
    }

    public void setUploadUser(String uploadUser) {
        if (this.getNarrativeAttachment() != null) {
            this.getNarrativeAttachment().setUploadUser(uploadUser);
        }
    }

    public Date getUploadTimestamp() {
        return this.getNarrativeAttachment() != null ? this.getNarrativeAttachment().getUploadTimestamp() : null;
    }

    public void setUploadTimestamp(Date uploadTimestamp) {
        if (this.getNarrativeAttachment() != null) {
            this.getNarrativeAttachment().setUploadTimestamp(new Timestamp(uploadTimestamp.getTime()));
        }
    }

    public static final class NarrativeId
    implements Serializable,
    Comparable<NarrativeId> {
        public static final String DEVELOPMENT_PROPOSAL = "developmentProposal";
        public static final String MODULE_NUMBER = "moduleNumber";
        private String developmentProposal;
        private Integer moduleNumber;

        public NarrativeId(String proposalNumber, Integer moduleNumber) {
            this.moduleNumber = moduleNumber;
            this.developmentProposal = proposalNumber;
        }

        public Integer getModuleNumber() {
            return this.moduleNumber;
        }

        public void setModuleNumber(Integer moduleNumber) {
            this.moduleNumber = moduleNumber;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append(DEVELOPMENT_PROPOSAL, (Object)this.developmentProposal).append(MODULE_NUMBER, (Object)this.moduleNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            NarrativeId rhs = (NarrativeId)other;
            return new EqualsBuilder().append((Object)this.developmentProposal, (Object)rhs.developmentProposal).append((Object)this.moduleNumber, (Object)rhs.moduleNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.developmentProposal).append((Object)this.moduleNumber).toHashCode();
        }

        @Override
        public int compareTo(NarrativeId other) {
            return new CompareToBuilder().append((Object)this.developmentProposal, (Object)other.developmentProposal).append((Object)this.moduleNumber, (Object)other.moduleNumber).toComparison();
        }

        public String getDevelopmentProposal() {
            return this.developmentProposal;
        }

        public void setDevelopmentProposal(String developmentProposal) {
            this.developmentProposal = developmentProposal;
        }
    }
}

