/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.subaward;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.XfaForm;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetService;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardAttachment;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardFiles;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardPeriodDetail;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.propdev.impl.budget.subaward.PropDevBudgetSubAwardService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.s2s.FormUtilityService;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.s2sgen.api.generate.FormMappingInfo;
import org.kuali.coeus.s2sgen.api.generate.FormMappingService;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@Component(value="propDevBudgetSubAwardService")
public class PropDevPropDevBudgetSubAwardServiceImpl
implements PropDevBudgetSubAwardService {
    private static final String XFA_NS = "http://www.xfa.org/schema/xfa-data/1.0/";
    private static final Logger LOG = LogManager.getLogger(PropDevPropDevBudgetSubAwardServiceImpl.class);
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String BUDGET_YEAR_XPATH = "//*[local-name(.) = 'BudgetYear']";
    private static final String RR_FED_NON_FED_BUDGET = "RR_FedNonFedBudget";
    private static final String BUDGET_PERIOD = "BudgetPeriod";
    private static final Set<String> FED_NON_FED_FORMS = Stream.of("http://apply.grants.gov/forms/RR_FedNonFedBudget-V1.0", "http://apply.grants.gov/forms/RR_FedNonFedBudget10-V1.1", "http://apply.grants.gov/forms/RR_FedNonFedBudget_1_2-V1.2", "http://apply.grants.gov/forms/RR_FedNonFedBudget_2_0-V2.0").collect(Collectors.toSet());
    private static final int CONTENT_ID_MAX_LENGTH = 50;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="proposalBudgetService")
    private BudgetService budgetService;
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="formMappingService")
    private FormMappingService formMappingService;
    @Autowired
    @Qualifier(value="grantApplicationHashService")
    private GrantApplicationHashService grantApplicationHashService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="sponsorHierarchyService")
    private SponsorHierarchyService sponsorHierarchyService;
    @Autowired
    @Qualifier(value="formUtilityService")
    private FormUtilityService formUtilityService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateSubAwardFileVersion(Budget budget, byte[] fileData) {
        try {
            DevelopmentProposal developmentProposal = (DevelopmentProposal)budget.getBudgetParent();
            if (!developmentProposal.hasS2sOpportunity()) return true;
            List<String> s2sFormNamespaces = developmentProposal.getS2sOppForms().stream().map(S2sOppForms::getOppNameSpace).toList();
            try (PdfReader reader = new PdfReader(fileData);){
                XfaForm xfaForm = reader.getAcroFields().getXfa();
                Node datasetsNode = xfaForm.getDatasetsNode();
                if (datasetsNode == null) {
                    LOG.warn("Not able to get datasets node from PDF");
                    boolean bl = false;
                    return bl;
                }
                Element xmlElement = this.getBudgetElementFromDatasetsNode(datasetsNode);
                boolean bl = xmlElement != null && s2sFormNamespaces.contains(xmlElement.getNamespaceURI());
                return bl;
            }
        }
        catch (IOException | XPathExpressionException e) {
            LOG.warn("Not able to extract xml from pdf", (Throwable)e);
            return false;
        }
    }

    @Override
    public void populateBudgetSubAwardFiles(Budget budget, BudgetSubAwards subAward, String newFileName, byte[] newFileData) {
        boolean subawardBudgetExtracted;
        subAward.setSubAwardStatusCode(1);
        BudgetSubAwardFiles newSubAwardFile = new BudgetSubAwardFiles();
        newSubAwardFile.setSubAwardXfdFileData(newFileData);
        subAward.getBudgetSubAwardAttachments().clear();
        subAward.getBudgetSubAwardFiles().clear();
        subAward.getBudgetSubAwardFiles().add(newSubAwardFile);
        try {
            byte[] pdfFileContents = newSubAwardFile.getSubAwardXfdFileData();
            subAward.setSubAwardXfdFileData(pdfFileContents);
            PdfReader reader = new PdfReader(pdfFileContents);
            byte[] xmlContents = this.getXMLFromPDF(reader);
            boolean bl = subawardBudgetExtracted = xmlContents != null && xmlContents.length > 0;
            if (subawardBudgetExtracted) {
                List<KcFile> attachments = this.getFormUtilityService().extractAttachments(reader);
                Collection<String> duplicates = CollectionUtils.findDuplicates(attachments, KcFile::getName);
                if (!duplicates.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Duplicate attachments detected " + String.valueOf(duplicates));
                    }
                    subawardBudgetExtracted = false;
                } else {
                    this.updateXML(xmlContents, attachments, subAward);
                }
            }
        }
        catch (IOException | RuntimeException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            LOG.error("Not able to extract xml from pdf", (Throwable)e);
            subawardBudgetExtracted = false;
        }
        newSubAwardFile.setSubAwardXfdFileData(subAward.getSubAwardXfdFileData());
        if (subawardBudgetExtracted) {
            newSubAwardFile.setSubAwardXmlFileData(subAward.getSubAwardXmlFileData());
        }
        newSubAwardFile.setSubAwardXfdFileName(newFileName);
        newSubAwardFile.setBudgetSubAward(subAward);
        subAward.setSubAwardXfdFileName(newFileName);
        subAward.setXfdUpdateUser(this.getLoggedInUserNetworkId());
        subAward.setXfdUpdateTimestamp(this.dateTimeService.getCurrentTimestamp());
        subAward.setXmlUpdateUser(this.getLoggedInUserNetworkId());
        subAward.setXmlUpdateTimestamp(this.dateTimeService.getCurrentTimestamp());
    }

    @Override
    public void removeSubAwardAttachment(BudgetSubAwards subAward) {
        subAward.setFormName(null);
        subAward.setNamespace(null);
        subAward.setSubAwardXfdFileData(null);
        subAward.setSubAwardXfdFileName(null);
        subAward.setSubAwardXmlFileData(null);
        subAward.setXfdUpdateUser(null);
        subAward.getBudgetSubAwardAttachments().clear();
        subAward.getBudgetSubAwardFiles().clear();
        subAward.setXfdUpdateUser(this.getLoggedInUserNetworkId());
        subAward.setXfdUpdateTimestamp(this.dateTimeService.getCurrentTimestamp());
        subAward.setXmlUpdateUser(this.getLoggedInUserNetworkId());
        subAward.setXmlUpdateTimestamp(this.dateTimeService.getCurrentTimestamp());
        this.resetSubAwardPeriodDetails(subAward);
    }

    protected void resetSubAwardPeriodDetails(BudgetSubAwards subAward) {
        for (BudgetSubAwardPeriodDetail budgetSubAwardPeriodDetail : subAward.getBudgetSubAwardPeriodDetails()) {
            budgetSubAwardPeriodDetail.setDirectCost(ScaleTwoDecimal.ZERO);
            budgetSubAwardPeriodDetail.setCostShare(ScaleTwoDecimal.ZERO);
            budgetSubAwardPeriodDetail.setIndirectCost(ScaleTwoDecimal.ZERO);
            budgetSubAwardPeriodDetail.setTotalCost(ScaleTwoDecimal.ZERO);
        }
    }

    @Override
    public void prepareBudgetSubAwards(Budget budget) {
        this.populateBudgetSubAwardAttachments(budget);
        for (BudgetSubAwards subAward : budget.getBudgetSubAwards()) {
            for (BudgetPeriod period : budget.getBudgetPeriods()) {
                BudgetSubAwardPeriodDetail detail = null;
                for (BudgetSubAwardPeriodDetail curDetail : subAward.getBudgetSubAwardPeriodDetails()) {
                    if (!Objects.equals(curDetail.getBudgetPeriod(), period.getBudgetPeriod())) continue;
                    detail = curDetail;
                    break;
                }
                if (detail != null) continue;
                subAward.getBudgetSubAwardPeriodDetails().add(new BudgetSubAwardPeriodDetail(subAward, period));
            }
        }
    }

    @Override
    public void generateSubAwardLineItems(BudgetSubAwards subAward, ProposalDevelopmentBudgetExt budget) {
        boolean isNihProposal = this.getSponsorHierarchyService().isSponsorNihMultiplePi(budget.getDevelopmentProposal().getSponsorCode());
        String directLtCostElement = this.getParameterService().getParameterValueAsString(Budget.class, "SUBCONTRACTOR_DIRECT_LT_LIMIT");
        String directGtCostElement = this.getParameterService().getParameterValueAsString(Budget.class, "SUBCONTRACTOR_DIRECT_GT_LIMIT");
        String inDirectLtCostElement = this.getParameterService().getParameterValueAsString(Budget.class, "SUBCONTRACTOR_F_AND_A_LT_LIMIT");
        String inDirectGtCostElement = this.getParameterService().getParameterValueAsString(Budget.class, "SUBCONTRACTOR_F_AND_A_GT_LIMIT");
        ScaleTwoDecimal amountChargeFA = new ScaleTwoDecimal(this.getParameterService().getParameterValueAsString(Budget.class, "SUBCONTRACTOR_LIMIT"));
        for (BudgetSubAwardPeriodDetail detail : subAward.getBudgetSubAwardPeriodDetails()) {
            BudgetLineItem gt;
            BudgetLineItem lt;
            ScaleTwoDecimal gtValue;
            ScaleTwoDecimal ltValue;
            BudgetPeriod budgetPeriod = this.findBudgetPeriod(detail, budget);
            List<BudgetLineItem> currentSubawardLineItems = this.zeroOutSubAwardLineItems(subAward, budgetPeriod);
            ScaleTwoDecimal directCost = ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)detail.getDirectCost());
            if (!isNihProposal) {
                directCost = (ScaleTwoDecimal)directCost.add((AbstractDecimal)ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)detail.getIndirectCost()));
            }
            if (directCost.isNonZero()) {
                ltValue = this.lesserValue(directCost, amountChargeFA);
                gtValue = (ScaleTwoDecimal)directCost.subtract((AbstractDecimal)ltValue);
                if (ltValue.isNonZero()) {
                    lt = this.findOrCreateLineItem(currentSubawardLineItems, detail, budgetPeriod, directLtCostElement, subAward.getOrganizationName());
                    lt.setLineItemCost(ltValue);
                }
                if (gtValue.isNonZero()) {
                    gt = this.findOrCreateLineItem(currentSubawardLineItems, detail, budgetPeriod, directGtCostElement, subAward.getOrganizationName());
                    gt.setLineItemCost(gtValue);
                }
                amountChargeFA = (ScaleTwoDecimal)amountChargeFA.subtract((AbstractDecimal)ltValue);
            }
            if (ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)detail.getIndirectCost()).isNonZero() && isNihProposal) {
                ltValue = this.lesserValue(detail.getIndirectCost(), amountChargeFA);
                gtValue = (ScaleTwoDecimal)detail.getIndirectCost().subtract((AbstractDecimal)ltValue);
                if (ltValue.isNonZero()) {
                    lt = this.findOrCreateLineItem(currentSubawardLineItems, detail, budgetPeriod, inDirectLtCostElement, subAward.getOrganizationName());
                    lt.setLineItemCost(ltValue);
                }
                if (gtValue.isNonZero()) {
                    gt = this.findOrCreateLineItem(currentSubawardLineItems, detail, budgetPeriod, inDirectGtCostElement, subAward.getOrganizationName());
                    gt.setLineItemCost(gtValue);
                }
                amountChargeFA = (ScaleTwoDecimal)amountChargeFA.subtract((AbstractDecimal)ltValue);
            }
            if (ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)detail.getCostShare()).isNonZero()) {
                String orgName = subAward.getOrganizationName() + " CostShare Amount(";
                String description = orgName + String.valueOf(detail.getCostShare()) + ")";
                BudgetLineItem costShareLineItem = this.findOrCreateCostshareLineItem(currentSubawardLineItems, detail, budgetPeriod, directGtCostElement, description, orgName);
                costShareLineItem.setLineItemCost(ScaleTwoDecimal.ZERO);
                costShareLineItem.setCostSharingAmount(detail.getCostShare());
                currentSubawardLineItems.add(costShareLineItem);
            }
            currentSubawardLineItems.sort(Comparator.comparing(BudgetLineItem::getLineItemNumber));
            this.addSubawardLineItemsToBudgetPeriod(budgetPeriod, currentSubawardLineItems);
        }
    }

    protected List<BudgetLineItem> zeroOutSubAwardLineItems(BudgetSubAwards subAward, BudgetPeriod budgetPeriod) {
        List<BudgetLineItem> currentSubawardLineItems = this.findSubAwardLineItems(budgetPeriod, subAward.getSubAwardNumber());
        for (BudgetLineItem item : currentSubawardLineItems) {
            item.setLineItemCost(ScaleTwoDecimal.ZERO);
            item.setDirectCost(ScaleTwoDecimal.ZERO);
            item.setCostSharingAmount(ScaleTwoDecimal.ZERO);
            item.setBudgetSubAward(subAward);
            item.setLineItemDescription(subAward.getOrganizationName());
        }
        return currentSubawardLineItems;
    }

    protected void addSubawardLineItemsToBudgetPeriod(BudgetPeriod budgetPeriod, List<BudgetLineItem> currentSubawardLineItems) {
        Iterator<BudgetLineItem> iter = currentSubawardLineItems.iterator();
        while (iter.hasNext()) {
            BudgetLineItem lineItem = iter.next();
            if (ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)lineItem.getLineItemCost()).isZero() && ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)lineItem.getCostSharingAmount()).isZero()) {
                budgetPeriod.getBudgetLineItems().remove(lineItem);
                iter.remove();
                continue;
            }
            if (budgetPeriod.getBudgetLineItems().contains(lineItem)) continue;
            budgetPeriod.getBudgetLineItems().add(lineItem);
        }
    }

    protected BudgetPeriod findBudgetPeriod(BudgetSubAwardPeriodDetail detail, Budget budget) {
        for (BudgetPeriod period : budget.getBudgetPeriods()) {
            if (!Objects.equals(detail.getBudgetPeriod(), period.getBudgetPeriod())) continue;
            return period;
        }
        return null;
    }

    protected ScaleTwoDecimal lesserValue(ScaleTwoDecimal num1, ScaleTwoDecimal num2) {
        if (num1.isLessThan((AbstractDecimal)num2)) {
            return num1;
        }
        return num2;
    }

    protected BudgetLineItem findOrCreateLineItem(List<BudgetLineItem> lineItems, BudgetSubAwardPeriodDetail subAwardDetail, BudgetPeriod budgetPeriod, String costElement, String description) {
        for (BudgetLineItem curLineItem : lineItems) {
            if (!StringUtils.equals((CharSequence)curLineItem.getCostElement(), (CharSequence)costElement)) continue;
            return curLineItem;
        }
        return this.createLineItem(lineItems, subAwardDetail, budgetPeriod, costElement, description);
    }

    protected BudgetLineItem findOrCreateCostshareLineItem(List<BudgetLineItem> lineItems, BudgetSubAwardPeriodDetail subAwardDetail, BudgetPeriod budgetPeriod, String costElement, String lineItemDescription, String orgName) {
        for (BudgetLineItem curLineItem : lineItems) {
            if (!StringUtils.startsWith((CharSequence)curLineItem.getLineItemDescription(), (CharSequence)orgName)) continue;
            return curLineItem;
        }
        return this.createLineItem(lineItems, subAwardDetail, budgetPeriod, costElement, lineItemDescription);
    }

    private BudgetLineItem createLineItem(List<BudgetLineItem> lineItems, BudgetSubAwardPeriodDetail subAwardDetail, BudgetPeriod budgetPeriod, String costElement, String description) {
        BudgetLineItem newLineItem = new BudgetLineItem();
        newLineItem.setCostElement(costElement);
        newLineItem.setBudgetSubAward(subAwardDetail.getBudgetSubAward());
        newLineItem.setLineItemDescription(description);
        this.getBudgetService().populateNewBudgetLineItem(newLineItem, budgetPeriod);
        lineItems.add(newLineItem);
        return newLineItem;
    }

    protected List<BudgetLineItem> findSubAwardLineItems(BudgetPeriod budgetPeriod, Integer subAwardNumber) {
        ArrayList<BudgetLineItem> lineItems = new ArrayList<BudgetLineItem>();
        if (budgetPeriod.getBudgetLineItems() != null) {
            lineItems.addAll(budgetPeriod.getBudgetLineItems().stream().filter(item -> item.getBudgetSubAward() != null && Objects.equals(item.getBudgetSubAward().getSubAwardNumber(), subAwardNumber)).collect(Collectors.toList()));
        }
        return lineItems;
    }

    protected String getLoggedInUserNetworkId() {
        return this.globalVariableService.getUserSession().getPrincipalName();
    }

    @Override
    public byte[] getXMLFromPDF(PdfReader reader) throws IOException, XPathExpressionException {
        XfaForm xfaForm = reader.getAcroFields().getXfa();
        Node datasetsNode = xfaForm.getDatasetsNode();
        if (datasetsNode == null) {
            LOG.warn("Not able to get datasets node from PDF");
            return null;
        }
        Element budgetElement = this.getBudgetElementFromDatasetsNode(datasetsNode);
        return XfaForm.serializeDoc((Node)budgetElement);
    }

    private Element getBudgetElementFromDatasetsNode(Node datasetsNode) throws XPathExpressionException {
        Element dataElement = datasetsNode != null ? (Element)((Element)datasetsNode).getElementsByTagNameNS(XFA_NS, "data").item(0) : null;
        Element budgetElement = this.getBudgetElementFromGrantApplicationWrapperForm(dataElement);
        return budgetElement != null ? budgetElement : this.getBudgetElementInBudgetAttachments(dataElement);
    }

    private Element getBudgetElementInBudgetAttachments(Element xmlElement) throws XPathExpressionException {
        Element budgetAttachment;
        Node budgetNode = xmlElement;
        NodeList budgetAttachments = (NodeList)XPathFactory.newInstance().newXPath().evaluate("//*[local-name(.) = 'BudgetAttachments']", xmlElement, XPathConstants.NODESET);
        if (budgetAttachments != null && budgetAttachments.getLength() > 0 && (budgetAttachment = (Element)budgetAttachments.item(0)).hasChildNodes()) {
            budgetNode = budgetAttachment.getFirstChild();
        }
        return budgetNode;
    }

    private Element getBudgetElementFromGrantApplicationWrapperForm(Element dataElement) {
        NodeList grantFormsElements = dataElement.getElementsByTagName("grant:Forms");
        if (grantFormsElements.getLength() == 0) {
            return null;
        }
        Element grantFormsElement = (Element)grantFormsElements.item(0);
        if (grantFormsElement == null) {
            return null;
        }
        return (Element)grantFormsElement.getFirstChild();
    }

    @Override
    public void updateSubAwardBudgetDetails(Budget budget, BudgetSubAwards budgetSubAward, List<String[]> errors) throws Exception {
        PdfReader reader;
        byte[] xmlContents;
        if (budgetSubAward.getSubAwardXfdFileData() == null || budgetSubAward.getSubAwardXfdFileData().length == 0) {
            errors.add(new String[]{"newSubAward.subAwardFile.notExtracted"});
        }
        if ((xmlContents = this.getXMLFromPDF(reader = new PdfReader(budgetSubAward.getSubAwardXfdFileData()))) == null) {
            errors.add(new String[]{"newSubAward.subAwardFile.notExtracted"});
        }
        DocumentBuilderFactory domParserFactory = SafeXmlUtils.safeDocumentBuilderFactory();
        DocumentBuilder domParser = domParserFactory.newDocumentBuilder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xmlContents);
        Document document = domParser.parse(byteArrayInputStream);
        NodeList budgetYearList = (NodeList)XPathFactory.newInstance().newXPath().evaluate(BUDGET_YEAR_XPATH, document, XPathConstants.NODESET);
        boolean fnfForm = StringUtils.contains((CharSequence)budgetSubAward.getFormName(), (CharSequence)RR_FED_NON_FED_BUDGET);
        this.resetSubAwardPeriodDetails(budgetSubAward);
        for (int i = 0; i < budgetYearList.getLength(); ++i) {
            Date endDate;
            SimpleDateFormat dateFormat;
            Date startDate;
            BudgetSubAwardPeriodDetail periodDetail;
            Node endDateNode;
            Node budgetYear = budgetYearList.item(i);
            Node startDateNode = (Node)XPathFactory.newInstance().newXPath().evaluate("BudgetPeriodStartDate", budgetYear, XPathConstants.NODE);
            if (startDateNode == null) {
                startDateNode = (Node)XPathFactory.newInstance().newXPath().evaluate("PeriodStartDate", budgetYear, XPathConstants.NODE);
            }
            if ((endDateNode = (Node)XPathFactory.newInstance().newXPath().evaluate("BudgetPeriodEndDate", budgetYear, XPathConstants.NODE)) == null) {
                endDateNode = (Node)XPathFactory.newInstance().newXPath().evaluate("PeriodEndDate", budgetYear, XPathConstants.NODE);
            }
            if ((periodDetail = this.findBudgetSubAwardPeriodDetail(budget, budgetSubAward, startDate = (dateFormat = new SimpleDateFormat(YYYY_MM_DD)).parse(startDateNode.getTextContent()), endDate = dateFormat.parse(endDateNode.getTextContent()))) != null) {
                Node indirectCostNode;
                Node directCostNode;
                Node costShareNode = null;
                if (fnfForm) {
                    directCostNode = (Node)XPathFactory.newInstance().newXPath().evaluate("DirectCosts/FederalSummary", budgetYear, XPathConstants.NODE);
                    indirectCostNode = (Node)XPathFactory.newInstance().newXPath().evaluate("IndirectCosts/TotalIndirectCosts/FederalSummary", budgetYear, XPathConstants.NODE);
                    costShareNode = (Node)XPathFactory.newInstance().newXPath().evaluate("TotalCosts/NonFederalSummary", budgetYear, XPathConstants.NODE);
                } else {
                    directCostNode = (Node)XPathFactory.newInstance().newXPath().evaluate("DirectCosts", budgetYear, XPathConstants.NODE);
                    if (directCostNode == null) {
                        directCostNode = (Node)XPathFactory.newInstance().newXPath().evaluate("TotalDirectCostsRequested", budgetYear, XPathConstants.NODE);
                    }
                    if ((indirectCostNode = (Node)XPathFactory.newInstance().newXPath().evaluate("IndirectCosts/TotalIndirectCosts", budgetYear, XPathConstants.NODE)) == null) {
                        indirectCostNode = (Node)XPathFactory.newInstance().newXPath().evaluate("TotalIndirectCostsRequested", budgetYear, XPathConstants.NODE);
                    }
                }
                if (directCostNode != null && !StringUtils.isEmpty((CharSequence)directCostNode.getTextContent())) {
                    periodDetail.setDirectCost(new ScaleTwoDecimal((double)Float.parseFloat(directCostNode.getTextContent())));
                }
                if (indirectCostNode != null && !StringUtils.isEmpty((CharSequence)indirectCostNode.getTextContent())) {
                    periodDetail.setIndirectCost(new ScaleTwoDecimal((double)Float.parseFloat(indirectCostNode.getTextContent())));
                }
                if (costShareNode != null && !StringUtils.isEmpty((CharSequence)costShareNode.getTextContent())) {
                    periodDetail.setCostShare(new ScaleTwoDecimal((double)Float.parseFloat(costShareNode.getTextContent())));
                } else {
                    periodDetail.setCostShare(ScaleTwoDecimal.ZERO);
                }
                periodDetail.computeTotal();
                continue;
            }
            Node budgetPeriodNode = (Node)XPathFactory.newInstance().newXPath().evaluate(BUDGET_PERIOD, budgetYear, XPathConstants.NODE);
            String budgetPeriod = null;
            if (budgetPeriodNode != null) {
                budgetPeriod = budgetPeriodNode.getTextContent();
            }
            LOG.debug("Unable to find matching period for uploaded period '" + budgetPeriod + "' -- " + startDateNode.getTextContent() + " - " + endDateNode.getTextContent());
            errors.add(new String[]{"newSubAward.subAwardFile.periodNotFound", budgetPeriod == null ? "" : budgetPeriod, startDateNode.getTextContent(), endDateNode.getTextContent()});
        }
    }

    protected BudgetSubAwardPeriodDetail findBudgetSubAwardPeriodDetail(Budget budget, BudgetSubAwards budgetSubAward, Date startDate, Date endDate) {
        BudgetPeriod matchingPeriod = null;
        BudgetSubAwardPeriodDetail matchingDetail = null;
        for (BudgetPeriod period : budget.getBudgetPeriods()) {
            if (startDate.getTime() != period.getStartDate().getTime() || endDate.getTime() != period.getEndDate().getTime()) continue;
            matchingPeriod = period;
            break;
        }
        if (matchingPeriod != null) {
            for (BudgetSubAwardPeriodDetail detail : budgetSubAward.getBudgetSubAwardPeriodDetails()) {
                if (!Objects.equals(detail.getBudgetPeriod(), matchingPeriod.getBudgetPeriod())) continue;
                matchingDetail = detail;
                break;
            }
        }
        return matchingDetail;
    }

    protected void updateXML(byte[] xmlContents, List<KcFile> files, BudgetSubAwards budgetSubAwardBean) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException, TransformerException {
        DocumentBuilderFactory domParserFactory = SafeXmlUtils.safeDocumentBuilderFactory();
        DocumentBuilder domParser = domParserFactory.newDocumentBuilder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xmlContents);
        Document document = domParser.parse(byteArrayInputStream);
        byteArrayInputStream.close();
        String namespace = null;
        if (document != null) {
            Element element = document.getDocumentElement();
            NamedNodeMap map = element.getAttributes();
            String namespaceHolder = element.getNodeName().substring(0, element.getNodeName().indexOf(58));
            Node node = map.getNamedItem("xmlns:" + namespaceHolder);
            namespace = node.getNodeValue();
            FormMappingInfo formMappingInfo = this.formMappingService.getFormInfo(namespace);
            String formName = formMappingInfo.getFormName();
            budgetSubAwardBean.setNamespace(namespace);
            budgetSubAwardBean.setFormName(formName);
        }
        String xpathEmptyNodes = "//*[not(node()) and local-name(.) != 'FileLocation' and local-name(.) != 'HashValue']";
        String xpathOtherPers = "//*[local-name(.)='ProjectRole' and local-name(../../.)='OtherPersonnel' and count(../NumberOfPersonnel)=0]";
        this.removeAllEmptyNodes(document, xpathEmptyNodes, 0);
        this.removeAllEmptyNodes(document, xpathOtherPers, 1);
        this.removeAllEmptyNodes(document, xpathEmptyNodes, 0);
        this.changeDataTypeForNumberOfOtherPersons(document);
        NodeList budgetYearList = (NodeList)XPathFactory.newInstance().newXPath().evaluate(BUDGET_YEAR_XPATH, document, XPathConstants.NODESET);
        for (int i = 0; i < budgetYearList.getLength(); ++i) {
            Element newBudgetYearElement;
            Node bgtYearNode = budgetYearList.item(i);
            String period = PropDevPropDevBudgetSubAwardServiceImpl.getValue((Node)XPathFactory.newInstance().newXPath().evaluate(BUDGET_PERIOD, bgtYearNode, XPathConstants.NODE));
            if (FED_NON_FED_FORMS.contains(namespace)) {
                newBudgetYearElement = this.copyElementToName((Element)bgtYearNode, bgtYearNode.getNodeName());
                bgtYearNode.getParentNode().replaceChild(newBudgetYearElement, bgtYearNode);
                continue;
            }
            newBudgetYearElement = this.copyElementToName((Element)bgtYearNode, bgtYearNode.getNodeName() + period);
            bgtYearNode.getParentNode().replaceChild(newBudgetYearElement, bgtYearNode);
        }
        Node oldroot = document.removeChild(document.getDocumentElement());
        Node newroot = document.appendChild(document.createElement("Forms"));
        newroot.appendChild(oldroot);
        NodeList lstFileName = document.getElementsByTagName("att:FileName");
        NodeList lstFileLocation = document.getElementsByTagName("att:FileLocation");
        NodeList lstMimeType = document.getElementsByTagName("att:MimeType");
        NodeList lstHashValue = document.getElementsByTagName("glob:HashValue");
        ArrayList<BudgetSubAwardAttachment> attachmentList = new ArrayList<BudgetSubAwardAttachment>();
        for (int index = 0; index < lstFileName.getLength(); ++index) {
            Node fileNode = lstFileName.item(index);
            Node fileNameNode = fileNode.getFirstChild();
            if (fileNameNode == null) continue;
            String fileName = fileNameNode.getNodeValue();
            Optional<KcFile> file = files.stream().filter(f -> f.getName().equals(fileName)).findAny();
            if (file.isEmpty() || file.get().getData() == null) {
                throw new RuntimeException("FileName mismatch in XML and PDF extracted file");
            }
            byte[] fileBytes = file.get().getData();
            String hashVal = this.grantApplicationHashService.computeAttachmentHash(fileBytes);
            Node hashNode = lstHashValue.item(index);
            NamedNodeMap hashNodeMap = hashNode.getAttributes();
            Text temp = document.createTextNode(hashVal);
            hashNode.appendChild(temp);
            hashNode = hashNodeMap.getNamedItem("glob:hashAlgorithm");
            hashNode.setNodeValue("SHA-1");
            fileNode = lstFileLocation.item(index);
            NamedNodeMap fileNodeMap = fileNode.getAttributes();
            fileNode = fileNodeMap.getNamedItem("att:href");
            String contentId = fileNode.getNodeValue();
            String encodedContentId = this.cleanContentId(contentId);
            fileNode.setNodeValue(encodedContentId);
            Node mimeTypeNode = lstMimeType.item(0);
            String contentType = mimeTypeNode.getFirstChild().getNodeValue();
            BudgetSubAwardAttachment budgetSubAwardAttachmentBean = new BudgetSubAwardAttachment();
            budgetSubAwardAttachmentBean.setData(fileBytes);
            budgetSubAwardAttachmentBean.setName(encodedContentId);
            budgetSubAwardAttachmentBean.setType(contentType);
            budgetSubAwardAttachmentBean.setBudgetSubAward(budgetSubAwardBean);
            attachmentList.add(budgetSubAwardAttachmentBean);
        }
        budgetSubAwardBean.setBudgetSubAwardAttachments(attachmentList);
        Transformer transformer = SafeXmlUtils.safeTransformerFactory().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            StreamResult result = new StreamResult(bos);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            budgetSubAwardBean.setSubAwardXmlFileData(new String(bos.toByteArray()));
        }
    }

    protected String cleanContentId(String contentId) {
        String cleanId = StringUtils.replaceChars((String)contentId, (String)" .%-_", (String)"");
        if (cleanId != null && cleanId.length() <= 50) {
            return cleanId;
        }
        return cleanId.substring(0, 18) + UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public void populateBudgetSubAwardAttachments(Budget budget) {
        List<BudgetSubAwards> subAwards = budget.getBudgetSubAwards();
        for (BudgetSubAwards budgetSubAwards : subAwards) {
            budgetSubAwards.refreshReferenceObject("budgetSubAwardAttachments");
        }
    }

    protected void removeAllEmptyNodes(Document document, String xpath, int parentLevel) throws XPathExpressionException {
        NodeList emptyElements = (NodeList)XPathFactory.newInstance().newXPath().evaluate(xpath, document, XPathConstants.NODESET);
        for (int i = emptyElements.getLength() - 1; i > -1; --i) {
            Node nodeToBeRemoved = emptyElements.item(i);
            int hierLevel = parentLevel;
            while (hierLevel-- > 0) {
                nodeToBeRemoved = nodeToBeRemoved.getParentNode();
            }
            nodeToBeRemoved.getParentNode().removeChild(nodeToBeRemoved);
        }
        NodeList moreEmptyElements = (NodeList)XPathFactory.newInstance().newXPath().evaluate(xpath, document, XPathConstants.NODESET);
        if (moreEmptyElements.getLength() > 0) {
            this.removeAllEmptyNodes(document, xpath, parentLevel);
        }
    }

    protected Element copyElementToName(Element element, String tagName) {
        int i;
        Element newElement = element.getOwnerDocument().createElement(tagName);
        NamedNodeMap attrs = element.getAttributes();
        for (i = 0; i < attrs.getLength(); ++i) {
            Node attribute = attrs.item(i);
            newElement.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
        }
        for (i = 0; i < element.getChildNodes().getLength(); ++i) {
            newElement.appendChild(element.getChildNodes().item(i).cloneNode(true));
        }
        return newElement;
    }

    private void changeDataTypeForNumberOfOtherPersons(Document document) throws XPathExpressionException {
        NodeList otherPesronsCountNodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("//*[local-name(.)='OtherPersonnelTotalNumber']", document, XPathConstants.NODESET);
        for (int i = 0; i < otherPesronsCountNodes.getLength(); ++i) {
            Node countNode = otherPesronsCountNodes.item(i);
            String value = PropDevPropDevBudgetSubAwardServiceImpl.getValue(countNode);
            if (value.isEmpty() || value.indexOf(46) == -1) continue;
            int intVal = Double.valueOf(value).intValue();
            this.setValue(countNode, "" + intVal);
        }
    }

    private void setValue(Node node, String value) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            child.setNodeValue(value);
            break;
        }
    }

    private static String getValue(Node node) {
        String textValue = "";
        if (node != null) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 3) continue;
                textValue = child.getNodeValue();
                break;
            }
        }
        return textValue.trim();
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected BudgetService getBudgetService() {
        return this.budgetService;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public FormMappingService getFormMappingService() {
        return this.formMappingService;
    }

    public void setFormMappingService(FormMappingService formMappingService) {
        this.formMappingService = formMappingService;
    }

    public GrantApplicationHashService getGrantApplicationHashService() {
        return this.grantApplicationHashService;
    }

    public void setGrantApplicationHashService(GrantApplicationHashService grantApplicationHashService) {
        this.grantApplicationHashService = grantApplicationHashService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    public FormUtilityService getFormUtilityService() {
        return this.formUtilityService;
    }

    public void setFormUtilityService(FormUtilityService formUtilityService) {
        this.formUtilityService = formUtilityService;
    }
}

