/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.preproposal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.preproposal.ProposalDevelopmentEvaluator;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ProposalDevelopmentEvaluatorImpl
implements ProposalDevelopmentEvaluator {
    private static final Logger LOG = LogManager.getLogger();
    private transient SpelExpressionParser parser;
    private transient EvaluationContext context;
    private final ProposalDevelopmentDocument document;
    private final Questionnaires questionnaires = new Questionnaires();
    private final String proposalUrl;

    public ProposalDevelopmentEvaluatorImpl(ProposalDevelopmentDocument document, String proposalUrl, Collection<AnswerHeader> answerHeaders) {
        this.document = document;
        this.proposalUrl = proposalUrl;
        answerHeaders.forEach(this.questionnaires::addAnswerHeader);
    }

    @Override
    public boolean isValidKey(String key) {
        return StringUtils.isNotBlank((CharSequence)key) && (key.startsWith("questionnaire") || key.startsWith("proposal"));
    }

    @Override
    public Optional<Object> evaluate(String key) {
        try {
            if ("proposal.url".equals(key)) {
                return Optional.of(this.proposalUrl);
            }
            if (this.isValidKey(key)) {
                Matcher matches = KEY_ROLE_LOOKUP_PATTERN.matcher(key);
                if (matches.find()) {
                    String roleSlug = matches.group(4);
                    String evaluationKey = String.format("%s.%s", matches.group(1), matches.group(3));
                    Expression expression = this.getParser().parseExpression("#" + evaluationKey);
                    return Optional.of(Pair.of((Object)expression.getValue(this.getContext()), (Object)roleSlug));
                }
                Expression expression = this.getParser().parseExpression("#" + key);
                return Optional.ofNullable(expression.getValue(this.getContext()));
            }
        }
        catch (EvaluationException e) {
            LOG.warn(e.getMessage());
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Object> evaluate(String key, Object rootObject) {
        try {
            if ("proposal.url".equals(key)) {
                return Optional.of(this.proposalUrl);
            }
            if (((String)key).startsWith("proposal.") || ((String)key).startsWith("questionnaire.")) {
                key = "#" + (String)key;
            }
            Expression expression = this.getParser().parseExpression((String)key);
            return Optional.ofNullable(expression.getValue(this.getContext(), rootObject));
        }
        catch (EvaluationException e) {
            LOG.warn(e.getMessage());
            LOG.debug(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    protected static QuestionnaireHelper createQuestionnaireHelper(AnswerHeader answerHeader) {
        QuestionnaireHelper questionnaireHelper = new QuestionnaireHelper();
        answerHeader.getAnswers().forEach(questionnaireHelper::addAnswer);
        return questionnaireHelper;
    }

    public EvaluationContext getContext() {
        if (this.context == null) {
            this.context = new StandardEvaluationContext();
            this.context.setVariable("proposal", (Object)this.document.getDevelopmentProposal());
            this.context.setVariable("questionnaire", (Object)this.questionnaires);
        }
        return this.context;
    }

    public SpelExpressionParser getParser() {
        if (this.parser == null) {
            this.parser = new SpelExpressionParser();
        }
        return this.parser;
    }

    public String getProposalUrl() {
        return this.proposalUrl;
    }

    private static class Questionnaires
    implements Serializable {
        private final Map<Integer, QuestionnaireHelper> byId = new HashMap<Integer, QuestionnaireHelper>();
        private final Map<Long, QuestionnaireHelper> byRef = new HashMap<Long, QuestionnaireHelper>();
        private final Map<String, QuestionnaireHelper> byName = new HashMap<String, QuestionnaireHelper>();

        private Questionnaires() {
        }

        public void addAnswerHeader(AnswerHeader answerHeader) {
            QuestionnaireHelper questionnaireHelper = ProposalDevelopmentEvaluatorImpl.createQuestionnaireHelper(answerHeader);
            Questionnaire questionnaire = answerHeader.getQuestionnaire();
            this.byId.put(questionnaire.getQuestionnaireSeqIdAsInteger(), questionnaireHelper);
            this.byRef.put(questionnaire.getQuestionnaireRefIdAsLong(), questionnaireHelper);
            this.byName.put(questionnaire.getName(), questionnaireHelper);
        }

        public Map<Integer, QuestionnaireHelper> getById() {
            return this.byId;
        }

        public Map<Long, QuestionnaireHelper> getByRef() {
            return this.byRef;
        }

        public Map<String, QuestionnaireHelper> getByName() {
            return this.byName;
        }
    }

    private static class QuestionnaireHelper
    implements Serializable {
        private final Map<Integer, QuestionAnswerHelper> question = new HashMap<Integer, QuestionAnswerHelper>();

        private QuestionnaireHelper() {
        }

        public void addAnswer(Answer answer) {
            QuestionAnswerHelper questionAnswerHelper = this.questionAnswerHelperForAnswer(answer);
            questionAnswerHelper.addAnswer(answer);
        }

        private QuestionAnswerHelper questionAnswerHelperForAnswer(Answer answer) {
            Integer key = answer.getQuestion().getQuestionSeqId();
            QuestionAnswerHelper result = this.question.get(key);
            if (result == null) {
                result = new QuestionAnswerHelper();
                this.question.put(key, result);
            }
            return result;
        }

        public Map<Integer, QuestionAnswerHelper> getQuestion() {
            return this.question;
        }
    }

    private static class QuestionAnswerHelper
    implements Serializable {
        private final List<String> answers = new ArrayList<String>();

        private QuestionAnswerHelper() {
        }

        public void addAnswer(Answer questionAnswer) {
            String enteredAnswer;
            String resolvedAnswer = enteredAnswer = questionAnswer.getAnswer();
            if (enteredAnswer != null) {
                Long questionType = questionAnswer.getQuestion().getQuestionTypeId();
                if (questionType == 1L || questionType == 2L) {
                    resolvedAnswer = switch (enteredAnswer) {
                        case "Y" -> "Yes";
                        case "N" -> "No";
                        case "X" -> "N/A";
                        default -> enteredAnswer;
                    };
                }
                this.answers.add(resolvedAnswer);
            }
        }

        public String getAnswer() {
            return this.answers.isEmpty() ? "" : this.answers.get(0);
        }

        public List<String> getAnswers() {
            return this.answers;
        }
    }
}

