/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.pdf.PdfService;
import org.kuali.coeus.common.api.pdf.dto.ActionDto;
import org.kuali.coeus.common.api.pdf.dto.AttachmentDto;
import org.kuali.coeus.common.api.pdf.dto.AttachmentPutActionDto;
import org.kuali.coeus.common.api.pdf.dto.ConcatActionDto;
import org.kuali.coeus.common.api.pdf.dto.JobDto;
import org.kuali.coeus.common.api.pdf.dto.LinkDto;
import org.kuali.coeus.common.api.pdf.dto.MessageDto;
import org.kuali.coeus.common.api.pdf.dto.SingleTargetAction;
import org.kuali.coeus.common.api.pdf.dto.Status;
import org.kuali.coeus.common.api.pdf.dto.TransformXmlActionDto;
import org.kuali.coeus.common.api.pdf.dto.XfaFormFlattenActionDto;
import org.kuali.coeus.common.api.pdf.dto.XfaPutActionDto;
import org.kuali.coeus.propdev.impl.s2s.FormPackageCompilationService;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunityCfda;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.api.print.FormElements;
import org.kuali.coeus.s2sgen.api.print.FormPackage;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.coeus.sys.framework.util.XmlUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component(value="formPackageCompilationService")
public class FormPackageCompilationServiceImpl
implements FormPackageCompilationService {
    private static final Logger LOG = LogManager.getLogger(FormPackageCompilationServiceImpl.class);
    @Autowired
    @Qualifier(value="pdfService")
    private PdfService pdfService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;
    @Autowired
    @Qualifier(value="jwtService")
    private JwtService jwtService;
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public FormPackageCompilationService.FileResult compileFormPackage(S2sOpportunity opp, FormPackage formPackage, FormPackageCompilationService.JobFinalResult jobFinalResult) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            FormPackageCompilationService.FileResult fileResult;
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                StringBuilder manifest = new StringBuilder();
                this.addOppInfoToPackage(opp, manifest);
                this.addInstructionsToPackage(opp, zos, manifest);
                this.addOppSchemaToPackage(opp, zos, manifest);
                this.addOppOverallSchemaToPackage(opp, zos, manifest);
                this.addGrantApplicationToPackage(formPackage.getXmlFile(), zos, manifest);
                this.addEmptyFormsToPackage(formPackage.getFormElements(), zos, manifest);
                this.addFormXmlToPackage(formPackage.getFormElements(), zos, manifest);
                boolean valid = this.addFilledFormsToPackage(jobFinalResult, zos, manifest);
                this.addAttachmentsToPackage(formPackage.getFormElements(), zos, manifest);
                this.addUserTimestampInfoToPackage(this.getGlobalVariableService().getUserSession().getPrincipalName(), this.getDateTimeService().getCurrentTimestamp(), manifest);
                this.addManifestToPackage(zos, manifest);
                baos.flush();
                fileResult = new FormPackageCompilationService.FileResult(valid, baos);
            }
            return fileResult;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new FormPackageCompilationService.FileResult(false, null);
        }
    }

    private void addManifestToPackage(ZipOutputStream zos, StringBuilder manifest) throws IOException {
        ZipEntry mZipEntry = new ZipEntry("manifest.txt");
        zos.putNextEntry(mZipEntry);
        zos.write(manifest.toString().getBytes());
        zos.closeEntry();
        zos.flush();
        zos.finish();
    }

    private void addUserTimestampInfoToPackage(String principalName, Timestamp timestamp, StringBuilder manifest) {
        manifest.append("Generated By: ");
        manifest.append(principalName);
        manifest.append(" at ");
        manifest.append(this.getDateTimeService().toDateTimeString((Date)timestamp));
        manifest.append("\n");
    }

    private void addOppOverallSchemaToPackage(S2sOpportunity opp, ZipOutputStream zos, StringBuilder manifest) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)opp.getOverallSchema()) && StringUtils.isNotBlank((CharSequence)opp.getOverallSchemaUrl())) {
            String name = opp.getSchemaUrl().substring(opp.getOverallSchemaUrl().lastIndexOf(47) + 1);
            byte[] file = opp.getOverallSchema().getBytes();
            manifest.append(String.format("Overall Opportunity Schema (total %s): ", 1));
            manifest.append("\n");
            manifest.append("\n");
            manifest.append(String.format("%s. %s (size %s bytes)", 1, name, file.length));
            manifest.append("\n");
            manifest.append("\n");
            manifest.append("\n");
            ZipEntry oZipEntry = new ZipEntry(name);
            zos.putNextEntry(oZipEntry);
            zos.write(file);
            zos.closeEntry();
        }
    }

    private void addGrantApplicationToPackage(KcFile grantApplication, ZipOutputStream zos, StringBuilder manifest) throws IOException {
        if (grantApplication != null) {
            String name = "GrantApplicationPreview.xml";
            try (ByteArrayInputStream in = new ByteArrayInputStream(grantApplication.getData());
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                XmlUtils.prettyPrint(new StreamSource(in), new StreamResult(out));
                byte[] file = out.toByteArray();
                manifest.append(String.format("Grant Application Preview XML file (total %s): ", 1));
                manifest.append("\n");
                manifest.append("\n");
                manifest.append(String.format("%s. %s (size %s bytes)", 1, "GrantApplicationPreview.xml", file.length));
                manifest.append("\n");
                manifest.append("\n");
                manifest.append("\n");
                ZipEntry oZipEntry = new ZipEntry("GrantApplicationPreview.xml");
                zos.putNextEntry(oZipEntry);
                zos.write(file);
                zos.closeEntry();
            }
            catch (TransformerException e) {
                manifest.append(String.format("There was a problem formatting the following file %s.\n", "GrantApplicationPreview.xml"));
                manifest.append("\n");
                manifest.append("\n");
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addOppSchemaToPackage(S2sOpportunity opp, ZipOutputStream zos, StringBuilder manifest) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)opp.getOpportunity()) && StringUtils.isNotBlank((CharSequence)opp.getSchemaUrl())) {
            String name = opp.getSchemaUrl().substring(opp.getSchemaUrl().lastIndexOf(47) + 1);
            byte[] file = opp.getOpportunity().getBytes();
            manifest.append(String.format("Opportunity Schema (total %s): ", 1));
            manifest.append("\n");
            manifest.append("\n");
            manifest.append(String.format("%s. %s (size %s bytes)", 1, name, file.length));
            manifest.append("\n");
            manifest.append("\n");
            manifest.append("\n");
            ZipEntry oZipEntry = new ZipEntry(name);
            zos.putNextEntry(oZipEntry);
            zos.write(file);
            zos.closeEntry();
        }
    }

    private void addInstructionsToPackage(S2sOpportunity opp, ZipOutputStream zos, StringBuilder manifest) {
        if (StringUtils.isNotBlank((CharSequence)opp.getInstructionUrl())) {
            try {
                URL instructionUrl = new URL(opp.getInstructionUrl());
                String nameWithPath = instructionUrl.getFile().endsWith("/") ? instructionUrl.getFile().substring(0, instructionUrl.getFile().length() - 1) : instructionUrl.getFile();
                String name = nameWithPath.contains("/") ? nameWithPath.substring(nameWithPath.lastIndexOf(47) + 1) : nameWithPath;
                try (InputStream in = instructionUrl.openStream();){
                    byte[] file = in.readAllBytes();
                    manifest.append(String.format("Opportunity Instructions (total %s): ", 1));
                    manifest.append("\n");
                    manifest.append("\n");
                    manifest.append(String.format("%s. %s (size %s bytes)", 1, name, file.length));
                    manifest.append("\n");
                    manifest.append("\n");
                    ZipEntry oZipEntry = new ZipEntry(name);
                    zos.putNextEntry(oZipEntry);
                    zos.write(file);
                    zos.closeEntry();
                }
            }
            catch (Throwable e) {
                LOG.warn("Unable to fetch opportunity instructions", e);
            }
            manifest.append("\n");
        }
    }

    private void addAttachmentsToPackage(List<FormElements> formElements, ZipOutputStream zos, StringBuilder manifest) throws IOException {
        manifest.append(String.format("Attachments Included in Zip File (total %s): ", formElements.stream().map(s -> {
            if (s.getPdfElements() != null) {
                return s.getPdfElements().getAttachments().size();
            }
            if (s.getStylesheetElements() != null) {
                return s.getStylesheetElements().getAttachments().size();
            }
            return 0;
        }).mapToInt(Integer::intValue).sum()));
        manifest.append("\n");
        manifest.append("\n");
        int fcnt = 1;
        for (FormElements e : formElements) {
            List<Object> attachments = e.getPdfElements() != null ? e.getPdfElements().getAttachments().values() : (e.getStylesheetElements() != null ? e.getStylesheetElements().getAttachments() : Collections.emptyList());
            for (AttachmentData attachmentData : attachments) {
                String name = this.getFormNameFromNamespace(e.getNamespace()) + "-" + attachmentData.getFileName();
                byte[] file = attachmentData.getContent();
                manifest.append(String.format("%s. %s (size %s bytes)", fcnt, this.getFormNameFromNamespace(e.getNamespace()) + " " + name + " " + attachmentData.getContentType(), attachmentData.getContent().length));
                manifest.append("\n");
                manifest.append("\n");
                ZipEntry zipEntry = new ZipEntry(name);
                zos.putNextEntry(zipEntry);
                zos.write(file);
                zos.closeEntry();
                ++fcnt;
            }
        }
        manifest.append("\n");
    }

    private boolean addFilledFormsToPackage(FormPackageCompilationService.JobFinalResult jobFinalResult, ZipOutputStream zos, StringBuilder manifest) throws IOException {
        if (jobFinalResult.valid()) {
            manifest.append(String.format("Forms Included in Zip File (total %s): ", jobFinalResult.files().size()));
            manifest.append("\n");
            manifest.append("\n");
            int ffcnt = 1;
            for (FormPackageCompilationService.JobFile file : jobFinalResult.files()) {
                if (file.valid()) {
                    manifest.append(String.format("%s. %s (size %s bytes)", ffcnt, file.fileName(), file.data().length));
                    manifest.append("\n");
                    manifest.append("\n");
                    ZipEntry zipEntry = new ZipEntry(file.fileName());
                    zos.putNextEntry(zipEntry);
                    zos.write(file.data());
                    zos.closeEntry();
                    ++ffcnt;
                    continue;
                }
                LOG.error("failed to created filled forms (file invalid), jobId: " + jobFinalResult.jobId() + " errors: " + String.valueOf(file.errors()));
                manifest.append(String.format("%s. There was a problem getting the filled form for %s from the PDF Service.\n", ffcnt, file.fileName()));
                if (file.errors().size() > 0) {
                    manifest.append("\tErrors:\n");
                    manifest.append(String.join((CharSequence)"\t\t\n", file.errors()));
                }
                manifest.append("\n");
                manifest.append("\n");
            }
        } else {
            LOG.error("failed to created filled forms (job invalid), jobId: " + jobFinalResult.jobId() + " errors: " + String.valueOf(jobFinalResult.errors()));
            manifest.append("There was a problem getting filled forms from the PDF Service.\n");
            if (jobFinalResult.errors().size() > 0) {
                manifest.append("\tErrors:\n");
                manifest.append(String.join((CharSequence)"\t\t\n", jobFinalResult.errors()));
            }
            manifest.append("\n");
            manifest.append("\n");
        }
        manifest.append("\n");
        return jobFinalResult.valid();
    }

    private void addFormXmlToPackage(List<FormElements> formElements, ZipOutputStream zos, StringBuilder manifest) throws IOException {
        manifest.append(String.format("Form XML Included in Zip File (total %s): ", formElements.size()));
        manifest.append("\n");
        manifest.append("\n");
        int fcnt = 1;
        for (FormElements e : formElements) {
            String name = "Form " + this.getFormNameFromNamespace(e.getNamespace()) + ".xml";
            try (ByteArrayInputStream in = new ByteArrayInputStream(e.getXmlFile().getData());
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                XmlUtils.prettyPrint(new StreamSource(in), new StreamResult(out));
                byte[] file = out.toByteArray();
                manifest.append(String.format("%s. %s (size %s bytes)", fcnt, name, file.length));
                manifest.append("\n");
                manifest.append("\n");
                ZipEntry zipEntry = new ZipEntry(name);
                zos.putNextEntry(zipEntry);
                zos.write(file);
                zos.closeEntry();
                ++fcnt;
            }
            catch (TransformerException ex) {
                manifest.append(String.format("There was a problem formatting the following file %s.\n", name));
                manifest.append("\n");
                manifest.append("\n");
                LOG.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        manifest.append("\n");
    }

    private void addEmptyFormsToPackage(List<FormElements> formElements, ZipOutputStream zos, StringBuilder manifest) throws IOException {
        manifest.append(String.format("Empty Forms Included in Zip File (total %s): ", formElements.stream().filter(e -> e.getPdfElements() != null).count()));
        manifest.append("\n");
        manifest.append("\n");
        int fcnt = 1;
        for (FormElements e2 : formElements) {
            if (e2.getPdfElements() == null) continue;
            String name = "Form " + this.getFormNameFromNamespace(e2.getNamespace()) + " Empty.pdf";
            byte[] file = e2.getPdfElements().getPdfFile().getData();
            manifest.append(String.format("%s. %s (size %s bytes)", fcnt, name, file.length));
            manifest.append("\n");
            manifest.append("\n");
            ZipEntry zipEntry = new ZipEntry(name);
            zos.putNextEntry(zipEntry);
            zos.write(file);
            zos.closeEntry();
            ++fcnt;
        }
        manifest.append("\n");
    }

    private void addOppInfoToPackage(S2sOpportunity opp, StringBuilder manifest) {
        manifest.append("Manifest for Grant Submission Package Preview");
        manifest.append("\n");
        manifest.append("\n");
        manifest.append("Proposal Number: ");
        manifest.append(opp.getProposalNumber());
        manifest.append("\n");
        if (opp.getOpeningDate() != null) {
            manifest.append("Opening Date: ");
            manifest.append(this.getDateTimeService().toDateTimeString(opp.getOpeningDate().getTime()));
            manifest.append("\n");
        }
        if (opp.getClosingDate() != null) {
            manifest.append("Closing Date: ");
            manifest.append(this.getDateTimeService().toDateTimeString(opp.getClosingDate().getTime()));
            manifest.append("\n");
        }
        manifest.append("Competition Id: ");
        manifest.append(StringUtils.defaultString((String)opp.getCompetitionId()));
        manifest.append("\n");
        manifest.append("Competition Title: ");
        manifest.append(StringUtils.defaultString((String)opp.getCompetitionTitle()));
        manifest.append("\n");
        manifest.append("Package Id: ");
        manifest.append(StringUtils.defaultString((String)opp.getPackageId()));
        manifest.append("\n");
        manifest.append("Instruction Url: ");
        manifest.append(StringUtils.defaultString((String)opp.getInstructionUrl()));
        manifest.append("\n");
        manifest.append("Opportunity Id: ");
        manifest.append(StringUtils.defaultString((String)opp.getOpportunityId()));
        manifest.append("\n");
        manifest.append("Opportunity Title: ");
        manifest.append(StringUtils.defaultString((String)opp.getOpportunityTitle()));
        manifest.append("\n");
        manifest.append("CFDA Numbers: ");
        manifest.append(opp.getS2sOpportunityCfdas().stream().map(S2sOpportunityCfda::getCfdaNumber).collect(Collectors.joining(", ")));
        manifest.append("\n");
        if (opp.getS2sRevisionType() != null) {
            manifest.append("Revision Type: ");
            manifest.append(opp.getS2sRevisionType().getCode());
            manifest.append(" - ");
            manifest.append(StringUtils.defaultString((String)opp.getS2sRevisionType().getDescription()));
            manifest.append("\n");
        }
        manifest.append("Revision Other Description: ");
        manifest.append(StringUtils.defaultString((String)opp.getRevisionOtherDescription()));
        manifest.append("\n");
        if (opp.getS2sSubmissionType() != null) {
            manifest.append("Submission Type: ");
            manifest.append(opp.getS2sSubmissionType().getCode());
            manifest.append(" - ");
            manifest.append(StringUtils.defaultString((String)opp.getS2sSubmissionType().getDescription()));
            manifest.append("\n");
        }
        manifest.append("Schema Url: ");
        manifest.append(StringUtils.defaultString((String)opp.getSchemaUrl()));
        manifest.append("\n");
        manifest.append("Offering Agency: ");
        manifest.append(StringUtils.defaultString((String)opp.getOfferingAgency()));
        manifest.append("\n");
        manifest.append("Agency Contact Information: ");
        manifest.append(StringUtils.defaultString((String)opp.getAgencyContactInfo()));
        manifest.append("\n");
        if (opp.isMultiProject()) {
            manifest.append("Multi Project: ");
            manifest.append(opp.isMultiProject());
            manifest.append("\n");
            manifest.append("Component Type: ");
            manifest.append(StringUtils.defaultString((String)opp.getComponentType()));
            manifest.append("\n");
            manifest.append("Overall Schema Url: ");
            manifest.append(StringUtils.defaultString((String)opp.getOverallSchemaUrl()));
            manifest.append("\n");
        }
        manifest.append("\n");
        manifest.append("\n");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FormPackageCompilationService.FileResult compileFlattenedForms(FormPackageCompilationService.JobFinalResult jobFinalResult) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            FormPackageCompilationService.JobFile file;
            if (!jobFinalResult.valid()) {
                LOG.error("failed to created flattened forms (job invalid), jobId: " + jobFinalResult.jobId() + " errors: " + String.valueOf(jobFinalResult.errors()));
            }
            if (jobFinalResult.files() != null && jobFinalResult.files().size() > 0 && (file = jobFinalResult.files().get(0)) != null) {
                if (!file.valid()) {
                    LOG.error("failed to created flattened forms (file invalid), jobId: " + jobFinalResult.jobId() + " errors: " + String.valueOf(file.errors()));
                }
                baos.writeBytes(file.data());
                baos.flush();
                FormPackageCompilationService.FileResult fileResult = new FormPackageCompilationService.FileResult(file.valid(), baos);
                return fileResult;
            }
            FormPackageCompilationService.FileResult fileResult = new FormPackageCompilationService.FileResult(false, null);
            return fileResult;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new FormPackageCompilationService.FileResult(false, null);
        }
    }

    @Override
    public FormPackageCompilationService.JobExecResult execFlattenFormsJob(List<FormElements> formElements) {
        HttpHeaders headers = this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser();
        ArrayList<LinkDto> toConcat = new ArrayList<LinkDto>();
        ArrayList formActions = new ArrayList();
        for (FormElements e : formElements) {
            if (e.getPdfElements() != null) {
                String putActionId = "xfaPut_" + this.getFormNameFromNamespace(e.getNamespace());
                XfaPutActionDto putAction = new XfaPutActionDto().xfaData(new String(e.getXmlFile().getData(), StandardCharsets.UTF_8)).source(new LinkDto().url(this.getPdfUrl(e.getPdfElements().getPdfFile().getName(), e.getNamespace())).method(HttpMethod.GET.name()).headers((Map<String, List<String>>)headers)).actionId(putActionId);
                if (MapUtils.isNotEmpty((Map)e.getPdfElements().getAttachments())) {
                    Map<String, AttachmentDto> attachmentActions = e.getPdfElements().getAttachments().entrySet().stream().map(ae -> {
                        AttachmentData ad = (AttachmentData)ae.getValue();
                        return CollectionUtils.entry((String)ae.getKey(), new AttachmentDto().location(new LinkDto().url(this.getAttachmentUrl(ad.getFileDataId())).method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken())).fileDisplay(ad.getFileName()).mimeType(ad.getContentType()).embedded(true).modDate(ad.getUploadTimestamp() != null ? ad.getUploadTimestamp().toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : null));
                    }).collect(CollectionUtils.entriesToMap());
                    String attPutActionId = "attPut_" + this.getFormNameFromNamespace(e.getNamespace());
                    String xfaFormFlattenActionId = "xfaFormFlatten_" + this.getFormNameFromNamespace(e.getNamespace());
                    toConcat.add(new LinkDto().url("action://{$jobId}/" + xfaFormFlattenActionId + "/0"));
                    toConcat.addAll(attachmentActions.values().stream().map(AttachmentDto::getLocation).toList());
                    formActions.add(putAction);
                    formActions.add(new AttachmentPutActionDto().attachments(attachmentActions).source(new LinkDto().url("action://{$jobId}/" + putActionId + "/0")).actionId(attPutActionId));
                    formActions.add(new XfaFormFlattenActionDto().source(new LinkDto().url("action://{$jobId}/" + attPutActionId + "/0")).actionId(xfaFormFlattenActionId));
                    continue;
                }
                String xfaFormFlattenActionId = "xfaFormFlatten_" + this.getFormNameFromNamespace(e.getNamespace());
                toConcat.add(new LinkDto().url("action://{$jobId}/" + xfaFormFlattenActionId + "/0"));
                formActions.add(putAction);
                formActions.add(new XfaFormFlattenActionDto().source(new LinkDto().url("action://{$jobId}/" + putActionId + "/0")).actionId(xfaFormFlattenActionId));
                continue;
            }
            if (e.getStylesheetElements() == null || e.getStylesheetElements().getStylesheets() == null) continue;
            String formName = this.getFormNameFromNamespace(e.getNamespace());
            String xmlData = new String(e.getXmlFile().getData(), StandardCharsets.UTF_8);
            String baseUri = this.configurationService.getPropertyValueAsString("application.url");
            List transformActions = IntStream.range(0, e.getStylesheetElements().getStylesheets().size()).mapToObj(i -> {
                String transformActionId = "transformXml_" + i + "_" + formName;
                return new TransformXmlActionDto().xmlData(xmlData).baseUri(baseUri).source(new LinkDto().url(this.getStylesheetUrl(((KcFile)e.getStylesheetElements().getStylesheets().get(i)).getName())).method(HttpMethod.GET.name()).headers((Map<String, List<String>>)headers)).actionId(transformActionId);
            }).collect(Collectors.toList());
            toConcat.addAll(transformActions.stream().map(a -> new LinkDto().url("action://{$jobId}/" + a.getActionId() + "/0")).toList());
            if (e.getStylesheetElements().getAttachments() != null) {
                toConcat.addAll(e.getStylesheetElements().getAttachments().stream().map(ad -> new LinkDto().url(this.getAttachmentUrl(ad.getFileDataId())).method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken())).toList());
            }
            formActions.addAll(transformActions);
        }
        ArrayList allActions = formActions.size() == 1 ? formActions : Stream.concat(formActions.stream(), Stream.of(new ConcatActionDto().actionId("concat").source(toConcat))).collect(Collectors.toList());
        String lastActionId = ((ActionDto)Iterables.getLast(allActions)).getActionId();
        JobDto job = new JobDto().actions(allActions);
        String jobId = this.getPdfService().submitJob(job);
        return new FormPackageCompilationService.JobExecResult(jobId, Map.of(lastActionId, "flattened_forms.pdf"));
    }

    @Override
    public FormPackageCompilationService.JobExecResult execfillFormsJob(List<FormElements> formElements) {
        HttpHeaders headers = this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser();
        List<List> formActions = formElements.stream().map(e -> {
            if (e.getPdfElements() != null) {
                String putActionId = "xfaPut_" + this.getFormNameFromNamespace(e.getNamespace());
                XfaPutActionDto putAction = new XfaPutActionDto().xfaData(new String(e.getXmlFile().getData(), StandardCharsets.UTF_8)).source(new LinkDto().url(this.getPdfUrl(e.getPdfElements().getPdfFile().getName(), e.getNamespace())).method(HttpMethod.GET.name()).headers((Map<String, List<String>>)headers)).actionId(putActionId);
                if (MapUtils.isNotEmpty((Map)e.getPdfElements().getAttachments())) {
                    Map<String, AttachmentDto> attachmentActions = e.getPdfElements().getAttachments().entrySet().stream().map(ae -> {
                        AttachmentData ad = (AttachmentData)ae.getValue();
                        return CollectionUtils.entry((String)ae.getKey(), new AttachmentDto().location(new LinkDto().url(this.getAttachmentUrl(ad.getFileDataId())).method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken())).fileDisplay(ad.getFileName()).mimeType(ad.getContentType()).embedded(true).modDate(ad.getUploadTimestamp() != null ? ad.getUploadTimestamp().toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : null));
                    }).collect(CollectionUtils.entriesToMap());
                    return List.of(putAction, new AttachmentPutActionDto().attachments(attachmentActions).source(new LinkDto().url("action://{$jobId}/" + putActionId + "/0")).actionId("attPut_" + this.getFormNameFromNamespace(e.getNamespace())));
                }
                return List.of(putAction);
            }
            if (e.getStylesheetElements() != null && e.getStylesheetElements().getStylesheets() != null) {
                String formName = this.getFormNameFromNamespace(e.getNamespace());
                String xmlData = new String(e.getXmlFile().getData(), StandardCharsets.UTF_8);
                String baseUri = this.configurationService.getPropertyValueAsString("application.url");
                List transformActions = IntStream.range(0, e.getStylesheetElements().getStylesheets().size()).mapToObj(i -> {
                    String transformActionId = "transformXml_" + i + "_" + formName;
                    return new TransformXmlActionDto().xmlData(xmlData).baseUri(baseUri).source(new LinkDto().url(this.getStylesheetUrl(((KcFile)e.getStylesheetElements().getStylesheets().get(i)).getName())).method(HttpMethod.GET.name()).headers((Map<String, List<String>>)headers)).actionId(transformActionId);
                }).collect(Collectors.toList());
                ConcatActionDto concatAction = new ConcatActionDto().actionId("concat_" + formName).source(transformActions.stream().map(a -> new LinkDto().url("action://{$jobId}/" + a.getActionId() + "/0")).collect(Collectors.toList()));
                return Stream.concat(transformActions.stream(), Stream.of(concatAction)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }).toList();
        Map<String, String> finalResultActionIds = formActions.stream().map(Iterables::getLast).map(ActionDto::getActionId).map(actionId -> CollectionUtils.entry(actionId, "Form " + actionId.substring(actionId.indexOf(95) + 1) + ".pdf")).collect(CollectionUtils.entriesToMap());
        JobDto job = new JobDto().actions(formActions.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        String jobId = this.getPdfService().submitJob(job);
        return new FormPackageCompilationService.JobExecResult(jobId, finalResultActionIds);
    }

    @Override
    public Optional<FormPackageCompilationService.JobFinalResult> checkFinalResult(FormPackageCompilationService.JobExecResult jobExecResult) {
        List<FormPackageCompilationService.JobFile> filledForms;
        Status status = this.getPdfService().getJobStatus(jobExecResult.jobId());
        if (!this.getPdfService().terminalStatuses().contains((Object)status)) {
            return Optional.empty();
        }
        JobDto terminalJob = this.getPdfService().getJob(jobExecResult.jobId());
        if (terminalJob.getStatus().equals((Object)Status.SUCCESS)) {
            filledForms = terminalJob.getActions().stream().filter(a -> jobExecResult.finalActionIdToFileName().containsKey(a.getActionId())).map(a -> {
                byte[] fileData = null;
                if (a.getStatus().equals((Object)Status.SUCCESS)) {
                    try {
                        fileData = IOUtils.toByteArray((URL)new URL(((SingleTargetAction)((Object)a)).getTarget().getUrl()));
                    }
                    catch (IOException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                return new FormPackageCompilationService.JobFile(jobExecResult.finalActionIdToFileName().get(a.getActionId()), fileData, a.getStatus().equals((Object)Status.SUCCESS), a.getMessages().stream().filter(MessageDto::isError).map(MessageDto::getMessage).collect(Collectors.toList()));
            }).collect(Collectors.toList());
        } else {
            filledForms = Collections.emptyList();
            LOG.error((Object)terminalJob);
        }
        return Optional.of(new FormPackageCompilationService.JobFinalResult(terminalJob.getJobId(), filledForms, terminalJob.getStatus().equals((Object)Status.SUCCESS), terminalJob.getMessages().stream().filter(MessageDto::isError).map(MessageDto::getMessage).collect(Collectors.toList())));
    }

    private String getAuthToken() {
        return "Bearer " + this.getJwtService().createToken();
    }

    private String getPdfUrl(String filename, String namespace) {
        return this.pdfKualiHosted(filename) ? this.getConfigurationService().getPropertyValueAsString("application.url") + "/propdev/api/v1/static/org/kuali/coeus/s2sgen/impl/generate/support/pdf/" + filename : "https://apply07.grants.gov/apply/forms/sample/" + namespace.substring(namespace.lastIndexOf("/") + 1) + ".pdf";
    }

    private boolean pdfKualiHosted(String filename) {
        return new ClassPathResource("org/kuali/coeus/s2sgen/impl/generate/support/pdf/" + filename).exists();
    }

    private String getStylesheetUrl(String filename) {
        return this.getConfigurationService().getPropertyValueAsString("application.url") + "/propdev/api/v1/static/org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/" + filename;
    }

    private String getAttachmentUrl(String fileDataId) {
        return this.getConfigurationService().getPropertyValueAsString("application.url") + "/research-common/api/v1/file-data/" + fileDataId;
    }

    private String getFormNameFromNamespace(String namespace) {
        return namespace.substring(namespace.lastIndexOf(47) + 1);
    }

    public PdfService getPdfService() {
        return this.pdfService;
    }

    public void setPdfService(PdfService pdfService) {
        this.pdfService = pdfService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

