/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.s2s.FormUtilityService;
import org.kuali.coeus.propdev.impl.s2s.S2sFileDto;
import org.kuali.coeus.propdev.impl.s2s.UserAttachedFormsXMLReorder;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(value="formUtilityService")
public class FormUtilityServiceImpl
implements FormUtilityService {
    private static final Logger LOG = LogManager.getLogger(FormUtilityServiceImpl.class);
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="grantApplicationHashService")
    private GrantApplicationHashService grantApplicationHashService;

    @Override
    public List<KcFile> extractAttachments(PdfReader reader) {
        PdfDictionary embFiles;
        ArrayList<KcFile> files = new ArrayList<KcFile>();
        PdfDictionary catalog = reader.getCatalog();
        PdfDictionary names = (PdfDictionary)PdfReader.getPdfObject((PdfObject)catalog.get(PdfName.NAMES));
        if (names != null && (embFiles = (PdfDictionary)PdfReader.getPdfObject((PdfObject)names.get(PdfName.EMBEDDEDFILES))) != null) {
            HashMap embMap = PdfNameTree.readTree((PdfDictionary)embFiles);
            files.addAll(embMap.values().stream().map(o -> (PdfDictionary)PdfReader.getPdfObject((PdfObject)o)).map(this::unpackFile).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        for (int k = 1; k <= reader.getNumberOfPages(); ++k) {
            PdfArray annots = (PdfArray)PdfReader.getPdfObject((PdfObject)reader.getPageN(k).get(PdfName.ANNOTS));
            if (annots == null) continue;
            files.addAll(CollectionUtils.asStream(annots.listIterator()).map(i -> (PdfDictionary)PdfReader.getPdfObject((PdfObject)i)).filter(annot -> PdfName.FILEATTACHMENT.equals((Object)PdfReader.getPdfObject((PdfObject)annot.get(PdfName.SUBTYPE)))).map(annot -> (PdfDictionary)PdfReader.getPdfObject((PdfObject)annot.get(PdfName.FS))).map(this::unpackFile).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return files;
    }

    private KcFile unpackFile(PdfDictionary filespec) {
        if (filespec == null) {
            return null;
        }
        PdfName type = (PdfName)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.TYPE));
        if (!PdfName.F.equals((Object)type) && !PdfName.FILESPEC.equals((Object)type)) {
            return null;
        }
        PdfDictionary ef = (PdfDictionary)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.EF));
        if (ef == null) {
            return null;
        }
        PdfString fn = (PdfString)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.F));
        if (fn == null) {
            return null;
        }
        PdfString st = (PdfString)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.SUBTYPE));
        File fLast = new File(fn.toUnicodeString());
        PRStream prs = (PRStream)PdfReader.getPdfObject((PdfObject)ef.get(PdfName.F));
        if (prs == null) {
            return null;
        }
        try {
            return new S2sFileDto(fLast.getName(), st != null ? st.toUnicodeString() : "application/octet-stream", PdfReader.getStreamBytes((PRStream)prs));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Document node2Dom(Node n) throws TransformerException {
        TransformerFactory tf = SafeXmlUtils.safeTransformerFactory();
        Transformer xf = tf.newTransformer();
        DOMResult dr = new DOMResult();
        xf.transform(new DOMSource(n), dr);
        return (Document)dr.getNode();
    }

    @Override
    public void reorderXmlElements(Document doc) {
        List userAttachedFormsXmlReorders = this.getBusinessObjectService().findAll(UserAttachedFormsXMLReorder.class);
        if (userAttachedFormsXmlReorders != null) {
            userAttachedFormsXmlReorders.forEach(userAttachedFormsXMLReorder -> {
                try {
                    this.reorderXmlElement(doc, userAttachedFormsXMLReorder.getNodeToMove(), userAttachedFormsXMLReorder.getTargetNode(), userAttachedFormsXMLReorder.isMoveAfter());
                }
                catch (Exception e) {
                    LOG.error("Could not move XML node " + userAttachedFormsXMLReorder.getNodeToMove() + "next to " + userAttachedFormsXMLReorder.getTargetNode(), (Throwable)e);
                }
            });
        }
    }

    protected void reorderXmlElement(Document doc, String original, String target, boolean insertAfter) {
        NodeList originalNodes = doc.getElementsByTagName(original);
        if (originalNodes != null && originalNodes.getLength() > 0) {
            Node originalNode = originalNodes.item(0);
            NodeList targetNodes = doc.getElementsByTagName(target);
            if (targetNodes != null && targetNodes.getLength() > 0) {
                if (insertAfter) {
                    this.moveNode(originalNode, targetNodes.item(0).getNextSibling());
                } else {
                    this.moveNode(originalNode, targetNodes.item(0));
                }
            }
        }
    }

    private void moveNode(Node original, Node target) {
        Node copy = original.cloneNode(true);
        Node parent = target.getParentNode();
        parent.insertBefore(copy, target);
        parent.removeChild(original);
    }

    @Override
    public void removeAllEmptyNodes(Document document, String xpath, int parentLevel) throws XPathExpressionException {
        NodeList emptyElements = (NodeList)XPathFactory.newInstance().newXPath().evaluate(xpath, document, XPathConstants.NODESET);
        for (int i = emptyElements.getLength() - 1; i > -1; --i) {
            Node nodeToBeRemoved = emptyElements.item(i);
            int hierLevel = parentLevel;
            while (hierLevel-- > 0) {
                nodeToBeRemoved = nodeToBeRemoved.getParentNode();
            }
            nodeToBeRemoved.getParentNode().removeChild(nodeToBeRemoved);
        }
        NodeList moreEmptyElements = (NodeList)XPathFactory.newInstance().newXPath().evaluate(xpath, document, XPathConstants.NODESET);
        if (moreEmptyElements.getLength() > 0) {
            this.removeAllEmptyNodes(document, xpath, parentLevel);
        }
    }

    @Override
    public void correctAttachmentXml(Document document, List<KcFile> atts) {
        NodeList fileNames;
        NodeList attachments = document.getElementsByTagNameNS("http://apply.grants.gov/system/Attachments-V1.0", "AttachedFile");
        if (attachments != null) {
            for (int i = 0; i < attachments.getLength(); ++i) {
                Node attachment = attachments.item(i);
                this.correctAttachmentXml(document, attachment, atts);
            }
        }
        if ((fileNames = document.getElementsByTagNameNS("http://apply.grants.gov/system/Attachments-V1.0", "FileName")) != null) {
            for (int i = 0; i < fileNames.getLength(); ++i) {
                Node fileName = fileNames.item(i);
                Node attachment = fileName.getParentNode();
                this.correctAttachmentXml(document, attachment, atts);
            }
        }
    }

    protected void correctAttachmentXml(Document document, Node attachment, List<KcFile> atts) {
        NodeList attachmentElements;
        if (attachment != null && (attachmentElements = attachment.getChildNodes()) != null) {
            Attr hashAlgorithm;
            String mime;
            Node fileName = null;
            Node fileLocation = null;
            Node hashValue = null;
            Node mimeType = null;
            for (int j = 0; j < attachmentElements.getLength(); ++j) {
                Node node = attachmentElements.item(j);
                if ("FileName".equals(node.getLocalName()) && "http://apply.grants.gov/system/Attachments-V1.0".equals(node.getNamespaceURI())) {
                    fileName = node;
                    continue;
                }
                if ("FileLocation".equals(node.getLocalName()) && "http://apply.grants.gov/system/Attachments-V1.0".equals(node.getNamespaceURI())) {
                    fileLocation = node;
                    continue;
                }
                if ("MimeType".equals(node.getLocalName()) && "http://apply.grants.gov/system/Attachments-V1.0".equals(node.getNamespaceURI())) {
                    mimeType = node;
                    continue;
                }
                if (!"HashValue".equals(node.getLocalName()) || !"http://apply.grants.gov/system/Global-V1.0".equals(node.getNamespaceURI())) continue;
                hashValue = node;
            }
            if (fileLocation == null) {
                fileLocation = document.createElementNS("http://apply.grants.gov/system/Attachments-V1.0", "FileLocation");
                attachment.appendChild(fileLocation);
            }
            if (fileName != null) {
                Attr href = (Attr)fileLocation.getAttributes().getNamedItemNS("http://apply.grants.gov/system/Attachments-V1.0", "href");
                if (href == null) {
                    Attr newHref = document.createAttributeNS("http://apply.grants.gov/system/Attachments-V1.0", "href");
                    newHref.setValue(fileName.getTextContent());
                    ((Element)fileLocation).setAttributeNode(newHref);
                } else if (!StringUtils.equals((CharSequence)fileName.getTextContent(), (CharSequence)href.getTextContent())) {
                    href.setValue(fileName.getTextContent());
                }
            }
            if (mimeType == null) {
                mimeType = document.createElementNS("http://apply.grants.gov/system/Attachments-V1.0", "MimeType");
                attachment.appendChild(mimeType);
            }
            if (StringUtils.isBlank((CharSequence)(mime = mimeType.getTextContent())) && fileName != null && StringUtils.isNotBlank((CharSequence)fileName.getTextContent())) {
                Node name = fileName;
                Optional<KcFile> file = atts.stream().filter(a -> a.getName().equals(name.getTextContent())).findFirst();
                if (file.isPresent()) {
                    mimeType.setTextContent(file.get().getType());
                }
            }
            if (hashValue == null) {
                hashValue = document.createElementNS("http://apply.grants.gov/system/Global-V1.0", "HashValue");
                attachment.appendChild(hashValue);
            }
            if ((hashAlgorithm = (Attr)hashValue.getAttributes().getNamedItemNS("http://apply.grants.gov/system/Global-V1.0", "hashAlgorithm")) == null) {
                Attr newHashAlgorithm = document.createAttributeNS("http://apply.grants.gov/system/Global-V1.0", "hashAlgorithm");
                newHashAlgorithm.setValue("SHA-1");
                ((Element)hashValue).setAttributeNode(newHashAlgorithm);
            } else if (StringUtils.isBlank((CharSequence)hashAlgorithm.getValue())) {
                hashAlgorithm.setValue("SHA-1");
            }
            String hash = hashValue.getTextContent();
            if (StringUtils.isBlank((CharSequence)hash) && fileName != null && StringUtils.isNotBlank((CharSequence)fileName.getTextContent())) {
                Node name = fileName;
                Optional<KcFile> file = atts.stream().filter(a -> a.getName().equals(name.getTextContent())).findFirst();
                if (file.isPresent()) {
                    hashValue.setTextContent(this.getGrantApplicationHashService().computeAttachmentHash(file.get().getData()));
                }
            }
        }
    }

    @Override
    public String docToString(Document node) throws TransformerException {
        DOMSource domSource = new DOMSource(node);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = SafeXmlUtils.safeTransformerFactory();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }

    @Override
    public DocumentBuilder createDomBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory domParserFactory = SafeXmlUtils.safeDocumentBuilderFactory();
        domParserFactory.setNamespaceAware(true);
        DocumentBuilder domParser = domParserFactory.newDocumentBuilder();
        domParserFactory.setIgnoringElementContentWhitespace(true);
        return domParser;
    }

    @Override
    public Node getHashValueFromParent(Node parent) {
        NodeList childElements = parent.getChildNodes();
        for (int j = 0; j < childElements.getLength(); ++j) {
            Node childElement = childElements.item(j);
            if (!"HashValue".equals(childElement.getLocalName()) || !"http://apply.grants.gov/system/Global-V1.0".equals(childElement.getNamespaceURI())) continue;
            return childElement;
        }
        return null;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public GrantApplicationHashService getGrantApplicationHashService() {
        return this.grantApplicationHashService;
    }

    public void setGrantApplicationHashService(GrantApplicationHashService grantApplicationHashService) {
        this.grantApplicationHashService = grantApplicationHashService;
    }
}

