/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDaoConversion;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class S2sUserAttachedFormAttFileDaoConversionImpl
extends QuartzJobBean
implements KcAttachmentDataDaoConversion {
    private static final Logger LOG = LogManager.getLogger(S2sUserAttachedFormAttFileDaoConversionImpl.class);
    private KcAttachmentDataDao kcAttachmentDataDao;
    private DataSource dataSource;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeInternal(JobExecutionContext context) throws JobExecutionException {
        LOG.info("Starting S2sUserAttachedFormAttFile conversion job");
        boolean hasResults = true;
        while (true) {
            if (!hasResults) {
                LOG.info("Finishing S2sUserAttachedFormAttFile conversion job");
                return;
            }
            try {
                Connection conn = this.dataSource.getConnection();
                try {
                    PreparedStatement queryStmt = conn.prepareStatement("select S2S_USER_ATTD_FORM_ATT_FILE_ID, S2S_USER_ATTACHED_FORM_ATT_ID, ATTACHMENT from S2S_USER_ATTD_FORM_ATT_FILE where ATTACHMENT is not null limit 1");
                    try {
                        PreparedStatement updateStmt = conn.prepareStatement("update S2S_USER_ATTACHED_FORM_ATT set FILE_DATA_ID = ? where S2S_USER_ATTACHED_FORM_ATT_ID = ?");
                        try {
                            PreparedStatement deleteStmt = conn.prepareStatement("delete from S2S_USER_ATTD_FORM_ATT_FILE where S2S_USER_ATTD_FORM_ATT_FILE_ID = ?");
                            try {
                                conn.setAutoCommit(false);
                                hasResults = true;
                                Long attId = null;
                                String fileDataId = null;
                                Long attFileId = null;
                                try (ResultSet rs = queryStmt.executeQuery();){
                                    if (rs.next()) {
                                        attFileId = rs.getLong("S2S_USER_ATTD_FORM_ATT_FILE_ID");
                                        attId = rs.getLong("S2S_USER_ATTACHED_FORM_ATT_ID");
                                        byte[] attachment = rs.getBytes("ATTACHMENT");
                                        fileDataId = this.saveFileData(attFileId, attachment);
                                    } else {
                                        hasResults = false;
                                    }
                                }
                                catch (SQLException e) {
                                    conn.rollback();
                                    throw e;
                                }
                                if (attId != null) {
                                    try {
                                        updateStmt.setString(1, fileDataId);
                                        updateStmt.setLong(2, attId);
                                        int numUpdated = updateStmt.executeUpdate();
                                        if (numUpdated != 1) {
                                            LOG.error("Expected to update a single row, but instead updated " + numUpdated + ". Job exiting.");
                                            conn.rollback();
                                            return;
                                        }
                                    }
                                    catch (SQLException e) {
                                        conn.rollback();
                                        throw e;
                                    }
                                }
                                if (attFileId != null) {
                                    try {
                                        deleteStmt.setLong(1, attFileId);
                                        int numUpdated = deleteStmt.executeUpdate();
                                        if (numUpdated != 1) {
                                            LOG.error("Expected to update a single row, but instead updated " + numUpdated + ". Job exiting.");
                                            conn.rollback();
                                            return;
                                        }
                                    }
                                    catch (SQLException e) {
                                        conn.rollback();
                                        throw e;
                                    }
                                }
                                conn.commit();
                            }
                            finally {
                                if (deleteStmt == null) continue;
                                deleteStmt.close();
                            }
                        }
                        finally {
                            if (updateStmt == null) continue;
                            updateStmt.close();
                        }
                    }
                    finally {
                        if (queryStmt == null) continue;
                        queryStmt.close();
                    }
                }
                finally {
                    if (conn == null) continue;
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOG.error("Got sql exception in S2sUserAttachedFormAttFile conversion, job exiting.", (Throwable)e);
                return;
            }
        }
    }

    private String saveFileData(Long attFileId, byte[] attachment) {
        LOG.debug(String.format("Saving S2S_USER_ATTD_FORM_ATT_FILE row with S2S_USER_ATTD_FORM_ATT_FILE_ID = %d to S3", attFileId));
        String fileDataId = null;
        if (ArrayUtils.isEmpty((byte[])attachment)) {
            LOG.warn(String.format("S2S_USER_ATTD_FORM_ATT_FILE row with S2S_USER_ATTD_FORM_ATT_FILE_ID = %d has no content", attFileId));
        } else {
            fileDataId = this.kcAttachmentDataDao.saveData(attachment, null);
        }
        return fileDataId;
    }

    public KcAttachmentDataDao getKcAttachmentDataDao() {
        return this.kcAttachmentDataDao;
    }

    public void setKcAttachmentDataDao(KcAttachmentDataDao kcAttachmentDataDao) {
        this.kcAttachmentDataDao = kcAttachmentDataDao;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

