/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.service;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.springframework.context.ApplicationContext;

public final class KcServiceLocator {
    private static ApplicationContext appContext;

    private KcServiceLocator() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void setAppContext(ApplicationContext appContext) {
        KcServiceLocator.appContext = appContext;
    }

    public static ApplicationContext getAppContext() {
        return appContext;
    }

    public static <T> T getService(String serviceName) {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            throw new IllegalArgumentException("the service name is blank.");
        }
        if (KcServiceLocator.getAppContext() == null) {
            return (T)GlobalResourceLoader.getService((String)serviceName);
        }
        try {
            return (T)KcServiceLocator.getAppContext().getBean(serviceName);
        }
        catch (Exception ex) {
            return (T)GlobalResourceLoader.getService((String)serviceName);
        }
    }

    public static <T> T getService(Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("the service class is null.");
        }
        String name = serviceClass.getSimpleName().substring(0, 1).toLowerCase() + serviceClass.getSimpleName().substring(1);
        return KcServiceLocator.getService(name);
    }

    public static <T> List<T> getServicesOfType(Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("the service class is null.");
        }
        return Stream.concat(appContext.getBeansOfType(serviceClass).values().stream(), KcServiceLocator.flatten(GlobalResourceLoader.getResourceLoader()).filter(rl -> rl instanceof SpringResourceLoader).map(rl -> (SpringResourceLoader)rl).flatMap(rl -> rl.getContext().getBeansOfType(serviceClass).values().stream())).collect(Collectors.toList());
    }

    private static Stream<ResourceLoader> flatten(ResourceLoader root) {
        return Stream.concat(Stream.of(root), root.getResourceLoaders().stream().flatMap(KcServiceLocator::flatten));
    }
}

