/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.coeus.sys.impl.auth.CoreStreamingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="coreStreamingService")
public class CoreStreamingServiceImpl
implements CoreStreamingService {
    private static final Integer LIMIT_COUNT = 100;
    private static final String LIMIT_PARAM = "limit";
    private static final String SKIP_PARAM = "skip";
    private static final String ITEM_COUNT_PARAM = "item-count";
    private static final Logger LOG = LogManager.getLogger(CoreStreamingServiceImpl.class);
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;

    @Override
    public <T> Stream<T> streamAll(final String url, final Map<String, Object> params, final Class<T> itemType) {
        final ParameterizedTypeReference responseType = new ParameterizedTypeReference<List<T>>(this){

            public Type getType() {
                return TypeFactory.defaultInstance().constructCollectionType(List.class, itemType);
            }
        };
        return StreamSupport.stream(new Spliterator<T>(){
            private int skip = 0;
            private Iterator<T> currentPage = Collections.emptyIterator();
            private boolean lastPage = false;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                while (!this.currentPage.hasNext() && !this.lastPage) {
                    ResponseEntity response = CoreStreamingServiceImpl.this.getAllResponse(url, params, responseType, this.skip);
                    List page = (List)response.getBody();
                    if (page == null || page.isEmpty()) {
                        this.lastPage = true;
                        return false;
                    }
                    if (this.firstPage()) {
                        List itemCountHeader = response.getHeaders().get((Object)CoreStreamingServiceImpl.ITEM_COUNT_PARAM);
                        LOG.info("Fetching first page of items with item-count: {} from URL: {}", itemCountHeader != null ? itemCountHeader.getFirst() : "UNKNOWN", (Object)url);
                    }
                    this.currentPage = page.iterator();
                    this.skip += LIMIT_COUNT.intValue();
                    if (page.size() >= LIMIT_COUNT) continue;
                    this.lastPage = true;
                }
                if (this.currentPage.hasNext()) {
                    action.accept(this.currentPage.next());
                    return true;
                }
                return false;
            }

            private boolean firstPage() {
                return this.skip == 0;
            }

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 272;
            }
        }, false);
    }

    private <T> ResponseEntity<List<T>> getAllResponse(String url, Map<String, Object> params, ParameterizedTypeReference<List<T>> responseType, Integer skip) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)url);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            uriComponentsBuilder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        String uri = uriComponentsBuilder.queryParam(LIMIT_PARAM, new Object[]{LIMIT_COUNT}).queryParam(SKIP_PARAM, new Object[]{skip}).build().encode().toString();
        return this.getRestOperations().exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)this.getAuthServiceRestUtilService().getAuthServiceStyleHttpHeadersForUser()), responseType, new Object[0]);
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }
}

