/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.workflow;

import java.sql.PreparedStatement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.kuali.rice.core.framework.persistence.platform.MySQLDatabasePlatform;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.stereotype.Repository;

@Repository(value="kewDocHeaderDao")
public class KewDocHeaderDaoImpl
extends LookupDaoOjb
implements KewDocHeaderDao {
    private static final Logger LOG = LogManager.getLogger(KewDocHeaderDaoImpl.class);
    private static final List<String> INDEXABLE_DOC_TYPES = List.of("ProposalDevelopmentDocument", "InstitutionalProposalDocument", "AwardDocument", "SubAwardDocument", "NegotiationDocument");
    private static final String INACTIVE_AWARDS = "SELECT DOCUMENT_NUMBER FROM award a WHERE a.AWARD_NUMBER LIKE CONCAT((SELECT DISTINCT SUBSTR(AWARD_NUMBER, 1, 6) FROM award t WHERE t.DOCUMENT_NUMBER = ?), '%') and a.AWARD_SEQUENCE_STATUS in ('ARCHIVED', 'CANCELED')";
    private static final String INACTIVE_IPS = "SELECT DOCUMENT_NUMBER FROM proposal p WHERE p.PROPOSAL_NUMBER = (SELECT DISTINCT PROPOSAL_NUMBER FROM proposal t WHERE t.DOCUMENT_NUMBER = ?) and p.PROPOSAL_SEQUENCE_STATUS in ('ARCHIVED', 'CANCELED')";
    private static final String INACTIVE_SUBAWARDS = "SELECT DOCUMENT_NUMBER FROM subaward s WHERE s.SUBAWARD_CODE = (SELECT DISTINCT SUBAWARD_CODE FROM subaward t WHERE t.DOCUMENT_NUMBER = ?) and s.SUBAWARD_SEQUENCE_STATUS in ('ARCHIVED', 'CANCELED')";
    private static final String ALL_DOCUMENT_IDS_QUERY = "select doc_hdr_id from krew_doc_hdr_t where doc_typ_id in (select doc_typ_id from krew_doc_typ_t where doc_typ_nm in ('" + String.join((CharSequence)"', '", INDEXABLE_DOC_TYPES) + "'))and doc_hdr_stat_cd not in ('I', 'D', 'X') order by stat_mdfn_dt desc";
    private static final String PAGED_DOCUMENT_IDS_QUERY_ORACLE = "select doc_hdr_id from (select doc_hdr_id, stat_mdfn_dt, row_number() over (order by stat_mdfn_dt desc) rn from krew_doc_hdr_t where doc_typ_id in (select doc_typ_id from krew_doc_typ_t where doc_typ_nm in ('" + String.join((CharSequence)"', '", INDEXABLE_DOC_TYPES) + "')) and doc_hdr_stat_cd not in ('I', 'D', 'X')) where rn between %d and %d order by stat_mdfn_dt desc";
    private static final String ALL_DOCUMENT_IDS_QUERY_DATE_LIMITED = "select doc_hdr_id from krew_doc_hdr_t where doc_typ_id in (select doc_typ_id from krew_doc_typ_t where doc_typ_nm in ('" + String.join((CharSequence)"', '", INDEXABLE_DOC_TYPES) + "'))and doc_hdr_stat_cd not in ('I', 'D', 'X') and STAT_MDFN_DT >= '%s' order by stat_mdfn_dt desc";
    private static final String ALL_NON_ACTIVE_DOCUMENT_IDS_QUERY = "SELECT DOCUMENT_NUMBER FROM award a WHERE a.AWARD_NUMBER LIKE CONCAT((SELECT DISTINCT SUBSTR(AWARD_NUMBER, 1, 6) FROM award t WHERE t.DOCUMENT_NUMBER = ?), '%') and a.AWARD_SEQUENCE_STATUS in ('ARCHIVED', 'CANCELED') union SELECT DOCUMENT_NUMBER FROM proposal p WHERE p.PROPOSAL_NUMBER = (SELECT DISTINCT PROPOSAL_NUMBER FROM proposal t WHERE t.DOCUMENT_NUMBER = ?) and p.PROPOSAL_SEQUENCE_STATUS in ('ARCHIVED', 'CANCELED') union SELECT DOCUMENT_NUMBER FROM subaward s WHERE s.SUBAWARD_CODE = (SELECT DISTINCT SUBAWARD_CODE FROM subaward t WHERE t.DOCUMENT_NUMBER = ?) and s.SUBAWARD_SEQUENCE_STATUS in ('ARCHIVED', 'CANCELED')";
    @Autowired
    @Qualifier(value="riceJdbcOperations")
    private JdbcOperations jdbcOperations;

    @Override
    public List<String> getAllDocumentIds() {
        return this.getAllDocumentIds(null, null);
    }

    @Override
    public List<String> getAllDocumentIds(Integer limit, Integer skip) {
        String pagedQuery = this.getPagedAllDocumentIdsQuery(limit, skip);
        return this.jdbcOperations.query(c -> c.prepareStatement(pagedQuery), (rs, rowNum) -> rs.getString(1));
    }

    @Override
    public Set<String> getAllNonActiveDocumentIds(String documentNumber) {
        Set<String> set;
        block9: {
            if (StringUtils.isBlank((CharSequence)documentNumber)) {
                return Collections.emptySet();
            }
            Stream stream = this.jdbcOperations.queryForStream(connection -> {
                PreparedStatement preparedStatement = connection.prepareStatement(ALL_NON_ACTIVE_DOCUMENT_IDS_QUERY, 1003, 1007);
                preparedStatement.setString(1, documentNumber);
                preparedStatement.setString(2, documentNumber);
                preparedStatement.setString(3, documentNumber);
                preparedStatement.setQueryTimeout(30);
                return preparedStatement;
            }, (rs, rowNum) -> rs.getString(1));
            try {
                set = stream.filter(Objects::nonNull).collect(Collectors.toSet());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DataAccessException e) {
                    this.logger.error((Object)String.format("Failed to retrieve non-active document IDs for document: %s", documentNumber), (Throwable)e);
                    return Collections.emptySet();
                }
            }
            stream.close();
        }
        return set;
    }

    @Override
    public List<String> getAllDocumentIdsAfterStartDate(Date startDate) {
        Date aWeekAgo = startDate == null ? this.getAWeekAgo(new Date()) : this.getAWeekAgo(startDate);
        String formattedDate = this.getMySqlDate(aWeekAgo);
        String query = String.format(ALL_DOCUMENT_IDS_QUERY_DATE_LIMITED, formattedDate);
        return this.jdbcOperations.query(c -> c.prepareStatement(query), (rs, rowNum) -> rs.getString(1));
    }

    private String getPagedAllDocumentIdsQuery(Integer limit, Integer skip) {
        int start;
        String sql = ALL_DOCUMENT_IDS_QUERY;
        if (skip == null || skip <= 0) {
            skip = 0;
        }
        int n = start = skip == 0 ? skip : skip + 1;
        if (limit != null && limit >= 0) {
            if (this.getDbPlatform() instanceof MySQLDatabasePlatform) {
                return String.format("%s LIMIT %d,%d", sql, skip, limit);
            }
            return String.format(PAGED_DOCUMENT_IDS_QUERY_ORACLE, start, skip + limit);
        }
        return sql;
    }

    private String getMySqlDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    private Date getAWeekAgo(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, -7);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

