/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectReviewTypeCodeFinder;

public class ExconProjectReview
extends ExconProjectAssociate
implements Comparable<ExconProjectReview> {
    private static final long serialVersionUID = 123452333758069217L;
    private Long projectReviewId;
    private String projectReviewTypeCode;
    private String reviewComment;

    public Long getProjectReviewId() {
        return this.projectReviewId;
    }

    public void setProjectReviewId(Long projectReviewId) {
        this.projectReviewId = projectReviewId;
    }

    public String getProjectReviewTypeCode() {
        return this.projectReviewTypeCode;
    }

    public void setProjectReviewTypeCode(String projectReviewTypeCode) {
        this.projectReviewTypeCode = projectReviewTypeCode;
    }

    public String getProjectReviewTypeName() {
        String projectReviewTypeName = "";
        if (!StringUtils.isEmpty((CharSequence)this.projectReviewTypeCode)) {
            projectReviewTypeName = this.getProjectReviewTypeCodeFinder().getKeyLabel(this.projectReviewTypeCode);
        }
        return projectReviewTypeName;
    }

    public ExconProjectReviewTypeCodeFinder getProjectReviewTypeCodeFinder() {
        return new ExconProjectReviewTypeCodeFinder();
    }

    public String getReviewComment() {
        return this.reviewComment;
    }

    public void setReviewComment(String reviewComment) {
        this.reviewComment = reviewComment;
    }

    @Override
    public void resetPersistenceState() {
        this.projectReviewId = null;
        this.versionNumber = null;
    }

    @Override
    public int compareTo(ExconProjectReview exconProjectReviewArg) {
        return exconProjectReviewArg.getProjectReviewTypeName().compareTo(this.getProjectReviewTypeName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.projectReviewId == null ? 0 : this.projectReviewId.hashCode());
        result = 31 * result + (this.projectReviewTypeCode == null ? 0 : this.projectReviewTypeCode.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.projectReviewId, ((ExconProjectReview)o).projectReviewId);
    }
}

