/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.service.impl;

import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyExistenceService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class TimeAndMoneyExistenceServiceImpl
implements TimeAndMoneyExistenceService {
    private KcWorkflowService kraWorkflowService;
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;
    public static final String ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST = "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST";

    @Override
    public boolean validateTimeAndMoneyRule(Award award, String rootAwardNumber) throws WorkflowException {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("rootAwardNumber", rootAwardNumber);
        fieldValues.put("documentStatus", VersionStatus.PENDING.toString());
        BusinessObjectService businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        List timeAndMoneyDocuments = businessObjectService.findMatching(TimeAndMoneyDocument.class, fieldValues);
        return timeAndMoneyDocuments == null || timeAndMoneyDocuments.isEmpty();
    }

    @Override
    public void addAwardVersionErrorMessage() {
        GlobalVariables.getMessageMap().addToErrorPath("document");
        GlobalVariables.getMessageMap().addToErrorPath("award");
        GlobalVariables.getMessageMap().putError("version", "error.award.cannot.be.versioned", new String[0]);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        GlobalVariables.getMessageMap().removeFromErrorPath("award");
    }

    public KcWorkflowService getKraWorkflowService() {
        return this.kraWorkflowService;
    }

    public void setKraWorkflowService(KcWorkflowService kraWorkflowService) {
        this.kraWorkflowService = kraWorkflowService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

