/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.nonpersonnel;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.kuali.coeus.common.budget.api.nonpersonnel.AbstractBudgetCalculatedAmountContract;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@MappedSuperclass
public abstract class AbstractBudgetCalculatedAmount
extends KcPersistableBusinessObjectBase
implements AbstractBudgetCalculatedAmountContract {
    private static final long serialVersionUID = 4346953317701218299L;
    @Column(name="BUDGET_ID")
    private Long budgetId;
    @Column(name="BUDGET_PERIOD")
    private Integer budgetPeriod;
    @Column(name="BUDGET_PERIOD_NUMBER")
    private Long budgetPeriodId;
    @Column(name="LINE_ITEM_NUMBER")
    private Integer lineItemNumber;
    @Column(name="RATE_CLASS_CODE")
    private String rateClassCode;
    @Column(name="RATE_TYPE_CODE")
    private String rateTypeCode;
    @Column(name="APPLY_RATE_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean applyRateFlag;
    @Column(name="CALCULATED_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal calculatedCost;
    @Column(name="CALCULATED_COST_SHARING")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal calculatedCostSharing;
    @Column(name="RATE_TYPE_DESCRIPTION")
    private String rateTypeDescription;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="RATE_CLASS_CODE", referencedColumnName="RATE_CLASS_CODE", insertable=false, updatable=false)
    private RateClass rateClass;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumns(value={@JoinColumn(name="RATE_CLASS_CODE", referencedColumnName="RATE_CLASS_CODE", insertable=false, updatable=false), @JoinColumn(name="RATE_TYPE_CODE", referencedColumnName="RATE_TYPE_CODE", insertable=false, updatable=false)})
    private RateType rateType;
    @Transient
    private String rateClassType;
    @Transient
    private Integer rateNumber;
    @Transient
    private transient BudgetRatesService budgetRatesService;

    public Long getBudgetPeriodId() {
        return this.budgetPeriodId;
    }

    public void setBudgetPeriodId(Long budgetPeriodId) {
        this.budgetPeriodId = budgetPeriodId;
    }

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public RateClass getRateClass() {
        return this.rateClass;
    }

    public void setRateClass(RateClass rateClass) {
        this.rateClass = rateClass;
    }

    public Integer getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(Integer budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public Integer getLineItemNumber() {
        return this.lineItemNumber;
    }

    public void setLineItemNumber(Integer lineItemNumber) {
        this.lineItemNumber = lineItemNumber;
    }

    public String getRateClassCode() {
        return this.rateClassCode;
    }

    public void setRateClassCode(String rateClassCode) {
        this.rateClassCode = rateClassCode;
    }

    public String getRateTypeCode() {
        return this.rateTypeCode;
    }

    public void setRateTypeCode(String rateTypeCode) {
        this.rateTypeCode = rateTypeCode;
    }

    public Boolean getApplyRateFlag() {
        return this.applyRateFlag;
    }

    public void setApplyRateFlag(Boolean applyRateFlag) {
        this.applyRateFlag = applyRateFlag;
    }

    public ScaleTwoDecimal getCalculatedCost() {
        return this.calculatedCost;
    }

    public void setCalculatedCost(ScaleTwoDecimal calculatedCost) {
        this.calculatedCost = calculatedCost;
    }

    public ScaleTwoDecimal getCalculatedCostSharing() {
        return this.calculatedCostSharing;
    }

    public void setCalculatedCostSharing(ScaleTwoDecimal calculatedCostSharing) {
        this.calculatedCostSharing = calculatedCostSharing;
    }

    public String getRateClassType() {
        return this.rateClassType;
    }

    public void setRateClassType(String rateClassType) {
        this.rateClassType = rateClassType;
    }

    public Integer getRateNumber() {
        return this.rateNumber;
    }

    public void setRateNumber(Integer rateNumber) {
        this.rateNumber = rateNumber;
    }

    public String getRateTypeDescription() {
        return this.rateTypeDescription;
    }

    public void setRateTypeDescription(String rateTypeDescription) {
        this.rateTypeDescription = rateTypeDescription;
    }

    public boolean getAddToFringeRate() {
        return !this.getBudgetRatesService().isEmployeeBenefitOnLabAllocation(this.getRateClassCode(), this.getRateTypeCode()) && !this.getBudgetRatesService().isVacationOnLabAllocation(this.getRateClassCode(), this.getRateTypeCode()) && !this.getBudgetRatesService().isLabAllocationSalary(this.getRateClass().getRateClassTypeCode()) && (this.getBudgetRatesService().isEmployeeBenefit(this.getRateClass().getRateClassTypeCode()) || this.getBudgetRatesService().isVacation(this.getRateClass().getRateClassTypeCode()));
    }

    public BudgetRatesService getBudgetRatesService() {
        if (this.budgetRatesService == null) {
            this.budgetRatesService = KcServiceLocator.getService(BudgetRatesService.class);
        }
        return this.budgetRatesService;
    }

    public void setBudgetRatesService(BudgetRatesService budgetRatesService) {
        this.budgetRatesService = budgetRatesService;
    }

    public RateType getRateType() {
        return this.rateType;
    }

    public void setRateType(RateType rateType) {
        this.rateType = rateType;
    }
}

