/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.auth.task;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.kuali.coeus.common.framework.auth.task.Task;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.WebAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.WebAuthorizer;
import org.kuali.coeus.common.framework.auth.task.WebTaskFactory;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="webAuthorizationService")
public class WebAuthorizationServiceImpl
implements WebAuthorizationService,
InitializingBean {
    @Value(value="#{webAuthorizerNames}")
    private Set<String> webAuthorizerNames = new HashSet<String>();
    @Autowired
    @Qualifier(value="taskAuthorizationService")
    private TaskAuthorizationService taskAuthorizationService;
    private List<WebAuthorizer> webAuthorizers = new ArrayList<WebAuthorizer>();

    @Override
    public boolean isAuthorized(String userId, Class actionClass, String methodName, ActionForm form, HttpServletRequest request) {
        boolean isAuthorized = true;
        if (actionClass != null) {
            String classname = actionClass.getCanonicalName();
            WebAuthorizer webAuthorizer = this.getWebAuthorizer(classname);
            if (webAuthorizer == null) {
                isAuthorized = this.isAuthorized(userId, actionClass.getSuperclass(), methodName, form, request);
            } else {
                WebTaskFactory taskFactory = webAuthorizer.getTaskFactory(methodName);
                if (taskFactory == null) {
                    isAuthorized = this.isAuthorized(userId, actionClass.getSuperclass(), methodName, form, request);
                } else if (this.getTaskAuthorizationService() != null) {
                    Task task = taskFactory.createTask(form, request);
                    isAuthorized = this.getTaskAuthorizationService().isAuthorized(userId, task);
                }
            }
        }
        return isAuthorized;
    }

    protected WebAuthorizer getWebAuthorizer(String classname) {
        for (WebAuthorizer webAuthorizer : this.getWebAuthorizers()) {
            if (!StringUtils.equals((CharSequence)webAuthorizer.getClassname(), (CharSequence)classname)) continue;
            return webAuthorizer;
        }
        return null;
    }

    public List<WebAuthorizer> getWebAuthorizers() {
        if (this.webAuthorizers.size() != this.webAuthorizerNames.size()) {
            for (String webAuthorizerName : this.webAuthorizerNames) {
                WebAuthorizer webAuthorizer = (WebAuthorizer)GlobalResourceLoader.getService((String)webAuthorizerName);
                if (webAuthorizer == null) continue;
                this.webAuthorizers.add(webAuthorizer);
            }
        }
        return this.webAuthorizers;
    }

    public void setWebAuthorizers(List<WebAuthorizer> webAuthorizers) {
        this.webAuthorizers = webAuthorizers;
    }

    public Set<String> getWebAuthorizerNames() {
        return this.webAuthorizerNames;
    }

    public void setWebAuthorizerNames(Set<String> webAuthorizerNames) {
        this.webAuthorizerNames = webAuthorizerNames;
    }

    public TaskAuthorizationService getTaskAuthorizationService() {
        return this.taskAuthorizationService;
    }

    public void setTaskAuthorizationService(TaskAuthorizationService taskAuthorizationService) {
        this.taskAuthorizationService = taskAuthorizationService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.webAuthorizerNames == null || this.webAuthorizerNames.isEmpty()) {
            throw new IllegalStateException("webAuthorizerNames not set");
        }
    }
}

