/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.custom;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.custom.AuditCustomDataEvent;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.SaveCustomDataEvent;
import org.kuali.coeus.common.framework.custom.arg.ArgValueLookup;
import org.kuali.coeus.common.framework.custom.attr.CustomAttribute;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDataType;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.propdev.impl.custom.AuditProposalCustomDataEvent;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.UTF8AnyCharacterValidationPattern;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class CustomDataRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<SaveCustomDataEvent> {
    private static final Logger LOG = LogManager.getLogger(CustomDataRule.class);
    private static final String STRING = "String";
    private static final String DATE = "Date";
    private static final String NUMBER = "Number";
    private static final String ARGUMENT_NAME = "argumentName";
    private static final String USER_NAME = "userName";
    private static final String CUSTOMATTRIBUTE_ERROR_KEY = "[%d].value";
    private static final String CUSTOMATTRIBUTE_MULTI_ERROR_KEY = "[%d].deserializedListValue[%d].value";
    private static final String DATE_REGEX = "(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01])/(19|2[0-9])[0-9]{2}";
    private static final Map<String, ValidationPattern> VALIDATION_CLASSES;
    @Autowired
    @Qualifier(value="legacyDataAdapter")
    private LegacyDataAdapter legacyDataAdapter;
    @Autowired
    @Qualifier(value="customAttributeService")
    private CustomAttributeService customAttributeService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;

    @Override
    public boolean processRules(SaveCustomDataEvent event) {
        boolean rulePassed = true;
        for (int i = 0; i < event.getCustomDataList().size(); ++i) {
            DocumentCustomData documentCustomData = event.getCustomDataList().get(i);
            if (this.isDocEnrouteAndDoesNotContainCustomAttribute(documentCustomData.getCustomAttribute().getId(), event.getCustomDataList(), event.getDocument().getDocumentHeader().getWorkflowDocument())) continue;
            rulePassed &= this.validateAttributeFormat(documentCustomData, i, event);
            rulePassed &= this.validateRequired(documentCustomData, i, event);
        }
        return rulePassed;
    }

    protected boolean isDocEnrouteAndDoesNotContainCustomAttribute(Long customAttributeId, List<? extends DocumentCustomData> customDataList, WorkflowDocument workflowDocument) {
        if (!workflowDocument.isSaved() && !workflowDocument.isInitiated()) {
            for (DocumentCustomData documentCustomData : customDataList) {
                if (!documentCustomData.getCustomAttributeId().equals(customAttributeId)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validateRequired(DocumentCustomData documentCustomData, int index, SaveCustomDataEvent event) {
        CustomAttribute customAttribute = documentCustomData.getCustomAttribute();
        boolean enforceRequired = event.getCustomAttributeDocuments().values().stream().filter(cad -> cad.getCustomAttribute().getId().equals(customAttribute.getId())).anyMatch(cad -> cad.isRequired() && cad.isActive());
        boolean isValid = true;
        if (event.isValidateRequiredFields() && enforceRequired) {
            if (customAttribute.getAllowsMultipleValues()) {
                if (documentCustomData.getDeserializedListValue() != null) {
                    for (int i = 0; i < documentCustomData.getDeserializedListValue().size(); ++i) {
                        String value = documentCustomData.getDeserializedListValue().get(i).getValue();
                        if (!StringUtils.isBlank((CharSequence)value)) continue;
                        String errorKey = event.getErrorPathPrefix() + String.format(CUSTOMATTRIBUTE_MULTI_ERROR_KEY, index, i);
                        event.reportError(customAttribute, errorKey, "error.required", customAttribute.getLabel(), value == null ? "" : value, this.getValidFormat(customAttribute.getCustomAttributeDataType().getDescription()));
                        isValid = false;
                    }
                } else {
                    String errorKey = event.getErrorPathPrefix() + String.format(CUSTOMATTRIBUTE_MULTI_ERROR_KEY, index, 0);
                    event.reportError(customAttribute, errorKey, "error.required", customAttribute.getLabel(), "", this.getValidFormat(customAttribute.getCustomAttributeDataType().getDescription()));
                    isValid = false;
                }
            } else {
                String value = documentCustomData.getValue();
                if (StringUtils.isBlank((CharSequence)value)) {
                    String errorKey = event.getErrorPathPrefix() + String.format(CUSTOMATTRIBUTE_ERROR_KEY, index);
                    event.reportError(customAttribute, errorKey, "error.required", customAttribute.getLabel(), value, this.getValidFormat(customAttribute.getCustomAttributeDataType().getDescription()));
                    isValid = false;
                }
            }
        }
        return isValid;
    }

    protected boolean validateAttributeFormat(DocumentCustomData documentCustomData, int index, SaveCustomDataEvent event) {
        CustomAttribute customAttribute = documentCustomData.getCustomAttribute();
        CustomAttributeDataType customAttributeDataType = customAttribute.getCustomAttributeDataType() == null && customAttribute.getDataTypeCode() != null ? this.getCustomAttributeService().getCustomAttributeDataType(customAttribute.getDataTypeCode()) : customAttribute.getCustomAttributeDataType();
        boolean isValid = true;
        if (customAttributeDataType != null) {
            if (customAttribute.getAllowsMultipleValues()) {
                if (documentCustomData.getDeserializedListValue() != null) {
                    for (int i = 0; i < documentCustomData.getDeserializedListValue().size(); ++i) {
                        String value = documentCustomData.getDeserializedListValue().get(i).getValue();
                        if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                        String errorKey = event.getErrorPathPrefix() + String.format(CUSTOMATTRIBUTE_MULTI_ERROR_KEY, index, i);
                        isValid &= this.validateAttributeValueFormat(customAttribute, customAttributeDataType, value, errorKey, event);
                    }
                }
            } else {
                String value = documentCustomData.getValue();
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    String errorKey = event.getErrorPathPrefix() + String.format(CUSTOMATTRIBUTE_ERROR_KEY, index);
                    isValid &= this.validateAttributeValueFormat(customAttribute, customAttributeDataType, documentCustomData.getValue(), errorKey, event);
                }
            }
        }
        return isValid;
    }

    protected boolean validateAttributeValueFormat(CustomAttribute customAttribute, CustomAttributeDataType customAttributeDataType, String value, String errorKey, SaveCustomDataEvent event) {
        boolean isValid = true;
        value = value != null ? value : "";
        Integer maxLength = customAttribute.getDataLength();
        if (maxLength != null && maxLength < value.length()) {
            event.reportError(customAttribute, errorKey, "error.maxLength", customAttribute.getLabel(), maxLength.toString());
            isValid = false;
        }
        ValidationPattern validationPattern = VALIDATION_CLASSES.get(customAttributeDataType.getDescription());
        String validFormat = this.getValidFormat(customAttributeDataType.getDescription());
        if (validationPattern != null) {
            if (!validationPattern.matches(value)) {
                event.reportError(customAttribute, errorKey, "error.invalidFormat.withFormat", customAttribute.getLabel(), value, validFormat);
                isValid = false;
            }
        } else if (DATE.equals(customAttributeDataType.getDescription())) {
            if (!value.matches(DATE_REGEX)) {
                event.reportError(customAttribute, errorKey, "error.invalidFormat", customAttribute.getLabel(), value, validFormat);
                isValid = false;
            } else {
                try {
                    DateFormat dateFormat = DateFormat.getDateInstance(3);
                    dateFormat.setLenient(false);
                    dateFormat.parse(value);
                }
                catch (ParseException e) {
                    event.reportError(customAttribute, errorKey, "error.date", value, customAttribute.getLabel());
                    isValid = false;
                }
            }
        }
        if (customAttribute.getLookupClass() != null && customAttribute.getLookupClass().equals(KcPerson.class.getName())) {
            if (customAttribute.getDataTypeCode().equals("1") && customAttribute.getLookupReturn().equals(USER_NAME)) {
                validFormat = this.getValidFormat(customAttributeDataType.getDescription());
                KcPerson customPerson = this.getKcPersonService().getKcPersonByUserName(value);
                if (customPerson == null) {
                    this.addError(customAttribute, errorKey, event, value, validFormat);
                    isValid = false;
                }
            }
        } else if (customAttribute.getLookupClass() != null && customAttribute.getLookupClass().equals(ArgValueLookup.class.getName())) {
            if (!this.isValidArgValue(customAttribute, value, errorKey, event, customAttributeDataType)) {
                isValid = false;
            }
        } else if (customAttribute.getLookupClass() != null) {
            try {
                Class<?> boClass = Class.forName(customAttribute.getLookupClass());
                if (this.isInvalid(boClass, this.keyValue(customAttribute.getLookupReturn(), value))) {
                    validFormat = this.getValidFormat(customAttributeDataType.getDescription());
                    this.addError(customAttribute, errorKey, event, value, validFormat);
                    isValid = false;
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return isValid;
    }

    public boolean isValidArgValue(CustomAttribute customAttribute, String customAttributeValue, String errorKey, SaveCustomDataEvent event, CustomAttributeDataType customAttributeDataType) {
        ArgValueLookup argValue;
        Collection<ArgValueLookup> searchResults = this.getMatchingArgValues(customAttribute);
        Optional<ArgValueLookup> matchedArgValue = searchResults.stream().filter(argValueLookup1 -> customAttributeValue.equals(argValueLookup1.getValue())).findFirst();
        if (matchedArgValue.isEmpty()) {
            String validFormat = this.getValidFormat(customAttributeDataType.getDescription());
            this.addError(customAttribute, errorKey, event, customAttributeValue, validFormat);
            return false;
        }
        if ((event instanceof AuditCustomDataEvent || event instanceof AuditProposalCustomDataEvent) && !(argValue = matchedArgValue.get()).isActive() && StringUtils.equals((CharSequence)customAttributeValue, (CharSequence)argValue.getValue())) {
            event.reportWarning(customAttribute, errorKey, "error.inactive.argument.value", customAttribute.getLabel());
            return false;
        }
        return true;
    }

    public Collection<ArgValueLookup> getMatchingArgValues(CustomAttribute customAttribute) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put(ARGUMENT_NAME, customAttribute.getLookupReturn());
        return this.getLegacyDataAdapter().findMatching(ArgValueLookup.class, criteria);
    }

    public void addError(CustomAttribute customAttribute, String errorKey, SaveCustomDataEvent event, String attributeValue, String validFormat) {
        event.reportError(customAttribute, errorKey, "error.existence", customAttribute.getLabel(), attributeValue, validFormat);
    }

    private String getValidFormat(String dataType) {
        String validFormat = "String - Any Character";
        if (dataType.equalsIgnoreCase(NUMBER)) {
            validFormat = "Number - [0-9]";
        } else if (dataType.equalsIgnoreCase(DATE)) {
            validFormat = "Date - [xx/xx/xxxx]";
        }
        return validFormat;
    }

    public CustomAttributeService getCustomAttributeService() {
        if (this.customAttributeService == null) {
            this.customAttributeService = KcServiceLocator.getService(CustomAttributeService.class);
        }
        return this.customAttributeService;
    }

    public void setCustomAttributeService(CustomAttributeService customAttributeService) {
        this.customAttributeService = customAttributeService;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public LegacyDataAdapter getLegacyDataAdapter() {
        if (this.legacyDataAdapter == null) {
            this.legacyDataAdapter = KcServiceLocator.getService(LegacyDataAdapter.class);
        }
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    static {
        HashMap<String, Object> tempPatterns = new HashMap<String, Object>();
        UTF8AnyCharacterValidationPattern anyCharVal = new UTF8AnyCharacterValidationPattern();
        anyCharVal.setAllowWhitespace(true);
        tempPatterns.put(STRING, anyCharVal);
        tempPatterns.put(NUMBER, new NumericValidationPattern());
        VALIDATION_CLASSES = Collections.unmodifiableMap(tempPatterns);
    }
}

