/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.period.AddBudgetPeriodAndTotalEvent;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.period.GenerateBudgetPeriodEvent;
import org.kuali.coeus.common.budget.framework.period.SaveBudgetPeriodAndTotalEvent;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.impl.CollectionControllerServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/proposalBudget"})
public class ProposalBudgetRateAndPeriodController
extends ProposalBudgetControllerBase {
    private static final String CONFIRM_PERIOD_CHANGES_DIALOG_ID = "PropBudget-PeriodsPage-ConfirmPeriodChangesDialog";
    private static final String PERIOD_CHANGES_DIALOG_ID = "PropBudget-PeriodsPage-ChangePeriodDialog";
    private static final String BUDGET_PERIOD_ERROR_PATH_PREFIX = "budget.budgetPeriods";
    private static final String NEW_PERIOD_DIALOG_ID = "PropBudget-PeriodsPage-AddDialog";
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService kualiConfigurationService;

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=resetToBudgetPeriodDefault"})
    public ModelAndView resetToBudgetPeriodDefault(@ModelAttribute(value="KualiForm") ProposalBudgetForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        String warningMessage = this.getBudgetSummaryService().defaultWarningMessage(budget);
        DialogResponse dialogResponse = form.getDialogResponse(CONFIRM_PERIOD_CHANGES_DIALOG_ID);
        if (StringUtils.isNotBlank((CharSequence)warningMessage)) {
            if (dialogResponse == null) {
                form.setDefaultBudgetPeriodWarningMessage(warningMessage);
                return this.getModelAndViewService().showDialog(CONFIRM_PERIOD_CHANGES_DIALOG_ID, true, (UifFormBase)form);
            }
            boolean confirmResetDefault = dialogResponse.getResponseAsBoolean();
            if (confirmResetDefault) {
                this.getBudgetSummaryService().defaultBudgetPeriods(budget);
                this.getBudgetSummaryService().adjustStartEndDatesForLineItems(budget);
                this.getBudgetSummaryService().syncBudgetPersonSalaryDetails(budget);
            }
        } else {
            this.getBudgetSummaryService().defaultBudgetPeriods(budget);
            this.getBudgetSummaryService().syncBudgetPersonSalaryDetails(budget);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=recalculateBudgetWithChanges"})
    public ModelAndView recalculateBudgetWithChanges(@ModelAttribute(value="KualiForm") ProposalBudgetForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        this.getBudgetSummaryService().calculateBudget(budget);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=addBudgetPeriod"})
    public ModelAndView addBudgetPeriod(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        BudgetPeriod newBudgetPeriod = (BudgetPeriod)form.getNewCollectionLines().get(BUDGET_PERIOD_ERROR_PATH_PREFIX);
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        newBudgetPeriod.setBudget(budget);
        String addLineBindingPath = this.getAddLineBindingPath(form);
        String errorPath = addLineBindingPath + ".";
        if (this.getKcBusinessRulesEngine().applyRules(new AddBudgetPeriodAndTotalEvent(budget, newBudgetPeriod, errorPath)).booleanValue()) {
            this.getBudgetSummaryService().addBudgetPeriod(budget, newBudgetPeriod);
            ObjectPropertyUtils.setPropertyValue((Object)form, (String)addLineBindingPath, (Object)new BudgetPeriod());
        }
        form.setUpdateComponentId(NEW_PERIOD_DIALOG_ID);
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey());
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected String getAddLineBindingPath(ProposalBudgetForm form) {
        CollectionControllerServiceImpl.CollectionActionParameters parameters = new CollectionControllerServiceImpl.CollectionActionParameters((UifFormBase)form, false);
        BindingInfo addLineBindingInfo = (BindingInfo)form.getViewPostMetadata().getComponentPostData(parameters.getSelectedCollectionId(), "addLineBindingInfo");
        return addLineBindingInfo.getBindingPath();
    }

    @Transactional
    @RequestMapping(params={"methodToCall=deleteBudgetPeriod"})
    public ModelAndView deleteBudgetPeriod(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        int lineToDelete = Integer.parseInt(form.getActionParamaterValue("selectedLineIndex"));
        if (lineToDelete >= 0) {
            this.getBudgetSummaryService().deleteBudgetPeriod(budget, lineToDelete);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=saveBudgetPeriod"})
    public ModelAndView saveBudgetPeriod(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        boolean rulePassed;
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        ModelAndView modelAndView = this.getModelAndViewService().getModelAndView((UifFormBase)form);
        int selectedLine = Integer.parseInt(form.getActionParamaterValue("selectedLineIndex"));
        BudgetPeriod budgetPeriod = budget.getBudgetPeriods().get(selectedLine);
        if (this.isBudgetPeriodDateChanged(budgetPeriod) && this.isOnlyLineItemDateError()) {
            this.getGlobalVariableService().getMessageMap().clearErrorMessages();
            DialogResponse dialogResponse = form.getDialogResponse(PERIOD_CHANGES_DIALOG_ID);
            if (dialogResponse == null) {
                return this.getModelAndViewService().showDialog(PERIOD_CHANGES_DIALOG_ID, true, (UifFormBase)form);
            }
            boolean confirmResetDefault = dialogResponse.getResponseAsBoolean();
            if (confirmResetDefault) {
                this.getBudgetSummaryService().adjustStartEndDatesForLineItems(budgetPeriod);
            }
        }
        if (rulePassed = this.getKcBusinessRulesEngine().applyRules(new SaveBudgetPeriodAndTotalEvent(budget, BUDGET_PERIOD_ERROR_PATH_PREFIX)).booleanValue()) {
            this.getBudgetCalculationService().calculateBudgetPeriod(budget, budgetPeriod);
            modelAndView = super.saveLine(form);
        }
        return modelAndView;
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=generateAllPeriods"})
    public ModelAndView generateAllPeriods(@ModelAttribute(value="KualiForm") ProposalBudgetForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        boolean rulePassed = this.getKcBusinessRulesEngine().applyRules(new GenerateBudgetPeriodEvent((Budget)form.getBudget(), null));
        if (rulePassed) {
            boolean confirmRecalculate;
            DialogResponse dialogResponse = form.getDialogResponse(CONFIRM_PERIOD_CHANGES_DIALOG_ID);
            Budget originalBudget = this.getOriginalBudget(form);
            if (dialogResponse == null && this.isRateTypeChanged(originalBudget, budget)) {
                form.setDefaultBudgetPeriodWarningMessage(this.getKualiConfigurationService().getPropertyValueAsString("document.question.recalculateBudget.text"));
                return this.getModelAndViewService().showDialog(CONFIRM_PERIOD_CHANGES_DIALOG_ID, true, (UifFormBase)form);
            }
            boolean bl = confirmRecalculate = dialogResponse == null || dialogResponse.getResponseAsBoolean();
            if (confirmRecalculate) {
                this.getBudgetSummaryService().updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
                this.getBudgetSummaryService().generateAllPeriods(budget);
                form.setSelectedBudget(budget);
            }
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=readyGeneratePeriod"})
    public ModelAndView readyGeneratePeriod(@ModelAttribute(value="KualiForm") ProposalBudgetForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DialogResponse dialogResponse = form.getDialogResponse("PropBudget-PeriodsPage-ReadyToGeneratePeriodsDialog");
        if (dialogResponse == null) {
            return this.getModelAndViewService().showDialog("PropBudget-PeriodsPage-ReadyToGeneratePeriodsDialog", true, (UifFormBase)form);
        }
        if (dialogResponse.getResponseAsBoolean()) {
            form.setPageId("PropBudget-SubawardsPage");
            return this.generateAllPeriods(form, result, request, response);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Override
    @Transactional
    @RequestMapping(params={"methodToCall=save", "pageId=PropBudget-PeriodsPage"})
    public ModelAndView save(ProposalBudgetForm form) {
        this.getModelAndViewService().getModelAndView((UifFormBase)form);
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        if (this.isBudgetPeriodDateChanged(budget) && this.isOnlyLineItemDateError()) {
            this.getGlobalVariableService().getMessageMap().clearErrorMessages();
            DialogResponse dialogResponse = form.getDialogResponse(PERIOD_CHANGES_DIALOG_ID);
            if (dialogResponse == null) {
                return this.getModelAndViewService().showDialog(PERIOD_CHANGES_DIALOG_ID, true, (UifFormBase)form);
            }
            boolean confirmResetDefault = dialogResponse.getResponseAsBoolean();
            if (confirmResetDefault) {
                this.getBudgetSummaryService().adjustStartEndDatesForLineItems(budget);
            }
        }
        return super.save(form);
    }

    private boolean isBudgetPeriodDateChanged(Budget budget) {
        BudgetPeriod budgetPeriod;
        boolean budgetPeriodDateChanged = false;
        Iterator<BudgetPeriod> iterator = budget.getBudgetPeriods().iterator();
        while (iterator.hasNext() && !(budgetPeriodDateChanged = this.isBudgetPeriodDateChanged(budgetPeriod = iterator.next()))) {
        }
        return budgetPeriodDateChanged;
    }

    private boolean isBudgetPeriodDateChanged(BudgetPeriod budgetPeriod) {
        return budgetPeriod.getStartDate() != null && budgetPeriod.getOldStartDate() != null && budgetPeriod.getEndDate() != null && budgetPeriod.getOldEndDate() != null && (budgetPeriod.getStartDate().compareTo(budgetPeriod.getOldStartDate()) != 0 || budgetPeriod.getEndDate().compareTo(budgetPeriod.getOldEndDate()) != 0);
    }

    private boolean isOnlyLineItemDateError() {
        Map errors = this.getGlobalVariableService().getMessageMap().getErrorMessages();
        List<String> lineItemDateErrors = this.getLineItemDateErrors();
        if (!errors.isEmpty()) {
            for (Map.Entry entry : errors.entrySet()) {
                List errorMessages = (List)entry.getValue();
                for (ErrorMessage errorMessage : errorMessages) {
                    if (lineItemDateErrors.contains(errorMessage.getErrorKey())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private List<String> getLineItemDateErrors() {
        ArrayList<String> lineItemDateErrors = new ArrayList<String>();
        lineItemDateErrors.add("error.lineItem.dateDoesNotmatch");
        lineItemDateErrors.add("error.line.item.start.date");
        lineItemDateErrors.add("error.line.item.end.date");
        return lineItemDateErrors;
    }

    public ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }
}

