/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.editable;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.editable.ProposalChangedData;
import org.kuali.coeus.propdev.impl.editable.ProposalDataOverrideEvent;
import org.kuali.coeus.propdev.impl.editable.ProposalDataOverrideRule;
import org.kuali.coeus.sys.framework.persistence.KcPersistenceStructureService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.UTF8AnyCharacterValidationPattern;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentDataOverrideRule
extends KcTransactionalDocumentRuleBase
implements ProposalDataOverrideRule {
    private static Map<String, String> validationClasses = new HashMap<String, String>();
    private static final String DATE = "DATE";
    private KcPersistenceStructureService kcPersistenceStructureService;
    private DateTimeService dateTimeService;

    @Override
    public boolean processProposalDataOverrideRules(ProposalDataOverrideEvent proposalDataOverrideEvent) {
        ProposalChangedData proposalOverriddenData = proposalDataOverrideEvent.getProposalChangedData();
        DevelopmentProposal developmentProposal = proposalDataOverrideEvent.getDevelopmentProposal();
        boolean valid = true;
        String overriddenValue = proposalOverriddenData.getChangedValue();
        Map<String, String> columnToAttributesMap = this.getKcPersistenceStructureService().getDBColumnToObjectAttributeMap(DevelopmentProposal.class);
        if (StringUtils.isEmpty((CharSequence)proposalOverriddenData.getColumnName())) {
            GlobalVariables.getMessageMap().putError("newProposalChangedData.columnName", "error.alterproposaldata.nofieldtoedit", new String[0]);
            return false;
        }
        String overriddenName = this.getDataDictionaryService().getAttributeErrorLabel(DevelopmentProposal.class, columnToAttributesMap.get(proposalOverriddenData.getColumnName()));
        Boolean isRequiredField = this.getDataDictionaryService().isAttributeRequired(DevelopmentProposal.class, columnToAttributesMap.get(proposalOverriddenData.getColumnName()));
        boolean isPrimitiveField = this.getDataObjectService().wrap((Object)developmentProposal).getPropertyType(proposalOverriddenData.getAttributeName()).isPrimitive();
        if (StringUtils.isNotEmpty((CharSequence)proposalOverriddenData.getChangedValue())) {
            valid &= this.validateAttributeFormat(proposalOverriddenData, developmentProposal);
        }
        if ((isRequiredField.booleanValue() || isPrimitiveField) && StringUtils.isEmpty((CharSequence)overriddenValue)) {
            valid = false;
            GlobalVariables.getMessageMap().putError("newProposalChangedData.changedValue", "error.required", new String[]{overriddenName});
        }
        if (StringUtils.isNotEmpty((CharSequence)proposalOverriddenData.getComments())) {
            int commentsMaxLength = this.getDataDictionaryService().getAttributeMaxLength(ProposalChangedData.class, "comments");
            String commentsLabel = this.getDataDictionaryService().getAttributeLabel(ProposalChangedData.class, "comments");
            if (commentsMaxLength < proposalOverriddenData.getComments().length()) {
                GlobalVariables.getMessageMap().putError("newProposalChangedData.comments", "error.maxLength", new String[]{commentsLabel, "" + commentsMaxLength});
                return false;
            }
        }
        return valid;
    }

    private boolean validateAttributeFormat(ProposalChangedData proposalOverriddenData, DevelopmentProposal developmentProposal) {
        Pattern validationExpression;
        String overriddenValue = proposalOverriddenData.getChangedValue();
        String changedValueLabel = this.getDataDictionaryService().getAttributeLabel(ProposalChangedData.class, "changedValue");
        String dataType = null;
        Integer maxLength = -1;
        if (proposalOverriddenData.getEditableColumn() != null) {
            dataType = proposalOverriddenData.getEditableColumn().getDataType();
            maxLength = proposalOverriddenData.getEditableColumn().getDataLength();
        }
        ValidationPattern validationPattern = null;
        if (DATE.equalsIgnoreCase(dataType)) {
            try {
                this.getDateTimeService().convertToDate(overriddenValue);
            }
            catch (ParseException e) {
                GlobalVariables.getMessageMap().putError("newProposalChangedData.changedValue", "error.invalidFormat", new String[]{changedValueLabel, overriddenValue});
                return false;
            }
        }
        String validationClassName = validationClasses.get(dataType);
        if (StringUtils.isNotEmpty((CharSequence)validationClassName)) {
            try {
                validationPattern = (ValidationPattern)Class.forName(validationClasses.get(dataType)).newInstance();
                if (dataType.equalsIgnoreCase("STRING")) {
                    ((UTF8AnyCharacterValidationPattern)validationPattern).setAllowWhitespace(true);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in instantiating a ValidationPatternClass for Proposal Data Overriding", e);
            }
        }
        if (validationPattern != null && (validationExpression = validationPattern.getRegexPattern()) != null && !validationExpression.pattern().equals(".*") && !validationExpression.matcher(overriddenValue).matches()) {
            GlobalVariables.getMessageMap().putError("newProposalChangedData.changedValue", "error.invalidFormat", new String[]{changedValueLabel, overriddenValue});
            return false;
        }
        if (maxLength != null && maxLength < overriddenValue.length()) {
            GlobalVariables.getMessageMap().putError("newProposalChangedData.changedValue", "error.maxLength", new String[]{changedValueLabel, maxLength.toString()});
            return false;
        }
        try {
            String currentValueStr;
            Object currentValue = PropertyUtils.getNestedProperty((Object)developmentProposal, (String)proposalOverriddenData.getAttributeName());
            String string = currentValueStr = currentValue != null ? currentValue.toString() : "";
            if (DATE.equalsIgnoreCase(proposalOverriddenData.getEditableColumn().getDataType()) && currentValue != null) {
                currentValueStr = this.getDateTimeService().toString((Date)currentValue, "MM/dd/yyyy");
            }
            if (StringUtils.isNotEmpty((CharSequence)currentValueStr) && currentValueStr.equalsIgnoreCase(overriddenValue)) {
                GlobalVariables.getMessageMap().putError("newProposalChangedData.changedValue", "error.proposalData.override.samevalue", new String[]{proposalOverriddenData.getEditableColumn().getColumnLabel(), proposalOverriddenData.getDisplayValue() != null ? proposalOverriddenData.getDisplayValue() : overriddenValue});
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving " + proposalOverriddenData.getAttributeName() + " from the proposal", e);
        }
        return true;
    }

    protected KcPersistenceStructureService getKcPersistenceStructureService() {
        if (this.kcPersistenceStructureService == null) {
            this.kcPersistenceStructureService = KcServiceLocator.getService(KcPersistenceStructureService.class);
        }
        return this.kcPersistenceStructureService;
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    static {
        validationClasses.put("STRING", UTF8AnyCharacterValidationPattern.class.getName());
        validationClasses.put("NUMBER", NumericValidationPattern.class.getName());
    }
}

