/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.print;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.coeus.common.framework.sponsor.form.SponsorFormTemplate;
import org.kuali.coeus.common.framework.sponsor.form.SponsorFormTemplateList;
import org.kuali.coeus.common.framework.sponsor.form.SponsorForms;
import org.kuali.coeus.common.framework.sponsor.hierarchy.SponsorHierarchy;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.print.QuestionnairePrint;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.question.ProposalPersonQuestionnaireHelper;
import org.kuali.coeus.propdev.impl.print.ProposalDevelopmentPrintingService;
import org.kuali.coeus.propdev.impl.print.ProposalSponsorFormsPrint;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="proposalDevelopmentPrintingService")
@Lazy
public class ProposalDevelopmentPrintingServiceImpl
implements ProposalDevelopmentPrintingService {
    private static final String SPONSOR_CODE_DB_KEY = "sponsorCode";
    public static final String TEMPLATE = "template";
    public static final String SPONSOR_HIERARCHY_NAME = "sponsorHierarchyName";
    @Autowired
    @Qualifier(value="proposalSponsorFormsPrint")
    private ProposalSponsorFormsPrint proposalSponsorFormsPrint;
    @Autowired
    @Qualifier(value="printingService")
    private PrintingService printingService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="questionnairePrint")
    private QuestionnairePrint questionnairePrint;

    @Override
    public AttachmentDataSource printProposalDevelopmentReport(KcPersistableBusinessObjectBase printableBusinessObject, String reportName, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        ProposalSponsorFormsPrint printable = null;
        if (reportName.equals("Print Proposal Sponsor Forms")) {
            printable = this.getProposalSponsorFormsPrint();
        }
        printable.setPrintableBusinessObject(printableBusinessObject);
        printable.setReportParameters(reportParameters);
        source = this.getPrintingService().print(printable);
        source.setName(this.getReportName(printableBusinessObject, reportName));
        source.setType("application/pdf");
        return source;
    }

    protected String getReportName(KcPersistableBusinessObjectBase printableBusinessObject, String reportName) {
        DevelopmentProposal developmentProposal = (DevelopmentProposal)printableBusinessObject;
        String proposalNumber = developmentProposal.getProposalNumber();
        StringBuilder reportFullName = new StringBuilder(proposalNumber).append("_").append(reportName.replace(' ', '_')).append(".pdf");
        return reportFullName.toString();
    }

    @Override
    public void populateSponsorForms(List<SponsorFormTemplateList> sponsorFormTemplates, String sponsorCode) {
        if (!sponsorFormTemplates.isEmpty()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)sponsorCode, (CharSequence)sponsorFormTemplates.get(0).getSponsorForms().getSponsorCode())) {
                sponsorFormTemplates.clear();
            }
            sponsorFormTemplates.clear();
        }
        if (sponsorFormTemplates.isEmpty()) {
            Collection<SponsorFormTemplateList> clsponsorFormTemplates = this.getSponsorTemplatesList(sponsorCode);
            sponsorFormTemplates.addAll(clsponsorFormTemplates);
            if (!this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "LOCAL_PRINT_FORM_SPONSOR_CODE").equals(sponsorCode)) {
                String genericSponsorCode = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "GENERIC_SPONSOR_CODE");
                clsponsorFormTemplates = this.getSponsorTemplatesList(genericSponsorCode);
            }
            sponsorFormTemplates.addAll(clsponsorFormTemplates);
        } else {
            this.resetSelectedFormList(sponsorFormTemplates);
        }
        HashSet<SponsorFormTemplateList> set = new HashSet<SponsorFormTemplateList>();
        set.addAll(sponsorFormTemplates);
        sponsorFormTemplates.clear();
        sponsorFormTemplates.addAll(set);
        Collections.sort(sponsorFormTemplates);
    }

    protected Collection<SponsorFormTemplateList> getSponsorTemplatesList(String sponsorCode) {
        HashMap<String, String> sponsorCodeMap = new HashMap<String, String>();
        sponsorCodeMap.put(SPONSOR_CODE_DB_KEY, sponsorCode);
        List sponsorForms = this.getBusinessObjectService().findMatching(SponsorForms.class, sponsorCodeMap);
        ArrayList<SponsorFormTemplateList> retval = new ArrayList<SponsorFormTemplateList>();
        for (SponsorForms sponsorForm : sponsorForms) {
            retval.addAll(sponsorForm.getSponsorFormTemplates());
        }
        String hierarchyName = this.getParameterService().getParameterValueAsString("KC-GEN", "All", "SPONSOR_HIERARCHY_FOR_PRINTING");
        sponsorCodeMap.put("hierarchyName", hierarchyName);
        SponsorHierarchy hierarchyEntry = (SponsorHierarchy)this.getBusinessObjectService().findByPrimaryKey(SponsorHierarchy.class, sponsorCodeMap);
        if (hierarchyEntry != null) {
            sponsorCodeMap.clear();
            sponsorCodeMap.put(SPONSOR_HIERARCHY_NAME, hierarchyEntry.getLevel1());
            sponsorForms = this.getBusinessObjectService().findMatching(SponsorForms.class, sponsorCodeMap);
            for (SponsorForms sponsorForm : sponsorForms) {
                retval.addAll(sponsorForm.getSponsorFormTemplates());
            }
        }
        return retval;
    }

    protected void resetSelectedFormList(List<SponsorFormTemplateList> sponsorFormTemplates) {
        for (SponsorFormTemplateList sponsorFormTemplateList : sponsorFormTemplates) {
            sponsorFormTemplateList.setSelectToPrint(false);
        }
    }

    @Override
    public List<SponsorFormTemplate> getSponsorFormTemplates(List<SponsorFormTemplateList> sponsorFormTemplateLists) {
        ArrayList<SponsorFormTemplate> printFormTemplates = new ArrayList<SponsorFormTemplate>();
        for (SponsorFormTemplateList sponsorFormTemplateList : sponsorFormTemplateLists) {
            if (!sponsorFormTemplateList.getSelectToPrint().booleanValue()) continue;
            printFormTemplates.add((SponsorFormTemplate)this.getBusinessObjectService().findBySinglePrimaryKey(SponsorFormTemplate.class, (Object)sponsorFormTemplateList.getSponsorFormTemplateId()));
        }
        Collections.sort(printFormTemplates);
        this.resetSelectedFormList(sponsorFormTemplateLists);
        return printFormTemplates;
    }

    @Override
    public AttachmentDataSource printPersonCertificationQuestionnaire(List<ProposalPerson> persons) throws PrintingException {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        ArrayList<Printable> printables = new ArrayList<Printable>();
        for (ProposalPerson person : persons) {
            ProposalPersonQuestionnaireHelper helper = new ProposalPersonQuestionnaireHelper(person);
            helper.populateAnswers();
            AnswerHeader header = helper.getAnswerHeaders().get(0);
            reportParameters.put("questionnaireSeqId", header.getQuestionnaire().getQuestionnaireSeqIdAsInteger());
            reportParameters.put(TEMPLATE, header.getQuestionnaire().getTemplate());
            QuestionnairePrint printable = new QuestionnairePrint();
            try {
                PropertyUtils.copyProperties((Object)printable, (Object)this.getQuestionnairePrint());
            }
            catch (Exception e) {
                throw new RuntimeException("error copying questionnaire print", e);
            }
            if (printable != null) {
                printable.setPrintableBusinessObject(person);
                printable.setReportParameters(reportParameters);
            }
            printables.add(printable);
        }
        return this.getPrintingService().print(printables);
    }

    protected PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ProposalSponsorFormsPrint getProposalSponsorFormsPrint() {
        return this.proposalSponsorFormsPrint;
    }

    public void setProposalSponsorFormsPrint(ProposalSponsorFormsPrint proposalSponsorFormsPrint) {
        this.proposalSponsorFormsPrint = proposalSponsorFormsPrint;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected QuestionnairePrint getQuestionnairePrint() {
        return this.questionnairePrint;
    }

    public void setQuestionnairePrint(QuestionnairePrint questionnairePrint) {
        this.questionnairePrint = questionnairePrint;
    }
}

