/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.nih;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.sys.framework.util.JaxbUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class NihServiceBase {
    protected static final Logger LOG = LogManager.getLogger(NihServiceBase.class);
    private static final String KEY_TYPE = "JKS";
    private static final String NIH_GOV_S2S_CN_CHECK = "nih.gov.s2s.cn.check";
    private static final String NIH_GOV_S2S_KEYSTORE_PASSWORD = "nih.gov.s2s.keystore.password";
    private static final String NIH_GOV_S2S_KEYSTORE_LOCATION = "nih.gov.s2s.keystore.location";
    private static final String NIH_GOV_S2S_TRUSTSTORE_LOCATION = "nih.gov.s2s.truststore.location";
    private static final String NIH_GOV_S2S_TRUSTSTORE_PASSWORD = "nih.gov.s2s.truststore.password";
    private static final String NIH_GOV_S2S_CONNECTION_TIMEOUT_MS = "nih.gov.s2s.connection.timeout.ms";
    private static final String NIH_GOV_S2S_RECEIVE_TIMEOUT_MS = "nih.gov.s2s.receive.timeout.ms";
    private static final Cache<Integer, Object> requestCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;

    public abstract String getServiceHost();

    public abstract String getServicePort();

    protected Object optionallyCache(Integer key, Callable loader) {
        try {
            if (this.isNihServiceCacheEnabled()) {
                return this.getNihServiceCache().get((Object)key, loader);
            }
            return loader.call();
        }
        catch (Exception e) {
            throw new S2sCommunicationException("error.nih.service.unknown", e);
        }
    }

    <T> T createConfiguredService(String dunsNumber, Class<T> clazz) {
        Boolean multiCampusEnabled = this.multiCampusEnabled();
        TLSClientParameters tlsConfig = new TLSClientParameters();
        tlsConfig.setDisableCNCheck(this.disableCNCheck().booleanValue());
        try {
            KeyStore trustStore = KeyStore.getInstance(KEY_TYPE);
            trustStore.load(new FileInputStream(this.trustStoreLocation()), this.trustStorePassword().toCharArray());
            String keyStorePassword = this.keyStorePassword();
            KeyStore keyStore = KeyStore.getInstance(KEY_TYPE);
            keyStore.load(new FileInputStream(this.keyStoreLocation()), keyStorePassword.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (StringUtils.isNotBlank((CharSequence)dunsNumber) && multiCampusEnabled.booleanValue()) {
                KeyStore keyStoreAlias = KeyStore.getInstance(KEY_TYPE);
                Certificate[] certificates = keyStore.getCertificateChain(dunsNumber);
                Key key = keyStore.getKey(dunsNumber, keyStorePassword.toCharArray());
                keyStoreAlias.load(null, null);
                keyStoreAlias.setKeyEntry(dunsNumber, key, keyStorePassword.toCharArray(), certificates);
                keyManagerFactory.init(keyStoreAlias, keyStorePassword.toCharArray());
                this.logConfiguration(dunsNumber, keyStore, keyStoreAlias, trustStore);
            } else {
                keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
                this.logConfiguration(dunsNumber, keyStore, null, trustStore);
            }
            KeyManager[] km = keyManagerFactory.getKeyManagers();
            tlsConfig.setKeyManagers(km);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            TrustManager[] tm = trustManagerFactory.getTrustManagers();
            tlsConfig.setTrustManagers(tm);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new S2sCommunicationException("error.s2s.unknown", e);
        }
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setAddress(this.getSoapHost(this.getServiceHost(), this.getServicePort()));
        factory.setServiceClass(clazz);
        Object applicantWebService = factory.create();
        Client client = ClientProxy.getClient((Object)applicantWebService);
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(Long.parseUnsignedLong(this.connectionTimeout()));
        httpClientPolicy.setReceiveTimeout(Long.parseUnsignedLong(this.receiveTimeout()));
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        conduit.setClient(httpClientPolicy);
        conduit.setTlsClientParameters(tlsConfig);
        return (T)applicantWebService;
    }

    private String receiveTimeout() {
        return this.s2SConfigurationService.getValueAsString(NIH_GOV_S2S_RECEIVE_TIMEOUT_MS);
    }

    private String connectionTimeout() {
        return this.s2SConfigurationService.getValueAsString(NIH_GOV_S2S_CONNECTION_TIMEOUT_MS);
    }

    private String trustStorePassword() {
        return this.s2SConfigurationService.getValueAsString(NIH_GOV_S2S_TRUSTSTORE_PASSWORD);
    }

    private String trustStoreLocation() {
        return this.s2SConfigurationService.getValueAsString(NIH_GOV_S2S_TRUSTSTORE_LOCATION);
    }

    private String keyStoreLocation() {
        return this.s2SConfigurationService.getValueAsString(NIH_GOV_S2S_KEYSTORE_LOCATION);
    }

    private String keyStorePassword() {
        return this.s2SConfigurationService.getValueAsString(NIH_GOV_S2S_KEYSTORE_PASSWORD);
    }

    private Boolean disableCNCheck() {
        return this.s2SConfigurationService.getValueAsBoolean(NIH_GOV_S2S_CN_CHECK);
    }

    private Boolean multiCampusEnabled() {
        return this.s2SConfigurationService.getValueAsBoolean("MULTI_CAMPUS_ENABLED");
    }

    private void logConfiguration(String alias, KeyStore keyStore, KeyStore keyStoreAlias, KeyStore trustStore) {
        if (LOG.isInfoEnabled()) {
            Function<Supplier, String> tryGetValue = v -> {
                try {
                    Object value = v.get();
                    return value != null ? value.toString() : null;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            };
            String keyStoreLocation = tryGetValue.apply(this::keyStoreLocation);
            String keyStorePassword = tryGetValue.apply(this::keyStorePassword);
            String trustStoreLocation = tryGetValue.apply(this::trustStoreLocation);
            String trustStorePassword = tryGetValue.apply(this::trustStorePassword);
            String multiCampusEnabled = tryGetValue.apply(this::multiCampusEnabled);
            String serviceHost = tryGetValue.apply(this::getServiceHost);
            String servicePort = tryGetValue.apply(this::getServicePort);
            String disableCNCheck = tryGetValue.apply(this::disableCNCheck);
            LOG.info("KeyStore Location: [" + keyStoreLocation + "]\nKeyStore Password: [" + (StringUtils.isNotBlank((CharSequence)keyStorePassword) ? "*****" : "IS_BLANK") + "]\nTrustStore Location: [" + trustStoreLocation + "]\nTrustStore Password: [" + (StringUtils.isNotBlank((CharSequence)trustStorePassword) ? "*****" : "IS_BLANK") + "]\nKeyStore: [" + (keyStore != null ? "NOT_NULL" : "NULL") + "]\nAlias: [" + alias + "]\nMultiCampus Enabled: [" + multiCampusEnabled + "]\nKeyStore Alias: [" + (keyStoreAlias != null ? "NOT_NULL" : "NULL") + "]\nTrustStore: [" + (trustStore != null ? "NOT_NULL" : "NULL") + "]\nService Host: [" + serviceHost + "]\nService Port: [" + servicePort + "]\nDisable CN Check: [" + disableCNCheck + "]\nConnection Timeout: [" + this.connectionTimeout() + "]\nReceive Timeout: [" + this.receiveTimeout() + "]\n");
        }
    }

    protected String getSoapHost(String hostStr, String portStr) {
        StringBuilder host = new StringBuilder();
        host.append(hostStr);
        if (!host.toString().endsWith("/") && !portStr.startsWith("/")) {
            host.append("/");
        }
        host.append(portStr);
        return host.toString();
    }

    protected boolean isNihServiceEnabled() {
        return this.getS2SConfigurationService().getValueAsBoolean("Enable_NIH_Service");
    }

    protected boolean isNihServiceCacheEnabled() {
        return this.getS2SConfigurationService().getValueAsBoolean("Enable_NIH_Service_Caching");
    }

    protected Cache getNihServiceCache() {
        return requestCache;
    }

    protected S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    protected void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    protected <T> void debugLogJaxbObject(Class<? extends T> clazz, T o, Logger logger) {
        if (logger.isDebugEnabled()) {
            try {
                logger.debug(JaxbUtils.toString(clazz, o));
            }
            catch (JAXBException e) {
                logger.debug("Unable to marshall object", (Throwable)e);
            }
        }
    }
}

