/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.nih;

import gov.nih.era.external.ImageGenerationFaultException;
import gov.nih.era.external.SubmissionImageServiceStub;
import gov.nih.era.submissionimageservice.AttachmentAsStreamType;
import gov.nih.era.submissionimageservice.GrantImageRequest;
import gov.nih.era.submissionimageservice.ImageResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.s2s.S2sAppSubmission;
import org.kuali.coeus.propdev.impl.s2s.S2sApplication;
import org.kuali.coeus.propdev.impl.s2s.S2sFileDto;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.propdev.impl.s2s.nih.NihServiceBase;
import org.kuali.coeus.propdev.impl.s2s.nih.NihSubmissionImageService;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.sys.api.model.KcFile;
import org.springframework.stereotype.Component;

@Component(value="nihSubmissionImageService")
public class NihSubmissionImageServiceImpl
extends NihServiceBase
implements NihSubmissionImageService {
    private static final String NIH_GOV_S2S_SIL_HOST = "nih.gov.s2s.sil.host";
    private static final String NIH_GOV_S2S_SIL_PORT = "nih.gov.s2s.sil.port";
    private static final Logger LOG = LogManager.getLogger(NihSubmissionImageServiceImpl.class);

    @Override
    public String getServiceHost() {
        return this.getS2SConfigurationService().getValueAsString(NIH_GOV_S2S_SIL_HOST);
    }

    @Override
    public String getServicePort() {
        return this.getS2SConfigurationService().getValueAsString(NIH_GOV_S2S_SIL_PORT);
    }

    @Override
    public Optional<KcFile> getApplicationPdf(S2sAppSubmission submission, String dunsNumber) {
        if (submission.isMissingSubmissionData()) {
            return Optional.empty();
        }
        S2sApplication s2sApplication = submission.getS2sApplication();
        List<AttachmentData> attachments = s2sApplication.getS2sAppAttachmentList().stream().map(a -> new AttachmentData(a.getFileDataId(), a.getName(), a.getContentId(), a.getData(), a.getContentType(), "SHA-1", a.getSha1Hash(), a.getUploadUser(), a.getUploadTimestamp())).collect(Collectors.toList());
        return this.getApplicationPdf(s2sApplication.getApplication(), attachments, dunsNumber);
    }

    @Override
    public Optional<KcFile> getApplicationPdf(String xmlText, List<AttachmentData> attachments, String dunsNumber) {
        if (StringUtils.isBlank((CharSequence)xmlText) || !this.isNihServiceEnabled()) {
            return Optional.empty();
        }
        return (Optional)this.optionallyCache(Objects.hash(xmlText, attachments, dunsNumber, this.getServicePort()), () -> this.callGetApplicationPdf(xmlText, attachments, dunsNumber));
    }

    protected Optional<S2sFileDto> callGetApplicationPdf(String xmlText, List<AttachmentData> attachments, String dunsNumber) {
        GrantImageRequest request = new GrantImageRequest();
        request.setApplicationXML(xmlText);
        if (CollectionUtils.isNotEmpty(attachments)) {
            List<AttachmentAsStreamType> attachmentStreams = request.getAttachments();
            attachments.stream().map(this::toAttachmentStream).forEach(attachmentStreams::add);
        }
        try {
            this.debugLogJaxbObject(GrantImageRequest.class, request, LOG);
            SubmissionImageServiceStub serviceStub = this.createConfiguredService(dunsNumber, SubmissionImageServiceStub.class);
            ImageResponse response = serviceStub.generateGrantImage(request);
            this.debugLogJaxbObject(ImageResponse.class, response, LOG);
            LOG.debug("NOTE: Debug logging the response drains the associated input stream, resulting in an empty PDF when the stream is read later");
            if (response.getImageContent() != null) {
                DataHandler content = response.getImageContent();
                return Optional.of(new S2sFileDto(content.getName() != null ? content.getName() : "Grant Submission.pdf", content.getContentType(), content.getInputStream().readAllBytes()));
            }
        }
        catch (ImageGenerationFaultException | IOException | SOAPFaultException imageRequestError) {
            throw new S2sCommunicationException("error.nih.service.unknown", (Exception)imageRequestError);
        }
        return Optional.empty();
    }

    private AttachmentAsStreamType toAttachmentStream(AttachmentData attachment) {
        AttachmentAsStreamType attachmentStream = new AttachmentAsStreamType();
        attachmentStream.setReference(attachment.getContentId());
        attachmentStream.setContent(new DataHandler((DataSource)new ByteArrayDataSource(attachment.getContent(), attachment.getContentType())));
        return attachmentStream;
    }
}

