/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.scheduling.expr;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.kuali.coeus.sys.framework.scheduling.expr.CronExpression;
import org.kuali.coeus.sys.framework.scheduling.util.CronSpecialChars;
import org.kuali.coeus.sys.framework.scheduling.util.Time24HrFmt;

public class YearMonthDayOfWeekCronExpression
extends CronExpression {
    private CronSpecialChars weekOfMonth;
    private CronSpecialChars dayOfWeek;
    private CronSpecialChars month;
    private Integer frequencyInYear;

    public YearMonthDayOfWeekCronExpression(Date startDate, Time24HrFmt time, CronSpecialChars weekOfMonth, CronSpecialChars dayOfWeek, CronSpecialChars month, Integer frequencyInYear) throws ParseException {
        super(startDate, time);
        this.weekOfMonth = weekOfMonth;
        this.dayOfWeek = dayOfWeek;
        this.month = month;
        this.frequencyInYear = frequencyInYear;
    }

    @Override
    public String getExpression() {
        GregorianCalendar stDt = new GregorianCalendar();
        stDt.setTime(this.getStartDate());
        int stDt_year = stDt.get(1);
        StringBuilder exp = new StringBuilder();
        exp.append("0").append((Object)CronSpecialChars.SPACE);
        exp.append(this.getTime().getMinutes()).append((Object)CronSpecialChars.SPACE);
        exp.append(this.getTime().getHours()).append((Object)CronSpecialChars.SPACE);
        exp.append((Object)CronSpecialChars.QUESTION).append((Object)CronSpecialChars.SPACE);
        exp.append((Object)this.month).append((Object)CronSpecialChars.SPACE);
        if (this.weekOfMonth != CronSpecialChars.LAST) {
            exp.append((Object)this.dayOfWeek).append((Object)CronSpecialChars.HASH).append((Object)this.weekOfMonth).append((Object)CronSpecialChars.SPACE);
        } else {
            exp.append((Object)this.dayOfWeek).append((Object)CronSpecialChars.LAST).append((Object)CronSpecialChars.SPACE);
        }
        exp.append(stDt_year).append((Object)CronSpecialChars.SLASH).append(this.frequencyInYear);
        return exp.toString();
    }
}

