/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.notification;

import java.util.List;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.notification.impl.NotificationContextBase;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.service.KcNotificationModuleRoleService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.notification.AwardNotificationRenderer;
import org.kuali.kra.award.notification.AwardNotificationRoleQualifierService;

public class AwardNotificationContext
extends NotificationContextBase {
    private static final long serialVersionUID = -8704592268298791182L;
    private Award award;
    private String documentNumber;
    private String actionTypeCode;
    private String contextName;
    private List<EmailAttachment> emailAttachments;
    private String forwardName;

    public AwardNotificationContext(Award award, String actionTypeCode, String contextName, NotificationRenderer renderer, String forwardName) {
        super(renderer);
        this.award = award;
        this.documentNumber = award.getAwardDocument().getDocumentNumber();
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.forwardName = forwardName;
        this.setNotificationService(KcServiceLocator.getService(KcNotificationService.class));
        this.setNotificationModuleRoleService(KcServiceLocator.getService(KcNotificationModuleRoleService.class));
        this.setNotificationRoleQualifierService(KcServiceLocator.getService(AwardNotificationRoleQualifierService.class));
        ((AwardNotificationRoleQualifierService)this.getNotificationRoleQualifierService()).setAward(award);
    }

    public AwardNotificationContext(Award award, String actionTypeCode, String contextName) {
        this(award, actionTypeCode, contextName, KcServiceLocator.getService(AwardNotificationRenderer.class), "awardActions");
        ((AwardNotificationRenderer)this.getRenderer()).setAward(award);
    }

    public AwardNotificationContext(Award award, String actionTypeCode, String contextName, String forwardName) {
        this(award, actionTypeCode, contextName, KcServiceLocator.getService(AwardNotificationRenderer.class), forwardName);
        ((AwardNotificationRenderer)this.getRenderer()).setAward(award);
    }

    @Override
    public String getModuleCode() {
        return "1";
    }

    @Override
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    @Override
    public List<EmailAttachment> getEmailAttachments() {
        return this.emailAttachments;
    }

    public void setEmailAttachments(List<EmailAttachment> emailAttachments) {
        this.emailAttachments = emailAttachments;
    }

    public Award getAward() {
        return this.award;
    }

    public void setAward(Award award) {
        this.award = award;
    }

    @Override
    public String getForwardName() {
        return this.forwardName;
    }

    public void setForwardName(String forwardName) {
        this.forwardName = forwardName;
    }
}

