/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.lookup.keyvalue.FrequencyBaseCodeValuesFinder;
import org.kuali.kra.award.paymentreports.Report;
import org.kuali.kra.award.paymentreports.awardreports.AddAwardReportTermRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRule;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.GenericAwardReportTerm;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardReportTermRuleImpl
extends KcTransactionalDocumentRuleBase
implements AwardReportTermRule {
    private static final String REPORT_CODE_ERROR_PARM = "Type (Type)";
    private static final String FREQUENCY_BASE_CODE_ERROR_PARM = "Frequency Base (Frequency Base)";

    @Override
    public boolean processAwardReportTermBusinessRules(AwardReportTermRuleEvent event) {
        boolean validFields = true;
        String fieldStarter = "document.awardList[0].awardReportTermItems[";
        String fieldEnder = "].";
        int counter = 0;
        ArrayList<AwardReportTerm> awardReportTerms = new ArrayList<AwardReportTerm>(event.getAward().getAwardReportTermItems());
        for (AwardReportTerm awardReportTermItem : awardReportTerms) {
            validFields = this.validateRequiredFields(awardReportTermItem, fieldStarter + counter + fieldEnder) && this.isUnique(event.getAward().getAwardReportTermItems(), awardReportTermItem) && validFields;
            ++counter;
        }
        return validFields;
    }

    @Override
    public boolean processAddAwardReportTermBusinessRules(AddAwardReportTermRuleEvent event) {
        AwardReportTerm awardReportTermItem = event.getAwardReportTermItemForValidation();
        List<AwardReportTerm> items = event.getAward().getAwardReportTermItems();
        return this.validatePI(event.getAward()) && this.validateRequiredFields(event.getAwardReportTermItemForValidation(), "") && this.isUnique(items, awardReportTermItem);
    }

    private boolean validatePI(Award award) {
        boolean retVal = true;
        if (award.getPrincipalInvestigator() == null) {
            this.reportWarning("reportCode", "error.awardReportTermItem.noPI", "");
        }
        return retVal;
    }

    protected boolean isUnique(List<? extends GenericAwardReportTerm> awardReportTermItems, GenericAwardReportTerm awardReportTermItem) {
        GenericAwardReportTerm listItem;
        boolean duplicateFound = false;
        Iterator<? extends GenericAwardReportTerm> iterator = awardReportTermItems.iterator();
        while (iterator.hasNext() && !(duplicateFound = awardReportTermItem != (listItem = iterator.next()) && listItem.equalsInitialFields(awardReportTermItem))) {
        }
        if (duplicateFound && !GlobalVariables.getMessageMap().containsMessageKey("error.awardReportTermItem.notunique")) {
            this.reportError("awardReportTerm", "error.awardReportTermItem.notunique", new String[0]);
        }
        return !duplicateFound;
    }

    protected boolean validateRequiredFields(GenericAwardReportTerm awardReportTermItem, String fieldPrePend) {
        FrequencyBaseCodeValuesFinder finder;
        boolean retVal = true;
        if (StringUtils.isBlank((CharSequence)awardReportTermItem.getReportCode())) {
            retVal = false;
            this.reportError(fieldPrePend + "reportCode", "error.required", REPORT_CODE_ERROR_PARM);
        }
        if (StringUtils.isBlank((CharSequence)awardReportTermItem.getFrequencyCode()) && !StringUtils.isBlank((CharSequence)awardReportTermItem.getOspDistributionCode())) {
            retVal = false;
            this.reportError(fieldPrePend + "frequencyCode", "error.awardReportTermItem.frequencyRequired", new String[0]);
        }
        if (StringUtils.isBlank((CharSequence)awardReportTermItem.getFrequencyBaseCode()) && (finder = new FrequencyBaseCodeValuesFinder(awardReportTermItem.getFrequencyCode())).getKeyValues().size() > 1) {
            retVal = false;
            this.reportError(fieldPrePend + "frequencyBaseCode", "error.required", FREQUENCY_BASE_CODE_ERROR_PARM);
        }
        if (StringUtils.isBlank((CharSequence)awardReportTermItem.getOspDistributionCode()) && this.isFinalReport(awardReportTermItem.getReportCode()) && StringUtils.isNotBlank((CharSequence)awardReportTermItem.getFrequencyCode())) {
            this.reportError(fieldPrePend + "ospDistributionCode", "error.awardReportTermItem.ospRequired", new String[0]);
            retVal = false;
        }
        return retVal;
    }

    private boolean isFinalReport(String reportCode) {
        boolean retVal = false;
        if (StringUtils.isNotBlank((CharSequence)reportCode)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("REPORT_CODE", reportCode);
            Report report = (Report)this.getBusinessObjectService().findMatching(Report.class, fieldValues).iterator().next();
            retVal = report.getFinalReportFlag();
        }
        return retVal;
    }

    public boolean processAwardReportTermBusinessRules(GenericAwardReportTerm awardReportTerm, List<? extends GenericAwardReportTerm> existingItems) {
        return this.validateRequiredFields(awardReportTerm, "") && this.isUnique(existingItems, awardReportTerm);
    }
}

