/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.xmlstream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.award.printing.xmlstream.AwardBudgetBaseStream;
import org.kuali.kra.printing.schema.AmountInfoType;
import org.kuali.kra.printing.schema.AwardNoticeDocument;
import org.kuali.kra.printing.schema.AwardType;

public class AwardBudgetHierarchyXmlStream
extends AwardBudgetBaseStream {
    private AwardHierarchyService awardHierarchyService;

    @Override
    public Map<String, AwardNoticeDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        HashMap<String, AwardNoticeDocument> budgetHierarchyMap = new HashMap<String, AwardNoticeDocument>();
        Award award = (Award)printableBusinessObject;
        AwardNoticeDocument awardNoticeDocument = (AwardNoticeDocument)AwardNoticeDocument.Factory.newInstance();
        AwardNoticeDocument.AwardNotice awardNotice = (AwardNoticeDocument.AwardNotice)AwardNoticeDocument.AwardNotice.Factory.newInstance();
        awardNotice.setAward(this.getAwardType(award));
        awardNotice.setSchoolInfo(this.getSchoolInfoType());
        awardNoticeDocument.setAwardNotice(awardNotice);
        awardNoticeDocument.setAwardNotice(awardNotice);
        budgetHierarchyMap.put(AwardPrintType.AWARD_BUDGET_HIERARCHY.getAwardPrintType(), awardNoticeDocument);
        return budgetHierarchyMap;
    }

    private AwardType getAwardType(Award award) {
        AwardType awardType = (AwardType)AwardType.Factory.newInstance();
        awardType.setAwardAmountInfo(this.getAwardAmountInfo(award));
        awardType.setAwardTransactionInfo(this.getAwardTransactiontInfo(award));
        return awardType;
    }

    private AwardType.AwardAmountInfo getAwardAmountInfo(Award award) {
        AwardType.AwardAmountInfo awardAmountInfo = (AwardType.AwardAmountInfo)AwardType.AwardAmountInfo.Factory.newInstance();
        List<AmountInfoType> amountInfoTypes = new ArrayList<AmountInfoType>();
        AwardHierarchy branchNode = this.getAwardHierarchyService().loadFullHierarchyFromAnyNode(award.getParentNumber());
        List awards = this.businessObjectService.findMatching(Award.class, Collections.singletonMap("awardNumber", branchNode.getAwardNumber()));
        Award parentAward = !awards.isEmpty() ? (Award)awards.iterator().next() : null;
        AmountInfoType amountInfoType = this.setAwardAmountInfo(parentAward, parentAward.getLastAwardAmountInfo());
        amountInfoTypes = this.recurseTree(branchNode, amountInfoTypes);
        amountInfoTypes.add(0, amountInfoType);
        awardAmountInfo.setAmountInfoArray(amountInfoTypes.toArray(new AmountInfoType[0]));
        return awardAmountInfo;
    }

    private AmountInfoType setAwardAmountInfo(Award award, AwardAmountInfo awardAmount) {
        AmountInfoType amountInfoType = (AmountInfoType)AmountInfoType.Factory.newInstance();
        if (award.getAccountNumber() != null) {
            amountInfoType.setAccountNumber(award.getAccountNumber());
        }
        if (awardAmount.getTransactionId() != null) {
            amountInfoType.setAmountSequenceNumber(awardAmount.getTransactionId().intValue());
        }
        if (awardAmount.getAmountObligatedToDate() != null) {
            amountInfoType.setAmtObligatedToDate(awardAmount.getAmountObligatedToDate().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedChange() != null) {
            amountInfoType.setAnticipatedChange(awardAmount.getAnticipatedChange().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedChangeDirect() != null) {
            amountInfoType.setAnticipatedChangeDirect(awardAmount.getAnticipatedChangeDirect().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedChangeIndirect() != null) {
            amountInfoType.setAnticipatedChangeIndirect(awardAmount.getAnticipatedChangeIndirect().bigDecimalValue());
        }
        if (awardAmount.getAntDistributableAmount() != null) {
            amountInfoType.setAnticipatedDistributableAmt(awardAmount.getAntDistributableAmount().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedTotalAmount() != null) {
            amountInfoType.setAnticipatedTotalAmt(awardAmount.getAnticipatedTotalAmount().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedTotalDirect() != null) {
            amountInfoType.setAnticipatedTotalDirect(awardAmount.getAnticipatedTotalDirect().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedTotalIndirect() != null) {
            amountInfoType.setAnticipatedTotalIndirect(awardAmount.getAnticipatedTotalIndirect().bigDecimalValue());
        }
        if (award.getAwardNumber() != null) {
            amountInfoType.setAwardNumber(award.getAwardNumber());
        }
        if (awardAmount.getObligationExpirationDate() != null) {
            amountInfoType.setObligationExpirationDate(this.dateTimeService.getCalendar((Date)awardAmount.getObligationExpirationDate()));
        }
        if (awardAmount.getObligatedTotalIndirect() != null) {
            amountInfoType.setObligatedTotalIndirect(awardAmount.getObligatedTotalIndirect().bigDecimalValue());
        }
        if (awardAmount.getObligatedTotalDirect() != null) {
            amountInfoType.setObligatedTotalDirect(awardAmount.getObligatedTotalDirect().bigDecimalValue());
        }
        if (awardAmount.getCurrentFundEffectiveDate() != null) {
            amountInfoType.setCurrentFundEffectiveDate(this.dateTimeService.getCalendar((Date)awardAmount.getCurrentFundEffectiveDate()));
        }
        return amountInfoType;
    }

    private List<AmountInfoType> recurseTree(AwardHierarchy branchNode, List<AmountInfoType> amountInfoTypes) {
        Map<String, Object> criteria = CollectionUtils.zipMap(new String[]{"parentAwardNumber", "active"}, new Object[]{branchNode.getAwardNumber(), Boolean.TRUE});
        List c = this.businessObjectService.findMatchingOrderBy(AwardHierarchy.class, criteria, "awardNumber", true);
        branchNode.setChildren(new ArrayList<AwardHierarchy>(c));
        if (branchNode.hasChildren()) {
            for (AwardHierarchy childNode : branchNode.getChildren()) {
                AwardAmountInfo awardAmount = childNode.getAward().getLastAwardAmountInfo();
                amountInfoTypes.add(this.setAwardAmountInfo(childNode.getAward(), awardAmount));
                childNode.setParent(branchNode);
                childNode.setRoot(branchNode.getRoot());
                this.recurseTree(childNode, amountInfoTypes);
            }
        }
        return amountInfoTypes;
    }

    public AwardHierarchyService getAwardHierarchyService() {
        return this.awardHierarchyService;
    }

    public void setAwardHierarchyService(AwardHierarchyService awardHierarchyService) {
        this.awardHierarchyService = awardHierarchyService;
    }
}

