/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.rules;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.rules.NegotiationActivityAddRule;
import org.kuali.kra.negotiations.rules.NegotiationActivityAddRuleEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class NegotiationActivityRuleImpl
implements NegotiationActivityAddRule {
    private static final String START_DATE_PROPERTY = "startDate";
    private static final String END_DATE_PROPERTY = "endDate";
    private static final String ACTIVITY_TYPE = "activityType";
    private static final String ACTIVITY_TYPE_ID = "activityTypeId";
    private static final String LOCATION = "location";
    private static final String LOCATION_ID = "locationId";
    private static final String DESCRIPTION = "description";
    private static final String ACTIVITY_TYPE_DESC = "Activity Type (Activity Type)";
    private static final String LOCATION_DESC = "Location (Location)";
    private static final String ACTIVITY_START_DATE_DESC = "Activity Start Date (Activity Start Date)";
    private static final String ACTIVITY_DESCRIPTION_DESC = "Activity Description (Activity Description)";
    private ErrorReporter errorReporter;

    @Override
    public boolean processAddNegotiationActivityRule(NegotiationActivityAddRuleEvent event) {
        boolean result = true;
        NegotiationDocument negotiationDoc = (NegotiationDocument)event.getDocument();
        Negotiation negotiation = negotiationDoc.getNegotiation();
        NegotiationActivity newActivity = event.getNewActivity();
        GlobalVariables.getMessageMap().addToErrorPath(event.getErrorPathPrefix());
        GlobalVariables.getMessageMap().removeFromErrorPath(event.getErrorPathPrefix());
        return result &= this.validateNegotiationActivity(newActivity, negotiation);
    }

    public boolean validateNegotiationActivity(NegotiationActivity activity, Negotiation negotiation) {
        boolean result = true;
        activity.refreshReferenceObject(ACTIVITY_TYPE);
        if (activity.getActivityType() == null) {
            result = false;
            this.getErrorReporter().reportError(ACTIVITY_TYPE_ID, "error.required", ACTIVITY_TYPE_DESC);
        }
        activity.refreshReferenceObject(LOCATION);
        if (activity.getLocation() == null) {
            result = false;
            this.getErrorReporter().reportError(LOCATION_ID, "error.required", LOCATION_DESC);
        }
        if (activity.getStartDate() == null) {
            result = false;
            this.getErrorReporter().reportError(START_DATE_PROPERTY, "error.required", ACTIVITY_START_DATE_DESC);
        }
        if (StringUtils.isBlank((CharSequence)activity.getDescription())) {
            result = false;
            this.getErrorReporter().reportError(DESCRIPTION, "error.required", ACTIVITY_DESCRIPTION_DESC);
        }
        if (activity.getStartDate() != null && negotiation.getNegotiationStartDate() != null && activity.getStartDate().compareTo(negotiation.getNegotiationStartDate()) < 0) {
            result = false;
            this.getErrorReporter().reportError(START_DATE_PROPERTY, "negotiation.error.activity.start.before.negotiation.start", new String[0]);
        }
        if (activity.getStartDate() != null && activity.getEndDate() != null && activity.getStartDate().compareTo(activity.getEndDate()) > 0) {
            result = false;
            this.getErrorReporter().reportError(END_DATE_PROPERTY, "negotiation.error.activity.start.before.end", new String[0]);
        }
        if (activity.getEndDate() != null && negotiation.getNegotiationEndDate() != null && activity.getEndDate().compareTo(negotiation.getNegotiationEndDate()) > 0) {
            this.getErrorReporter().reportWarning(END_DATE_PROPERTY, "negotiation.error.activity.end.after.negotiation.end", new String[0]);
        }
        return result;
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        }
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }
}

