/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.data.migration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.api.output.InfoResult;
import org.flywaydb.core.api.output.MigrateErrorResult;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.OperationResultBase;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.springframework.beans.factory.InitializingBean;

public class FlywayExecutor
implements InitializingBean {
    private static final Logger LOG = LogManager.getLogger(FlywayExecutor.class);
    private Flyway flyway;

    public void afterPropertiesSet() {
        Boolean enabled = this.getValueAsBoolean("kc.flyway.enabled", "KC_FLYWAY_ENABLED");
        if (enabled != null && enabled.booleanValue()) {
            String commands = this.getValueAsString("kc.flyway.commands", "KC_FLYWAY_COMMANDS");
            if (StringUtils.isNotBlank((CharSequence)commands)) {
                this.execute(commands);
            } else {
                LOG.warn("Flyway is enabled but no flyway commands are found.");
            }
        } else {
            LOG.info("Disabled flyway");
        }
    }

    private void execute(String commands) {
        Arrays.stream(commands.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(String::toLowerCase).distinct().map(command -> CollectionUtils.entry(command, this.findMethod((String)command))).forEach(cmdEntry -> {
            String command = (String)cmdEntry.getKey();
            Method cmdMethod = (Method)cmdEntry.getValue();
            if (cmdMethod != null) {
                LOG.info("Executing flyway command [" + command + "]");
                try {
                    Object result = cmdMethod.invoke((Object)this.flyway, new Object[0]);
                    if (!LOG.isInfoEnabled()) return;
                    LOG.info("Executed flyway command [" + command + "] with result [" + FlywayExecutor.resultToString(result) + "]");
                    return;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOG.error("Failed flyway command [" + command + "]", (Throwable)e);
                    throw new RuntimeException(e);
                }
            } else {
                LOG.error("Not Found flyway command [" + command + "]");
            }
        });
    }

    private static String resultToString(Object result) {
        if (result instanceof MigrateErrorResult) {
            return FlywayExecutor.resultToString((MigrateErrorResult)result);
        }
        if (result instanceof MigrateResult) {
            return FlywayExecutor.resultToString((MigrateResult)result);
        }
        if (result instanceof InfoResult) {
            return FlywayExecutor.resultToString((InfoResult)result);
        }
        if (result instanceof MigrationInfoServiceImpl) {
            return FlywayExecutor.resultToString(((MigrationInfoServiceImpl)result).getInfoResult());
        }
        if (result instanceof CleanResult) {
            return FlywayExecutor.resultToString((CleanResult)result);
        }
        if (result instanceof RepairResult) {
            return FlywayExecutor.resultToString((RepairResult)result);
        }
        if (result instanceof ValidateResult) {
            return FlywayExecutor.resultToString((ValidateResult)result);
        }
        if (result instanceof BaselineResult) {
            return FlywayExecutor.resultToString((BaselineResult)result);
        }
        if (result instanceof HtmlResult) {
            return FlywayExecutor.resultToString((HtmlResult)result);
        }
        if (result instanceof OperationResultBase) {
            return FlywayExecutor.resultToString((OperationResultBase)result);
        }
        return ToStringBuilder.reflectionToString((Object)result, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true);
    }

    private static String resultToString(MigrateErrorResult result) {
        return FlywayExecutor.append(new ToStringBuilder((Object)result, ToStringStyle.SHORT_PREFIX_STYLE), (MigrateResult)result).append("error", (Object)new ToStringBuilder((Object)result.error, ToStringStyle.SHORT_PREFIX_STYLE).append("errorCode", (Object)result.error.errorCode).append("message", (Object)result.error.message).append("stackTrace", (Object)result.error.stackTrace).append("lineNumber", (Object)result.error.lineNumber).append("path", (Object)result.error.path).append("cause", (Object)ToStringBuilder.reflectionToString((Object)result.error.cause, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true)).toString()).toString();
    }

    private static String resultToString(MigrateResult result) {
        return FlywayExecutor.append(new ToStringBuilder((Object)result, ToStringStyle.SHORT_PREFIX_STYLE), result).toString();
    }

    private static ToStringBuilder append(ToStringBuilder toStringBuilder, MigrateResult result) {
        return FlywayExecutor.appendHtmlResult(toStringBuilder, (HtmlResult)result).append("initialSchemaVersion", result.success).append("targetSchemaVersion", (Object)result.targetSchemaVersion).append("schemaName", (Object)result.schemaName).append("migrationsExecuted", result.migrationsExecuted).append("success", result.success).append("flywayVersion", (Object)result.flywayVersion).append("database", (Object)result.database).append("warnings", (Object)result.warnings).append("databaseType", (Object)result.databaseType).append("migrations", result.migrations.stream().map(migration -> ToStringBuilder.reflectionToString((Object)migration, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true)).toList());
    }

    private static String resultToString(InfoResult result) {
        return FlywayExecutor.appendHtmlResult(new ToStringBuilder((Object)result, ToStringStyle.SHORT_PREFIX_STYLE), (HtmlResult)result).append("schemaVersion", (Object)result.schemaVersion).append("schemaName", (Object)result.schemaName).append("flywayVersion", (Object)result.flywayVersion).append("database", (Object)result.database).append("allSchemasEmpty", result.allSchemasEmpty).append("migrations", result.migrations.stream().map(migration -> new ToStringBuilder(migration, ToStringStyle.SHORT_PREFIX_STYLE).append("category", (Object)migration.category).append("version", (Object)migration.version).append("rawVersion", (Object)migration.rawVersion).append("installedOnUTC", (Object)migration.installedOnUTC).append("state", (Object)migration.state).append("undoable", (Object)migration.undoable).append("installedBy", (Object)migration.installedBy).append("shouldExecuteExpression", (Object)migration.shouldExecuteExpression).append("executionTime", migration.executionTime).toString()).toList()).toString();
    }

    private static String resultToString(CleanResult result) {
        return ToStringBuilder.reflectionToString((Object)result, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true);
    }

    private static String resultToString(RepairResult result) {
        return FlywayExecutor.appendOperationResultBase(new ToStringBuilder((Object)result, ToStringStyle.SHORT_PREFIX_STYLE), (OperationResultBase)result).append("repairActions", (Object)result.repairActions).append("migrationsRemoved", result.migrationsRemoved.stream().map(repairAction -> ToStringBuilder.reflectionToString((Object)repairAction, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true)).toList()).append("migrationsDeleted", result.migrationsDeleted.stream().map(repairAction -> ToStringBuilder.reflectionToString((Object)repairAction, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true)).toList()).append("migrationsAligned", result.migrationsAligned.stream().map(repairAction -> ToStringBuilder.reflectionToString((Object)repairAction, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true)).toList()).toString();
    }

    private static String resultToString(ValidateResult result) {
        return FlywayExecutor.appendOperationResultBase(new ToStringBuilder((Object)result, ToStringStyle.SHORT_PREFIX_STYLE), (OperationResultBase)result).append("errorDetails", (Object)ToStringBuilder.reflectionToString((Object)result.operation, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true)).append("validationSuccessful", result.validationSuccessful).append("validateCount", result.validateCount).append("invalidMigrations", result.invalidMigrations.stream().map(repairAction -> ToStringBuilder.reflectionToString((Object)repairAction, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true)).toList()).toString();
    }

    private static String resultToString(BaselineResult result) {
        return ToStringBuilder.reflectionToString((Object)result, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true);
    }

    private static String resultToString(HtmlResult result) {
        return ToStringBuilder.reflectionToString((Object)result, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true);
    }

    private static String resultToString(OperationResultBase result) {
        return ToStringBuilder.reflectionToString((Object)result, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true);
    }

    private static ToStringBuilder appendHtmlResult(ToStringBuilder toStringBuilder, HtmlResult result) {
        return toStringBuilder.append("timestamp", (Object)result.getTimestamp()).append("operation", (Object)result.getOperation()).append("exception", (Object)result.getException()).append("licenseFailed", result.isLicenseFailed());
    }

    private static ToStringBuilder appendOperationResultBase(ToStringBuilder toStringBuilder, OperationResultBase result) {
        return toStringBuilder.append("flywayVersion", (Object)result.flywayVersion).append("database", (Object)result.database).append("warnings", (Object)result.warnings).append("operation", (Object)result.operation);
    }

    private Method findMethod(String command) {
        try {
            return this.flyway.getClass().getMethod(command, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getValueAsString(String xmlCfg, String envCfg) {
        String cfg = ConfigContext.getConfig().getProperty(xmlCfg);
        String envXml = ConfigContext.getConfig().getProperty(envCfg);
        String env = System.getenv(envCfg);
        if (StringUtils.isNotBlank((CharSequence)envXml)) {
            return envXml;
        }
        if (StringUtils.isNotBlank((CharSequence)env)) {
            return env;
        }
        if (StringUtils.isNotBlank((CharSequence)cfg)) {
            return cfg;
        }
        return null;
    }

    private Boolean getValueAsBoolean(String xmlCfg, String envCfg) {
        Boolean cfg = ConfigContext.getConfig().getBooleanProperty(xmlCfg);
        Boolean envXml = ConfigContext.getConfig().getBooleanProperty(envCfg);
        String env = System.getenv(envCfg);
        if (envXml != null) {
            return envXml;
        }
        if (StringUtils.isNotBlank((CharSequence)env)) {
            return Boolean.valueOf(env);
        }
        if (cfg != null) {
            return cfg;
        }
        return null;
    }

    public Flyway getFlyway() {
        return this.flyway;
    }

    public void setFlyway(Flyway flyway) {
        this.flyway = flyway;
    }
}

