/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.api;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.award.api.AwardControllerBase;
import org.kuali.coeus.award.dto.AwardBudgetExtDto;
import org.kuali.coeus.award.dto.AwardDto;
import org.kuali.coeus.award.dto.AwardPersonDto;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.VersioningService;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLogger;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLoggerFactory;
import org.kuali.coeus.sys.framework.rest.NotImplementedException;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyBean;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.dao.AwardDao;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.award.home.AwardTransferringSponsor;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposalBean;
import org.kuali.kra.award.home.keywords.AwardScienceKeyword;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachment;
import org.kuali.kra.award.notesandattachments.notes.AwardNotepad;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseout;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentSchedule;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyExistenceService;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api/v2"})
@Controller(value="awardController")
public class AwardController
extends AwardControllerBase
implements InitializingBean {
    public static final String PENDING_VERSION_ERROR = "There exists a pending version of this award. It cannot be versioned.";
    @Autowired
    @Qualifier(value="awardDao")
    private AwardDao awardDao;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="versionHistoryService")
    private VersionHistoryService versionHistoryService;
    @Autowired
    @Qualifier(value="versioningService")
    private VersioningService versioningService;
    @Autowired
    @Qualifier(value="awardService")
    private AwardService awardService;
    @Autowired
    @Qualifier(value="routeHeaderService")
    private RouteHeaderService routeHeaderService;
    @Autowired
    @Qualifier(value="institutionalProposalService")
    private InstitutionalProposalService institutionalProposalService;
    @Autowired
    @Qualifier(value="timeAndMoneyExistenceService")
    private TimeAndMoneyExistenceService timeAndMoneyExistenceService;
    @Autowired
    @Qualifier(value="restAuditLoggerFactory")
    private RestAuditLoggerFactory restAuditLoggerFactory;
    private List<String> awardDtoPersonProperties;
    private List<String> awardDtoProperties;

    @RequestMapping(method={RequestMethod.GET}, value={"/awards/{awardId}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    AwardDto getAward(@PathVariable Long awardId, @RequestParam(value="includeBudgets", required=false) boolean includeBudgets) {
        this.assertUserHasReadAccess();
        this.commonApiService.clearErrors();
        Award award = this.getAwardDao().getAward(awardId);
        if (award == null) {
            throw new ResourceNotFoundException("Award with award id " + awardId + " not found.");
        }
        return this.translateAward(includeBudgets, award);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/awards"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    List<AwardDto> getAwardByCriteria(@RequestParam(value="awardNumber", required=false) String awardNumber, @RequestParam(value="awardHierarchy", required=false) String awardHierarchy, @RequestParam(value="includeBudgets", required=false) boolean includeBudgets, @RequestParam(value="activeVersionOnly", required=false) boolean activeVersionOnly) {
        this.assertUserHasReadAccess();
        this.commonApiService.clearErrors();
        List<AwardDto> awardDtos = new ArrayList<AwardDto>();
        if (StringUtils.isBlank((CharSequence)awardNumber) && StringUtils.isBlank((CharSequence)awardHierarchy)) {
            throw new NotImplementedException("GET all awards not yet implemented in version 2.");
        }
        if (StringUtils.isNotBlank((CharSequence)awardNumber)) {
            List<Award> awards = this.getAwardDao().getAwardByAwardNumber(awardNumber, activeVersionOnly);
            awardDtos = this.translateAwards(includeBudgets, awards);
        } else if (StringUtils.isNotBlank((CharSequence)awardHierarchy)) {
            List<Award> awards = this.getAwardDao().getAwardByAwardHierarchy(awardHierarchy);
            awardDtos = this.translateAwards(includeBudgets, awards);
        }
        return awardDtos;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/awards/{awardId}"}, params={"version"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    AwardDto versionAward(@RequestBody AwardDto awardDto, @PathVariable Long awardId) throws Exception {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        Award award = this.getAwardDao().getAward(awardId);
        if (award == null) {
            throw new ResourceNotFoundException("Award with award id " + awardId + " not found.");
        }
        return this.versionAward(awardDto, award);
    }

    public AwardDto versionAward(AwardDto awardDto, Award awardToVersion) throws WorkflowException {
        AwardDocument oldAwardDocument = this.commonApiService.getDocumentFromDocId(awardToVersion.getAwardDocument().getDocumentNumber(), AwardDocument.class);
        String rootAwardNumber = this.awardService.getRootAwardNumber(awardToVersion.getAwardNumber());
        if (this.timeAndMoneyExistenceService.validateTimeAndMoneyRule(awardToVersion, rootAwardNumber)) {
            if (awardToVersion.getAwardSequenceStatus().equalsIgnoreCase("PENDING")) {
                throw new UnprocessableEntityException(PENDING_VERSION_ERROR);
            }
            VersionHistory foundPending = this.versionHistoryService.findPendingVersion(awardToVersion);
            if (foundPending != null) {
                throw new UnprocessableEntityException(PENDING_VERSION_ERROR);
            }
            awardToVersion.setNewVersion(true);
            Award newAwardVersion = this.versioningService.createNewVersion(awardToVersion);
            List<AwardAmountInfo> oldAwardAmountInfos = newAwardVersion.getAwardAmountInfos();
            this.commonApiService.updateDataObjectFromDto(newAwardVersion, awardDto);
            newAwardVersion.setAwardAmountInfos(oldAwardAmountInfos);
            this.defaultValues(newAwardVersion, awardDto);
            newAwardVersion.getAwardDocument().setAward(newAwardVersion);
            this.translateCollections(awardDto, newAwardVersion.getAwardDocument());
            AwardDocument newAwardDocument = this.awardService.generateAndPopulateAwardDocument(oldAwardDocument, newAwardVersion);
            newAwardDocument.getAward().setAwardTransactionTypeCode(awardDto.getAwardTransactionTypeCode());
            this.addFundingProposals(awardDto, newAwardVersion);
            this.changeDates(newAwardDocument.getAward(), awardDto);
            newAwardDocument = (AwardDocument)this.commonApiService.saveDocument(newAwardDocument);
            this.awardService.updateAwardSequenceStatus(newAwardDocument.getAward(), VersionStatus.PENDING);
            this.versionHistoryService.updateVersionHistory(newAwardDocument.getAward(), VersionStatus.PENDING, this.globalVariableService.getUserSession().getPrincipalId());
            return this.getAwardApiService().convertAwardToDto(newAwardDocument.getAward());
        }
        throw new UnprocessableEntityException("Award cannot be versioned. Pending T&M document exist for this award.");
    }

    public AwardDto createAward(AwardDto awardDto) throws WorkflowException {
        return this.createAward(awardDto, false);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/awards/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public AwardDto createAward(@RequestBody AwardDto awardDto, @RequestParam(value="submit", required=false) boolean submit) throws WorkflowException {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        Award award = this.commonApiService.convertObject(awardDto, Award.class);
        this.defaultValues(award, awardDto);
        AwardDocument awardDocument = (AwardDocument)this.documentService.getNewDocument(AwardDocument.class);
        awardDocument.setAward(award);
        awardDocument.getDocumentHeader().setDocumentDescription(awardDto.getDocumentDescription());
        this.translateCollections(awardDto, awardDocument);
        this.changeDates(award, awardDto);
        this.addFundingProposals(awardDto, award);
        this.addCfdas(awardDto, award);
        this.awardService.checkAwardNumber(award);
        this.awardService.updateCurrentAwardAmountInfo(award);
        AwardDocument newDocument = (AwardDocument)this.commonApiService.saveDocument(awardDocument);
        AwardDto newAwardDto = this.getAwardApiService().convertAwardToDto(newDocument.getAward());
        this.versionHistoryService.updateVersionHistory(award, VersionStatus.PENDING, this.globalVariableService.getUserSession().getPrincipalName());
        this.awardService.updateAwardSequenceStatus(award, VersionStatus.PENDING);
        AwardHierarchyBean awardHierarchyBean = new AwardHierarchyBean();
        awardHierarchyBean.setRootNodes(new TreeMap<String, AwardHierarchy>());
        awardHierarchyBean.createDefaultAwardHierarchy("000000-00000", award.getAwardNumber(), award);
        awardHierarchyBean.saveHierarchyChanges();
        RestAuditLogger auditLogger = this.restAuditLoggerFactory.getNewAuditLogger(AwardDto.class, this.awardDtoProperties);
        auditLogger.addNewItem(awardDto);
        auditLogger.saveAuditLog();
        if (submit) {
            this.submitDocument(newDocument);
        }
        return newAwardDto;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/awards/{awardId}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    void deleteAward(@PathVariable Long awardId) throws WorkflowException {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        AwardDocument awardDocument = this.getAwardDocumentById(awardId);
        DocumentRouteHeaderValue routeHeader = this.routeHeaderService.getRouteHeader(awardDocument.getDocumentHeader().getWorkflowDocument().getDocumentId());
        if (!routeHeader.getDocRouteStatus().equalsIgnoreCase("X")) {
            try {
                this.documentService.cancelDocument((Document)awardDocument, "X");
            }
            catch (InvalidActionTakenException e) {
                throw new UnprocessableEntityException("Award " + awardId + " is not in a state to be cancelled.");
            }
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/awards/{awardId}"}, params={"submit"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void submitDocument(@PathVariable Long awardId) {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        AwardDocument awardDocument = this.getAwardDocumentById(awardId);
        this.submitDocument(awardDocument);
    }

    private void submitDocument(AwardDocument awardDocument) {
        this.commonApiService.routeDocument(awardDocument);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/awards/{awardId}/budgets/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    List<AwardBudgetExtDto> getBudgets(@PathVariable Long awardId) {
        this.assertUserHasBudgetReadAccess();
        this.commonApiService.clearErrors();
        Award award = this.getAwardDao().getAward(awardId);
        if (award == null) {
            throw new ResourceNotFoundException("Award with award id " + awardId + " not found.");
        }
        return award.getBudgets().stream().map(budget -> this.commonApiService.convertObject(budget, AwardBudgetExtDto.class)).collect(Collectors.toList());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/awards/{awardId}/award-persons/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    List<AwardPersonDto> addAwardPersons(@RequestBody List<AwardPersonDto> awardPersonsDto, @PathVariable Long awardId) throws WorkflowException {
        this.assertUserHasAwardPersonWriteAccess();
        this.commonApiService.clearErrors();
        AwardDocument awardDocument = this.getAwardDocumentById(awardId);
        this.addPersons(awardPersonsDto, awardDocument);
        this.documentService.saveDocument((Document)awardDocument);
        return this.getAwardPersonDtos(awardDocument);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/v1/awards/{awardId}/award-persons/"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    List<AwardPersonDto> getAwardPersons(@PathVariable Long awardId) {
        this.assertUserHasAwardPersonReadAccess();
        this.commonApiService.clearErrors();
        AwardDocument awardDocument = this.getAwardDocumentById(awardId);
        return this.getAwardPersonDtos(awardDocument);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/v1/awards/{awardId}/award-persons/{id}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    void deletePerson(@PathVariable Long awardId, @PathVariable Long id) throws WorkflowException {
        this.assertUserHasAwardPersonWriteAccess();
        this.commonApiService.clearErrors();
        AwardDocument awardDocument = this.getAwardDocumentById(awardId);
        if (awardDocument.getAward().getProjectPersons() != null) {
            AwardPerson person = this.getAwardPerson(id, awardDocument.getAward().getProjectPersons());
            awardDocument.getAward().getProjectPersons().remove(person);
            this.commonApiService.saveDocument(awardDocument);
            RestAuditLogger auditLogger = this.restAuditLoggerFactory.getNewAuditLogger(AwardPersonDto.class, this.awardDtoPersonProperties);
            auditLogger.addDeletedItem(this.getCommonApiService().convertObject(person, AwardPersonDto.class));
            auditLogger.saveAuditLog();
        }
    }

    protected AwardPerson getAwardPerson(Long awardContactId, List<AwardPerson> awardPersons) {
        Optional<AwardPerson> person = awardPersons.stream().filter(awardPerson -> awardPerson.getAwardContactId().equals(awardContactId)).findFirst();
        if (person.isEmpty()) {
            throw new ResourceNotFoundException("Person with award contact id " + awardContactId + " not found.");
        }
        return person.get();
    }

    protected List<AwardPersonDto> getAwardPersonDtos(AwardDocument awardDocument) {
        return awardDocument.getAward().getProjectPersons().stream().map(awardPerson -> this.commonApiService.convertObject(awardPerson, AwardPersonDto.class)).collect(Collectors.toList());
    }

    protected AwardDocument getAwardDocument(String documentNumber) {
        return this.commonApiService.getDocumentFromDocId(documentNumber, AwardDocument.class);
    }

    public AwardDocument getAwardDocumentById(Long awardId) {
        Award award = this.awardDao.getAward(awardId);
        if (award == null) {
            throw new ResourceNotFoundException("Award with award id " + awardId + " not found.");
        }
        return this.commonApiService.getDocumentFromDocId(award.getAwardDocument().getDocumentNumber(), AwardDocument.class);
    }

    public void addFundingProposals(AwardDto awardDto, Award award) {
        award.setFundingProposals(new ArrayList<AwardFundingProposal>());
        if (CollectionUtils.isNotEmpty(awardDto.getFundingProposals())) {
            awardDto.getFundingProposals().forEach(awardFundingProposalDto -> {
                AwardFundingProposalBean fundingProposalBean = new AwardFundingProposalBean();
                fundingProposalBean.setMergeTypeCode(awardFundingProposalDto.getMergeTypeCode());
                InstitutionalProposal institutionalProposal = this.institutionalProposalService.getInstitutionalProposal(awardFundingProposalDto.getProposalId().toString());
                if (institutionalProposal == null) {
                    throw new UnprocessableEntityException("The funding proposal with proposal id " + awardFundingProposalDto.getProposalId() + " cannot be located");
                }
                fundingProposalBean.setNewFundingProposal(institutionalProposal);
                fundingProposalBean.validateAndPerformFeed(new ArrayList<Award>(), award);
            });
        }
    }

    public void addCfdas(AwardDto awardDto, Award award) {
        if (StringUtils.isNotBlank((CharSequence)awardDto.getCfdaNumber())) {
            AwardCfda cfda = new AwardCfda();
            cfda.setAward(award);
            cfda.setAwardNumber(award.getAwardNumber());
            cfda.setAwardId(award.getAwardId());
            cfda.setSequenceNumber(award.getSequenceNumber());
            cfda.setCfdaNumber(awardDto.getCfdaNumber());
            award.getAwardCfdas().add(cfda);
        }
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setRouteHeaderService(RouteHeaderService routeHeaderService) {
        this.routeHeaderService = routeHeaderService;
    }

    public void setRestAuditLoggerFactory(RestAuditLoggerFactory restAuditLoggerFactory) {
        this.restAuditLoggerFactory = restAuditLoggerFactory;
    }

    protected List<String> getDtoProperties(Class<?> dtoClass) throws IntrospectionException {
        return Arrays.stream(Introspector.getBeanInfo(dtoClass).getPropertyDescriptors()).map(FeatureDescriptor::getName).filter(prop -> !"class".equals(prop)).collect(Collectors.toList());
    }

    public void afterPropertiesSet() throws Exception {
        this.awardDtoProperties = this.getDtoProperties(AwardDto.class);
        this.awardDtoPersonProperties = this.getDtoProperties(AwardPersonDto.class);
    }

    protected void defaultValues(Award award, AwardDto awardDto) {
        if (award.getAwardAmountInfos() == null) {
            award.initializeAwardAmountInfoObjects();
        }
        if (award.getAwardCostShares() == null) {
            award.setAwardCostShares(new ArrayList<AwardCostShare>());
        }
        if (award.getApprovedForeignTravelTrips() == null) {
            award.setApprovedForeignTravelTrips(new ArrayList<AwardApprovedForeignTravel>());
        }
        if (award.getFundingProposals() == null) {
            award.setFundingProposals(new ArrayList<AwardFundingProposal>());
        }
        if (award.getAllFundingProposals() == null) {
            award.setAllFundingProposals(new ArrayList<AwardFundingProposal>());
        }
        if (award.getAwardComments() == null) {
            award.setAwardComments(new ArrayList<AwardComment>());
        }
        if (award.getAwardReportTermItems() == null) {
            award.setAwardReportTermItems(new ArrayList<AwardReportTerm>());
        }
        if (award.getAwardSponsorTerms() == null) {
            award.setAwardSponsorTerms(new ArrayList<AwardSponsorTerm>());
        }
        if (award.getSponsorContacts() == null) {
            award.setSponsorContacts(new ArrayList<AwardSponsorContact>());
        }
        if (award.getAwardFandaRate() == null) {
            award.setAwardFandaRate(new ArrayList<AwardFandaRate>());
        }
        if (award.getAwardDirectFandADistributions() == null) {
            award.setAwardDirectFandADistributions(new ArrayList<AwardDirectFandADistribution>());
        }
        if (award.getAwardApprovedSubawards() == null) {
            award.setAwardApprovedSubawards(new ArrayList<AwardApprovedSubaward>());
        }
        if (award.getKeywords() == null) {
            award.setKeywords(new ArrayList<AwardScienceKeyword>());
        }
        if (award.getProjectPersons() == null) {
            award.setProjectPersons(new ArrayList<AwardPerson>());
        }
        if (award.getAwardUnitContacts() == null) {
            award.setAwardUnitContacts(new ArrayList<AwardUnitContact>());
        }
        if (award.getSpecialReviews() == null) {
            award.setSpecialReviews(new ArrayList<AwardSpecialReview>());
        }
        if (award.getApprovedEquipmentItems() == null) {
            award.setApprovedEquipmentItems(new ArrayList<AwardApprovedEquipment>());
        }
        if (award.getPaymentScheduleItems() == null) {
            award.setPaymentScheduleItems(new ArrayList<AwardPaymentSchedule>());
        }
        if (award.getAwardTransferringSponsors() == null) {
            award.setAwardTransferringSponsors(new ArrayList<AwardTransferringSponsor>());
        }
        if (award.getAwardCloseoutItems() == null) {
            award.setAwardCloseoutItems(new ArrayList<AwardCloseout>());
        }
        if (award.getAwardCloseoutNewItems() == null) {
            award.setAwardCloseoutNewItems(new ArrayList<AwardCloseout>());
        }
        if (award.getAwardNotepads() == null) {
            award.setAwardNotepads(new ArrayList<AwardNotepad>());
        }
        if (award.getAwardAttachments() == null) {
            award.setAttachments(new ArrayList<AwardAttachment>());
        }
        if (award.getAwardBudgetLimits() == null) {
            award.setAwardBudgetLimits(new ArrayList<AwardBudgetLimit>());
        }
        if (award.getAwardCustomDataList() == null) {
            award.setAwardCustomDataList(new ArrayList<AwardCustomData>());
        }
        if (award.getAwardCfdas() == null) {
            award.setAwardCfdas(new ArrayList<AwardCfda>());
        }
        award.setProjectEndDate(awardDto.getProjectEndDate());
        if (award.getAwardNumber() == null) {
            award.setAwardNumber("000000-00000");
        }
        award.setSequenceNumber(1);
        award.setApprovedEquipmentIndicator("N");
        award.setApprovedForeignTripIndicator("N");
        award.setSubContractIndicator("N");
        award.setCostSharingIndicator("N");
        award.setIdcIndicator("N");
        award.setPaymentScheduleIndicator("N");
        award.setScienceCodeIndicator("N");
        award.setSpecialReviewIndicator("N");
        award.setTransferSponsorIndicator("N");
        award.setCurrentActionComments("");
        award.setNewVersion(false);
        award.setAwardSequenceStatus(VersionStatus.PENDING.name());
    }

    protected List<AwardDto> translateAwards(boolean includeBudgets, List<Award> awards) {
        return awards.stream().map(award -> this.translateAward(includeBudgets, (Award)award)).collect(Collectors.toList());
    }

    protected AwardDto translateAward(boolean includeBudgets, Award award) {
        AwardDto awardDto = this.getAwardApiService().convertAwardToDto(award);
        if (!includeBudgets) {
            awardDto.setBudgets(new ArrayList<AwardBudgetExtDto>());
        }
        return awardDto;
    }

    public AwardDao getAwardDao() {
        return this.awardDao;
    }
}

