/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.period;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="budgetPeriodLookupableHelperService")
@Scope(value="prototype")
@Lazy
public class BudgetPeriodLookupableHelperServiceImpl
extends KcKualiLookupableHelperServiceImpl {
    @Autowired
    @Qualifier(value="awardBudgetService")
    protected AwardBudgetService awardBudgetService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        String awardNumber = fieldValues.get("budgetParentId");
        List<BudgetPeriod> budgetPeriods = this.getAwardBudgetService().findBudgetPeriodsFromLinkedProposal(awardNumber);
        this.filterSearchResults(budgetPeriods, fieldValues);
        return budgetPeriods;
    }

    protected void filterSearchResults(List<BudgetPeriod> budgetPeriods, Map<String, String> fieldValues) {
        String instPropNumber = fieldValues.get("institutionalProposalNumber");
        String instPropVersion = fieldValues.get("institutionalProposalVersion");
        String budgetPeriod = fieldValues.get("budgetPeriod");
        String totalCost = fieldValues.get("totalCost");
        String directCost = fieldValues.get("totalDirectCost");
        String indirectCost = fieldValues.get("totalIndirectCost");
        String costSharingAmt = fieldValues.get("costSharingAmount");
        String underrecoveryAmount = fieldValues.get("underrecoveryAmount");
        String comments = fieldValues.get("comments");
        ListIterator<BudgetPeriod> iter = budgetPeriods.listIterator();
        while (iter.hasNext()) {
            BudgetPeriod period = iter.next();
            if (StringUtils.isNotBlank((CharSequence)instPropNumber) && !StringUtils.equals((CharSequence)instPropNumber, (CharSequence)period.getInstitutionalProposalNumber())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)instPropVersion) && !StringUtils.equals((CharSequence)instPropVersion, (CharSequence)period.getInstitutionalProposalVersion().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)budgetPeriod) && !StringUtils.equals((CharSequence)budgetPeriod, (CharSequence)period.getBudgetPeriod().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)totalCost) && !StringUtils.equals((CharSequence)totalCost, (CharSequence)period.getTotalCost().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)directCost) && !StringUtils.equals((CharSequence)directCost, (CharSequence)period.getTotalDirectCost().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)indirectCost) && !StringUtils.equals((CharSequence)indirectCost, (CharSequence)period.getTotalIndirectCost().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)costSharingAmt) && !StringUtils.equals((CharSequence)costSharingAmt, (CharSequence)period.getCostSharingAmount().toString())) {
                iter.remove();
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)underrecoveryAmount) && !StringUtils.equals((CharSequence)underrecoveryAmount, (CharSequence)period.getUnderrecoveryAmount().toString())) {
                iter.remove();
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)comments) || StringUtils.equals((CharSequence)comments, (CharSequence)period.getComments())) continue;
            iter.remove();
        }
    }

    protected AwardBudgetService getAwardBudgetService() {
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }
}

