/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.person;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.person.KcPersonContract;
import org.kuali.coeus.common.framework.contact.Contactable;
import org.kuali.coeus.common.framework.person.attr.KcPersonExtendedAttributes;
import org.kuali.coeus.common.framework.person.attr.PersonAppointment;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.address.EntityAddressContract;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationContract;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenshipContract;
import org.kuali.rice.kim.api.identity.email.EntityEmailContract;
import org.kuali.rice.kim.api.identity.employment.EntityEmploymentContract;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityContract;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierContract;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.api.identity.personal.EntityBioDemographicsContract;
import org.kuali.rice.kim.api.identity.phone.EntityPhoneContract;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoContract;
import org.kuali.rice.krad.bo.TransientBusinessObjectBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;

public class KcPerson
extends TransientBusinessObjectBase
implements Contactable,
KcPersonContract,
Inactivatable {
    private static final long serialVersionUID = 1L;
    private String personId;
    private transient IdentityService identityService;
    private EntityContract entity = Entity.Builder.create();
    private transient BusinessObjectService boService;
    private KcPersonExtendedAttributes extendedAttributes = new KcPersonExtendedAttributes();
    private transient CountryService countryService;
    private static final Logger LOG = LogManager.getLogger(KcPerson.class);

    public static KcPerson fromPersonId(String personId) {
        if (StringUtils.isEmpty((CharSequence)personId)) {
            throw new IllegalArgumentException("the principalId is empty");
        }
        KcPerson person = new KcPerson();
        person.personId = personId;
        person.refreshEntity();
        person.refreshExtendedAttributes();
        return person;
    }

    public static KcPerson fromExtendedAttributes(KcPersonExtendedAttributes extendedAttributes) {
        if (extendedAttributes == null) {
            throw new IllegalArgumentException("the extendedAttributes is null");
        }
        if (StringUtils.isEmpty((CharSequence)extendedAttributes.getPersonId())) {
            throw new IllegalArgumentException("the extendedAttributes.personId is empty");
        }
        KcPerson person = new KcPerson();
        person.personId = extendedAttributes.getPersonId();
        person.extendedAttributes = extendedAttributes;
        person.refreshEntity();
        return person;
    }

    public static KcPerson fromEntityAndPersonId(EntityContract entity, String personId) {
        if (entity == null) {
            IllegalArgumentException e = new IllegalArgumentException("the entity is null; behavior change: returning empty KcPerson reference instead of throwing an IllegalArgumentException: personId=" + personId);
            LOG.info(e.getMessage(), (Throwable)e);
            return KcPerson.fromPersonId(personId);
        }
        if (StringUtils.isEmpty((CharSequence)personId)) {
            throw new IllegalArgumentException("the personId is empty");
        }
        KcPerson person = new KcPerson();
        boolean contains = false;
        for (PrincipalContract principal : entity.getPrincipals()) {
            if (!personId.equals(principal.getPrincipalId())) continue;
            contains = true;
            break;
        }
        if (!contains) {
            throw new IllegalArgumentException("the entity " + String.valueOf(entity) + " does not have a principal with id " + personId);
        }
        person.personId = personId;
        person.entity = entity;
        person.refreshExtendedAttributes();
        return person;
    }

    public static KcPerson fromEntityAndUserName(EntityContract entity, String userName) {
        if (entity == null) {
            throw new IllegalArgumentException("the entity is null");
        }
        if (StringUtils.isEmpty((CharSequence)userName)) {
            throw new IllegalArgumentException("the userName is empty");
        }
        KcPerson person = new KcPerson();
        boolean contains = false;
        for (PrincipalContract principal : entity.getPrincipals()) {
            if (!userName.equalsIgnoreCase(principal.getPrincipalName())) continue;
            contains = true;
            person.personId = principal.getPrincipalId();
            break;
        }
        if (!contains) {
            throw new IllegalArgumentException("the entity " + String.valueOf(entity) + " does not have a principal name " + userName);
        }
        person.entity = entity;
        person.refreshExtendedAttributes();
        return person;
    }

    public void refresh() {
        this.refreshEntity();
        this.refreshExtendedAttributes();
    }

    private void refreshEntity() {
        this.entity = this.getIdentityService().getEntityByPrincipalId(this.personId);
        if (this.entity == null) {
            this.entity = Entity.Builder.create();
        }
    }

    private void refreshExtendedAttributes() {
        this.extendedAttributes = (KcPersonExtendedAttributes)this.getBusinessObjectService().findByPrimaryKey(KcPersonExtendedAttributes.class, Collections.singletonMap("personId", this.personId));
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new KcPersonExtendedAttributes();
        }
    }

    public void prepareForWorkflow() {
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
        this.refreshEntity();
        this.refreshExtendedAttributes();
    }

    public String getSocialSecurityNumber() {
        return this.getExternalId("SSN");
    }

    @Override
    public String getLastName() {
        EntityNameContract name = this.entity.getDefaultName();
        if (name == null) {
            return "";
        }
        return name.getLastName() != null ? name.getLastName() : "";
    }

    @Override
    public String getFirstName() {
        EntityNameContract name = this.entity.getDefaultName();
        if (name == null) {
            return "";
        }
        return name.getFirstName() != null ? name.getFirstName() : "";
    }

    public String getMiddleName() {
        EntityNameContract name = this.entity.getDefaultName();
        if (name == null) {
            return "";
        }
        return name.getMiddleName() != null ? name.getMiddleName() : "";
    }

    @Override
    public String getFullName() {
        String middleName = StringUtils.isNotEmpty((CharSequence)this.getMiddleName()) ? this.getMiddleName() + " " : "";
        return (this.getFirstName() + " " + middleName + this.getLastName()).trim();
    }

    public String getPriorName() {
        return KcPerson.selectSingleValue(this.entity.getNames(), new Selector<EntityNameContract, String>(this){

            @Override
            public String notFoundValue() {
                return "";
            }

            @Override
            public String select(EntityNameContract a) {
                return a.getLastName();
            }

            @Override
            public boolean shouldSelect(EntityNameContract a) {
                return "PRIOR".equals(a.getNameType().getName()) && a.getLastName() != null;
            }
        });
    }

    public String getUserName() {
        String principalName = this.getPrincipalName();
        return principalName != null ? principalName : "";
    }

    public String getPrincipalName() {
        return this.getPrincipal() != null ? this.getPrincipal().getPrincipalName() : null;
    }

    @Override
    public String getEmailAddress() {
        return KcPerson.selectSingleValue(this.getEntityType().getEmailAddresses(), new Selector<EntityEmailContract, String>(this){

            @Override
            public String notFoundValue() {
                return "";
            }

            @Override
            public String select(EntityEmailContract a) {
                return a.getEmailAddress();
            }

            @Override
            public boolean shouldSelect(EntityEmailContract a) {
                return a.isActive() && a.isDefaultValue() && a.getEmailAddress() != null;
            }
        });
    }

    public String getDateOfBirth() {
        EntityBioDemographicsContract bio = this.entity.getBioDemographics();
        if (bio == null) {
            return "";
        }
        return bio.getBirthDate();
    }

    public Integer getAge() {
        EntityBioDemographicsContract bio = this.entity.getBioDemographics();
        if (bio == null) {
            return null;
        }
        Date birthDate = null;
        try {
            birthDate = bio.getBirthDate() != null ? org.apache.commons.lang3.time.DateUtils.parseDate((String)bio.getBirthDate(), (String[])new String[]{"mm/dd/yyyy"}) : null;
        }
        catch (ParseException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return birthDate != null ? this.calcAge(birthDate) : null;
    }

    public Integer getAgeByFiscalYear() {
        return this.extendedAttributes.getAgeByFiscalYear();
    }

    public String getGender() {
        EntityBioDemographicsContract bio = this.entity.getBioDemographics();
        if (bio == null) {
            return "";
        }
        return bio.getGenderCode() != null ? bio.getGenderCode() : "";
    }

    public String getRace() {
        return this.extendedAttributes.getRace();
    }

    public String getEducationLevel() {
        return this.extendedAttributes.getEducationLevel();
    }

    public String getDegree() {
        return this.extendedAttributes.getDegree();
    }

    public String getMajor() {
        return this.extendedAttributes.getMajor();
    }

    public Boolean getHandicappedFlag() {
        return this.extendedAttributes.getHandicappedFlag();
    }

    public String getHandicapType() {
        return this.extendedAttributes.getHandicapType();
    }

    public Boolean getVeteranFlag() {
        return this.extendedAttributes.getVeteranFlag();
    }

    public String getVeteranType() {
        return this.extendedAttributes.getVeteranType();
    }

    public String getVisaCode() {
        return this.extendedAttributes.getVisaCode();
    }

    public String getVisaType() {
        return this.extendedAttributes.getVisaType();
    }

    public String getVisaRenewalDate() {
        return this.extendedAttributes.getVisaRenewalDate() != null ? this.formatDate(this.extendedAttributes.getVisaRenewalDate()) : null;
    }

    public Boolean getHasVisa() {
        return this.extendedAttributes.getHasVisa();
    }

    public String getOfficeLocation() {
        return this.extendedAttributes.getOfficeLocation();
    }

    public String getOfficePhone() {
        return this.getPhoneNumber("WRK", true);
    }

    public String getSecondaryOfficeLocation() {
        return this.extendedAttributes.getSecondaryOfficeLocation();
    }

    public String getSecondaryOfficePhone() {
        return this.getPhoneNumber("WRK", false);
    }

    public String getSchool() {
        return this.extendedAttributes.getSchool();
    }

    public String getYearGraduated() {
        return this.extendedAttributes.getYearGraduated();
    }

    public String getDirectoryDepartment() {
        return this.extendedAttributes.getDirectoryDepartment();
    }

    public String getSaluation() {
        EntityNameContract name = this.entity.getDefaultName();
        if (name == null) {
            return "";
        }
        return name.getNameTitle() != null ? name.getNameTitle() : "";
    }

    public String getCountryOfCitizenship() {
        return KcPerson.selectSingleValue(this.entity.getCitizenships(), new Selector<EntityCitizenshipContract, String>(){

            @Override
            public String notFoundValue() {
                return "";
            }

            @Override
            public String select(EntityCitizenshipContract a) {
                return KcPerson.this.convert2DigitCountryCodeTo3Digit(a.getCountryCode());
            }

            @Override
            public boolean shouldSelect(EntityCitizenshipContract a) {
                return a.getCountryCode() != null;
            }
        });
    }

    public String getPrimaryTitle() {
        return this.extendedAttributes.getPrimaryTitle();
    }

    public String getDirectoryTitle() {
        return this.extendedAttributes.getDirectoryTitle();
    }

    public Boolean getFacultyFlag() {
        return this.hasAffiliation("FCLTY");
    }

    public Boolean getGraduateStudentStaffFlag() {
        return this.hasAffiliation("GRD_STDNT_STAFF");
    }

    public Boolean getResearchStaffFlag() {
        return this.hasAffiliation("RSRCH_STAFF");
    }

    public Boolean getServiceStaffFlag() {
        return this.hasAffiliation("SRVC_STAFF");
    }

    public Boolean getSupportStaffFlag() {
        return this.hasAffiliation("SUPPRT_STAFF");
    }

    public Boolean getOtherAcademicGroupFlag() {
        return this.hasAffiliation("OTH_ACADMC_GRP");
    }

    public Boolean getMedicalStaffFlag() {
        return this.hasAffiliation("MED_STAFF");
    }

    public Boolean getVacationAccrualFlag() {
        return this.extendedAttributes.getVacationAccrualFlag();
    }

    public Boolean getOnSabbaticalFlag() {
        return this.extendedAttributes.getOnSabbaticalFlag();
    }

    public String getIdProvided() {
        return this.extendedAttributes.getIdProvided();
    }

    public String getIdVerified() {
        return this.extendedAttributes.getIdVerified();
    }

    public String getAddressLine1() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getLine1() != null ? address.getLine1() : "";
    }

    public String getAddressLine2() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getLine2() != null ? address.getLine2() : "";
    }

    public String getAddressLine3() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getLine3() != null ? address.getLine3() : "";
    }

    public String getCity() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getCity() != null ? address.getCity() : "";
    }

    public String getCounty() {
        return this.extendedAttributes.getCounty();
    }

    public Integer getCitizenshipTypeCode() {
        return this.extendedAttributes.getCitizenshipTypeCode();
    }

    public String getState() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getStateProvinceCode() != null ? address.getStateProvinceCode() : "";
    }

    public String getPostalCode() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getPostalCode() != null ? address.getPostalCode() : "";
    }

    public String getCountryCode() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getCountryCode() != null ? this.convert2DigitCountryCodeTo3Digit(address.getCountryCode()) : "";
    }

    public String getNsfId() {
        return this.extendedAttributes.getNsfId();
    }

    public String getFaxNumber() {
        return this.getPhoneNumber("FAX");
    }

    public String getPagerNumber() {
        return this.getPhoneNumber("PGR");
    }

    public String getMobilePhoneNumber() {
        return this.getPhoneNumber("MBL");
    }

    public String getEraCommonsUserName() {
        return this.getExternalId("ERAC");
    }

    public Boolean getActive() {
        return this.entity.isActive();
    }

    public boolean isActive() {
        return this.getActive();
    }

    public String getIdentifier() {
        return this.getPersonId();
    }

    @Override
    public Unit getUnit() {
        String org = this.getOrganizationIdentifier();
        return org != null ? (Unit)this.getBusinessObjectService().findByPrimaryKey(Unit.class, Collections.singletonMap("unitNumber", org)) : null;
    }

    public Collection<Unit> getAllUnits() {
        return this.getAllUnits(false, null);
    }

    public Collection<Unit> getAllUnits(boolean filterUnits, Collection<String> includeCodes) {
        List unitNumbers = Stream.concat(this.entity.getEmploymentInformation().stream().filter(Inactivatable::isActive).filter(empInfo -> !filterUnits || empInfo.isPrimary() || includeCodes.contains(empInfo.getEntityAffiliation().getAffiliationType().getCode())).map(EntityEmploymentContract::getPrimaryDepartmentCode), this.extendedAttributes.getPersonAppointments().stream().filter(app -> DateUtils.isCurrentDateInRange(app.getStartDate(), app.getEndDate())).filter(app -> !filterUnits || includeCodes.contains(app.getAppointmentType().getAppointmentTypeCode())).map(PersonAppointment::getUnitNumber)).collect(Collectors.toList());
        return CollectionUtils.isEmpty(unitNumbers) ? Collections.emptyList() : this.getBusinessObjectService().findMatching(Unit.class, Collections.singletonMap("unitNumber", unitNumbers));
    }

    @Override
    public String getPhoneNumber() {
        return this.getOfficePhone();
    }

    @Override
    public String getContactOrganizationName() {
        return this.getUnit() != null ? this.getUnit().getUnitName() : null;
    }

    @Override
    public String getOrganizationIdentifier() {
        EntityEmploymentContract emp = this.entity.getPrimaryEmployment();
        if (emp == null) {
            return "";
        }
        return emp.getPrimaryDepartmentCode() != null ? emp.getPrimaryDepartmentCode() : "";
    }

    public String getCampusCode() {
        return this.getCampusCode(true);
    }

    BusinessObjectService getBusinessObjectService() {
        if (this.boService == null) {
            this.boService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.boService;
    }

    IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KcServiceLocator.getService(IdentityService.class);
        }
        return this.identityService;
    }

    CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = KcServiceLocator.getService(CountryService.class);
        }
        return this.countryService;
    }

    public KcPersonExtendedAttributes getExtendedAttributes() {
        return this.extendedAttributes;
    }

    private String getPhoneNumber(final String type) {
        return KcPerson.selectSingleValue(this.getEntityType().getPhoneNumbers(), new Selector<EntityPhoneContract, String>(){

            @Override
            public String notFoundValue() {
                return "";
            }

            @Override
            public String select(EntityPhoneContract a) {
                return a.getPhoneNumber();
            }

            @Override
            public boolean shouldSelect(EntityPhoneContract a) {
                return type.equals(a.getPhoneType().getCode()) && a.getPhoneNumber() != null;
            }
        });
    }

    private String getPhoneNumber(final String type, final boolean isDefault) {
        return KcPerson.selectSingleValue(this.getEntityType().getPhoneNumbers(), new Selector<EntityPhoneContract, String>(){

            @Override
            public String notFoundValue() {
                return "";
            }

            @Override
            public String select(EntityPhoneContract a) {
                return a.getPhoneNumber();
            }

            @Override
            public boolean shouldSelect(EntityPhoneContract a) {
                return type.equals(a.getPhoneType().getCode()) && isDefault == a.isDefaultValue() && a.getPhoneNumber() != null;
            }
        });
    }

    private boolean hasAffiliation(final String affilTypeCode) {
        return KcPerson.selectSingleValue(this.entity.getAffiliations(), new Selector<EntityAffiliationContract, Boolean>(){

            @Override
            public Boolean notFoundValue() {
                return Boolean.FALSE;
            }

            @Override
            public Boolean select(EntityAffiliationContract a) {
                return Boolean.TRUE;
            }

            @Override
            public boolean shouldSelect(EntityAffiliationContract a) {
                return affilTypeCode.equals(a.getAffiliationType().getCode());
            }
        });
    }

    private String getCampusCode(final boolean isDefault) {
        return KcPerson.selectSingleValue(this.entity.getAffiliations(), new Selector<EntityAffiliationContract, String>(){

            @Override
            public String notFoundValue() {
                return "";
            }

            @Override
            public String select(EntityAffiliationContract a) {
                return a.getCampusCode();
            }

            @Override
            public boolean shouldSelect(EntityAffiliationContract a) {
                return isDefault == a.isDefaultValue();
            }
        });
    }

    private String formatDate(Date dte) {
        assert (dte != null) : "the date is null";
        return this.getKCDateFormat().format(dte);
    }

    private String getExternalId(String type) {
        EntityExternalIdentifierContract extId = this.entity.getEntityExternalIdentifier(type);
        return extId != null ? extId.getExternalId() : "";
    }

    private EntityAddressContract getDefaultActiveAddress() {
        return KcPerson.selectSingleValue(this.getEntityType().getAddresses(), new Selector<EntityAddressContract, EntityAddressContract>(this){

            @Override
            public EntityAddressContract notFoundValue() {
                return EntityAddress.Builder.create();
            }

            @Override
            public EntityAddressContract select(EntityAddressContract a) {
                return a;
            }

            @Override
            public boolean shouldSelect(EntityAddressContract a) {
                return a.isActive() && a.isDefaultValue();
            }
        });
    }

    private EntityTypeContactInfoContract getEntityType() {
        EntityTypeContactInfoContract ent = this.entity.getEntityTypeContactInfoByTypeCode("PERSON");
        return ent != null ? ent : EntityTypeContactInfo.Builder.create((String)"", (String)"");
    }

    private Integer calcAge(Date dob) {
        return Integer.getInteger(DurationFormatUtils.formatPeriod((long)dob.getTime(), (long)new Date().getTime(), (String)"y"));
    }

    private String convert2DigitCountryCodeTo3Digit(String digit2) {
        Country country = this.getCountryService().getCountry(digit2);
        return country != null && country.getAlternateCode() != null ? country.getAlternateCode() : "";
    }

    private DateFormat getKCDateFormat() {
        return new SimpleDateFormat("MM/dd/yyyy");
    }

    private PrincipalContract getPrincipal() {
        return KcPerson.selectSingleValue(this.entity.getPrincipals(), new Selector<PrincipalContract, PrincipalContract>(){

            @Override
            public PrincipalContract notFoundValue() {
                return null;
            }

            @Override
            public PrincipalContract select(PrincipalContract a) {
                return a;
            }

            @Override
            public boolean shouldSelect(PrincipalContract a) {
                return KcPerson.this.personId.equals(a.getPrincipalId());
            }
        });
    }

    public String toString() {
        return "KcPerson{personId='" + this.personId + "', entity=" + String.valueOf(this.entity) + ", extendedAttributes=" + String.valueOf(this.extendedAttributes) + "}";
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void setBusinessObjectService(BusinessObjectService boService) {
        this.boService = boService;
    }

    private static <A, B> B selectSingleValue(Collection<? extends A> values, Selector<A, ? extends B> selector) {
        assert (selector != null) : "selector is null";
        if (values == null) {
            return selector.notFoundValue();
        }
        for (A a : values) {
            if (a == null || !selector.shouldSelect(a)) continue;
            return selector.select(a);
        }
        return selector.notFoundValue();
    }

    private static interface Selector<A, B> {
        public boolean shouldSelect(A var1);

        public B select(A var1);

        public B notFoundValue();
    }
}

