/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.sponsor.hierarchy;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.framework.sponsor.hierarchy.SponsorHierarchy;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="sponsorHierarchyService")
public class SponsorHierarchyServiceImpl
implements SponsorHierarchyService {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    public boolean isSponsorInHierarchy(String sponsorCode, String hierarchyName, int level, String levelName) {
        if (StringUtils.isBlank((CharSequence)sponsorCode)) {
            throw new IllegalArgumentException("The sponsorCode cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)hierarchyName)) {
            throw new IllegalArgumentException("The hierarchyName cannot be blank");
        }
        if (level < 1 || level > 10) {
            throw new IllegalArgumentException("The level must be between 1 and 10 inclusive");
        }
        if (StringUtils.isBlank((CharSequence)levelName)) {
            throw new IllegalArgumentException("The levelName cannot be blank");
        }
        return this.businessObjectService.countMatching(SponsorHierarchy.class, Map.of("sponsorCode", sponsorCode, "hierarchyName", hierarchyName, "level" + level, levelName)) > 0;
    }

    public boolean isSponsorInHierarchy(String sponsorCode, String hierarchyName) {
        if (StringUtils.isBlank((CharSequence)sponsorCode)) {
            throw new IllegalArgumentException("The sponsorCode cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)hierarchyName)) {
            throw new IllegalArgumentException("The hierarchyName cannot be blank");
        }
        return this.businessObjectService.countMatching(SponsorHierarchy.class, Map.of("sponsorCode", sponsorCode, "hierarchyName", hierarchyName)) > 0;
    }

    public boolean isSponsorNihMultiplePi(String sponsorCode) {
        return this.areAllSponsorsMultiPi() != false || this.isSponsorInHierarchy(sponsorCode, "NIH Multiple PI");
    }

    public boolean isSponsorKcoiPhs(String sponsorCode) {
        return this.areAllSponsorsMultiPi() == false && this.isSponsorInHierarchy(sponsorCode, "KCOI PHS");
    }

    @Deprecated
    public boolean isSponsorNihOsc(String sponsorCode) {
        return this.isSponsorInHierarchy(sponsorCode, "NIH Other Significant Contributor");
    }

    protected Boolean areAllSponsorsMultiPi() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "ALL_SPONSOR_HIERARCHY_AS_NIH");
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

