/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.training;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.common.framework.person.attr.PersonTraining;
import org.kuali.coeus.common.impl.training.dto.PersonTrainingDto;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.kra.bo.TrainingModule;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api/v1"})
@Controller(value="trainingController")
public class TrainingController
extends RestController {
    public static final String PERSON_ID = "personId";
    public static final String MODULE_CODE = "moduleCode";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;

    @RequestMapping(method={RequestMethod.GET}, value={"/person-training-modules/{personId}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    List<PersonTrainingDto> getTrainingForPerson(@PathVariable String personId, @RequestParam(value="moduleCode", required=false) String moduleCode) {
        List<PersonTraining> personTrainings = this.getPersonTrainings(personId);
        if (personTrainings.size() == 0) {
            throw new ResourceNotFoundException("No trainings found for person with id " + personId);
        }
        if (moduleCode != null) {
            personTrainings = this.getPersonTrainingsForModule(moduleCode, personTrainings);
        }
        return this.convertToDto(personTrainings);
    }

    public List<PersonTraining> getPersonTrainingsForModule(String moduleCode, List<PersonTraining> personTrainings) {
        Set trainingModuleCodes = this.getTrainingModules(moduleCode).stream().map(TrainingModule::getTrainingCode).collect(Collectors.toSet());
        return personTrainings.stream().filter(personTraining -> trainingModuleCodes.contains(personTraining.getTrainingCode())).collect(Collectors.toList());
    }

    protected List<PersonTrainingDto> convertToDto(List<PersonTraining> relevant) {
        return relevant.stream().map(training -> this.commonApiService.convertObject(training, PersonTrainingDto.class)).collect(Collectors.toList());
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }

    protected List<PersonTraining> getPersonTrainings(String personId) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put(PERSON_ID, personId);
        return this.businessObjectService.findMatching(PersonTraining.class, keys);
    }

    protected List<TrainingModule> getTrainingModules(String moduleCode) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put(MODULE_CODE, moduleCode);
        return this.businessObjectService.findMatching(TrainingModule.class, keys);
    }
}

