/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.proposal.impl.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.custom.CustomDataUtils;
import org.kuali.coeus.common.framework.print.CurrentReportBean;
import org.kuali.coeus.common.proposal.impl.report.CurrentAndPendingBaseStream;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.printing.schema.CurrentAndPendingSupportDocument;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="currentProposalXmlStream")
@Scope(value="prototype")
public class CurrentProposalXmlStream
extends CurrentAndPendingBaseStream {
    private List<String> columsList;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    @Override
    public Map<String, CurrentAndPendingSupportDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, CurrentAndPendingSupportDocument> xmlObjectList = new LinkedHashMap<String, CurrentAndPendingSupportDocument>();
        CurrentAndPendingSupportDocument currentAndPendingSupportDocument = (CurrentAndPendingSupportDocument)CurrentAndPendingSupportDocument.Factory.newInstance();
        CurrentAndPendingSupportDocument.CurrentAndPendingSupport currentAndPendingSupport = (CurrentAndPendingSupportDocument.CurrentAndPendingSupport)CurrentAndPendingSupportDocument.CurrentAndPendingSupport.Factory.newInstance();
        List currentReportBeans = (List)reportParameters.get("Current Report Beans");
        CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentReportCEColumnNames currentReportCEColumnNames = this.getPendingSupportCustomColumnName(currentReportBeans);
        CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport[] currentSupports = this.getCurrentSupportInformation(currentReportBeans);
        currentAndPendingSupport.setPersonName((String)reportParameters.get("reportPersonName"));
        currentAndPendingSupport.setCurrentSupportArray(currentSupports);
        currentAndPendingSupport.setCurrentReportCEColumnNames(currentReportCEColumnNames);
        currentAndPendingSupportDocument.setCurrentAndPendingSupport(currentAndPendingSupport);
        xmlObjectList.put("Current Report", currentAndPendingSupportDocument);
        return xmlObjectList;
    }

    private CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentReportCEColumnNames getPendingSupportCustomColumnName(List<CurrentReportBean> currentReportBeans) {
        CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentReportCEColumnNames currentReportCEColumnNames = (CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentReportCEColumnNames)CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentReportCEColumnNames.Factory.newInstance();
        this.columsList = new ArrayList<String>();
        String columName = "";
        for (CurrentReportBean bean : currentReportBeans) {
            if (bean.getAwardCustomDataList() == null) continue;
            for (AwardCustomData awardcutomdata : bean.getAwardCustomDataList()) {
                if (awardcutomdata.getCustomAttribute() != null) {
                    columName = awardcutomdata.getCustomAttribute().getLabel();
                }
                if (this.columsList.contains(columName)) continue;
                this.columsList.add(columName);
            }
        }
        for (int columnLabelIndex = 0; columnLabelIndex < this.columsList.size(); ++columnLabelIndex) {
            if (columnLabelIndex == 0) {
                currentReportCEColumnNames.setCEColumnName1(this.columsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 1) {
                currentReportCEColumnNames.setCEColumnName2(this.columsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 2) {
                currentReportCEColumnNames.setCEColumnName3(this.columsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 3) {
                currentReportCEColumnNames.setCEColumnName4(this.columsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 4) {
                currentReportCEColumnNames.setCEColumnName5(this.columsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 5) {
                currentReportCEColumnNames.setCEColumnName6(this.columsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 6) {
                currentReportCEColumnNames.setCEColumnName7(this.columsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 7) {
                currentReportCEColumnNames.setCEColumnName8(this.columsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 8) {
                currentReportCEColumnNames.setCEColumnName9(this.columsList.get(columnLabelIndex));
            }
            if (columnLabelIndex != 9) continue;
            currentReportCEColumnNames.setCEColumnName10(this.columsList.get(columnLabelIndex));
        }
        return currentReportCEColumnNames;
    }

    private CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport[] getCurrentSupportInformation(List<CurrentReportBean> currentReportBeans) {
        ArrayList<CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport> currentSupports = new ArrayList<CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport>();
        this.parameterService = this.getParameterService();
        String directIndirectEnabledValue = this.parameterService.getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        for (CurrentReportBean bean : currentReportBeans) {
            HashMap<String, String> cutomDataValueMap = new HashMap<String, String>();
            CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport currentSupport = (CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport)CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport.Factory.newInstance();
            currentSupports.add(currentSupport);
            if (bean.getAcademicYearEffort() != null) {
                currentSupport.setAcademicYearEffort(bean.getAcademicYearEffort().bigDecimalValue());
            }
            if (bean.getCalendarYearEffort() != null) {
                currentSupport.setCalendarYearEffort(bean.getCalendarYearEffort().bigDecimalValue());
            }
            if (bean.getTotalEffort() != null) {
                currentSupport.setPercentageEffort(bean.getTotalEffort().bigDecimalValue());
            }
            if (bean.getSummerEffort() != null) {
                currentSupport.setSummerYearEffort(bean.getSummerEffort().bigDecimalValue());
            }
            if (bean.getRoleCode() != null) {
                currentSupport.setPI(bean.getRoleCode());
            }
            if (bean.getAwardAmount() != null) {
                currentSupport.setAwardAmount(bean.getAwardAmount().bigDecimalValue());
            }
            if (bean.getProjectEndDate() != null) {
                currentSupport.setEndDate(this.dateTimeService.getCalendar((Date)bean.getProjectEndDate()));
            }
            if (bean.getAwardTitle() != null) {
                currentSupport.setTitle(bean.getAwardTitle());
            }
            if (bean.getProjectStartDate() != null) {
                currentSupport.setEffectiveDate(this.dateTimeService.getCalendar((Date)bean.getProjectStartDate()));
            }
            if (bean.getSponsorAwardNumber() != null) {
                currentSupport.setSponsorAwardNumber(bean.getSponsorAwardNumber());
            }
            if (bean.getSponsorName() != null) {
                currentSupport.setAgency(bean.getSponsorName());
            }
            if (bean.getTotalDirectCostTotal() != null && directIndirectEnabledValue.equals("1")) {
                currentSupport.setTotalDirectCost(bean.getTotalDirectCostTotal().bigDecimalValue());
            }
            if (bean.getTotalIndirectCostTotal() != null && directIndirectEnabledValue.equals("1")) {
                currentSupport.setTotalIndirectCost(bean.getTotalIndirectCostTotal().bigDecimalValue());
            }
            if (bean.getAwardCustomDataList() == null) continue;
            ArrayList<CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport.CurrentReportCEColomnValues> currentReportCEColomnValues = new ArrayList<CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport.CurrentReportCEColomnValues>();
            for (AwardCustomData awardCustomData : bean.getAwardCustomDataList()) {
                if (awardCustomData.getCustomAttribute() == null || awardCustomData.getValue() == null || awardCustomData.getCustomAttribute().getLabel() == null) continue;
                cutomDataValueMap.put(awardCustomData.getCustomAttribute().getLabel(), CustomDataUtils.getFormattedValueString(awardCustomData));
            }
            for (String s : this.columsList) {
                CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport.CurrentReportCEColomnValues currentReportCEColumnValue = (CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport.CurrentReportCEColomnValues)CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport.CurrentReportCEColomnValues.Factory.newInstance();
                if (cutomDataValueMap.get(s) != null) {
                    currentReportCEColumnValue.setCurrentReportCEColumnValue((String)cutomDataValueMap.get(s));
                } else {
                    currentReportCEColumnValue.setCurrentReportCEColumnValue("");
                }
                currentReportCEColomnValues.add(currentReportCEColumnValue);
            }
            currentSupport.setCurrentReportCEColomnValuesArray(currentReportCEColomnValues.toArray(new CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport.CurrentReportCEColomnValues[0]));
        }
        return currentSupports.toArray(new CurrentAndPendingSupportDocument.CurrentAndPendingSupport.CurrentSupport[0]);
    }
}

