/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.question;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.kuali.coeus.common.questionnaire.framework.question.Question;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionMultiChoice;
import org.kuali.rice.core.api.util.collect.CollectionUtils;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.util.ActionFormUtilMap;
import org.kuali.rice.kns.web.struts.form.KualiMaintenanceForm;

public class QuestionMaintenanceForm
extends KualiMaintenanceForm {
    private static final Pattern INDEX_PATTERN = Pattern.compile("(document.newMaintainableObject.businessObject.questionMultiChoices\\Q[\\E)(\\d+)(\\Q]\\E.+)");
    private QuestionMultiChoice newQuestionMultiChoice;
    private static final long serialVersionUID = -627714142076110160L;

    public void populate(HttpServletRequest request) {
        Question question;
        int index = this.getLargestMultiChoiceIndex(CollectionUtils.toIterable((Enumeration)request.getParameterNames()));
        if (index != -1 && this.getDocument() != null) {
            question = (Question)((MaintenanceDocument)this.getDocument()).getNewMaintainableObject().getBusinessObject();
            question.setQuestionMultiChoices(new ArrayList<QuestionMultiChoice>());
            for (int i = question.getQuestionMultiChoices().size(); i <= index; ++i) {
                question.getQuestionMultiChoices().add(new QuestionMultiChoice());
            }
        }
        super.populate(request);
        if (this.getActionFormUtilMap() != null && this.getActionFormUtilMap() instanceof ActionFormUtilMap) {
            ((ActionFormUtilMap)this.getActionFormUtilMap()).setCacheValueFinderResults(false);
        }
        if (this.getDocument() != null) {
            question = (Question)((MaintenanceDocument)this.getDocument()).getNewMaintainableObject().getBusinessObject();
            if (Long.valueOf(100L).equals(question.getQuestionTypeId())) {
                question.setDisplayedAnswers(question.getQuestionMultiChoices().size());
            }
        }
    }

    public boolean isPropertyEditable(String propertyName) {
        if (propertyName.startsWith("document.newMaintainableObject.businessObject.questionMultiChoices")) {
            return super.isPropertyEditable("document.newMaintainableObject.businessObject.questionMultiChoices");
        }
        return super.isPropertyEditable(propertyName);
    }

    private int getLargestMultiChoiceIndex(Iterable<String> parameterNames) {
        int i = -1;
        for (String name : parameterNames) {
            int index;
            Matcher indexMatcher = INDEX_PATTERN.matcher(name);
            if (!indexMatcher.matches() || indexMatcher.groupCount() <= 1 || (index = Integer.valueOf(indexMatcher.group(2)).intValue()) <= i) continue;
            i = index;
        }
        return i;
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        if (this.isReadOnly() && workflowDocument.isInitiated()) {
            this.getDocInfo().clear();
        }
    }

    public QuestionMultiChoice getNewQuestionMultiChoice() {
        return this.newQuestionMultiChoice;
    }

    public void setNewQuestionMultiChoice(QuestionMultiChoice newQuestionMultiChoice) {
        this.newQuestionMultiChoice = newQuestionMultiChoice;
    }
}

